/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanChangePasswordFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private EPersonConverter ePersonConverter;
    private AuthorizationFeature canChangePasswordFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.canChangePasswordFeature = this.authorizationFeatureService.find("canChangePassword");
    }

    @Test
    public void testCanChangePasswordFeatureWithAdmin() throws Exception {
        EPersonRest adminRest = this.ePersonConverter.convert(this.admin, DefaultProjection.DEFAULT);
        Authorization authorization = new Authorization(this.admin, this.canChangePasswordFeature, (BaseObjectRest)adminRest);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorization))));
    }

    @Test
    public void testCanChangePasswordFeatureWithNotAdmin() throws Exception {
        EPersonRest ePersonRest = this.ePersonConverter.convert(this.eperson, DefaultProjection.DEFAULT);
        Authorization authorization = new Authorization(this.eperson, this.canChangePasswordFeature, (BaseObjectRest)ePersonRest);
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorization))));
    }

    @Test
    public void testCanChangePasswordFeatureIfAdminImpersonatingAnotherUser() throws Exception {
        EPersonRest ePersonRest = this.ePersonConverter.convert(this.eperson, DefaultProjection.DEFAULT);
        Authorization authorization = new Authorization(this.eperson, this.canChangePasswordFeature, (BaseObjectRest)ePersonRest);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authorization.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

