/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedList;
import java.util.UUID;
import org.dspace.app.rest.model.PageRest;
import org.dspace.app.rest.model.SearchEventRest;
import org.dspace.app.rest.model.SearchResultsRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SearchEventRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findAllTestThrowNotImplementedException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/statistics/searchevents", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void findOneTestThrowNotImplementedException() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/statistics/searchevents/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(405));
    }

    @Test
    public void postTestSucces() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "desc");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestNullPageBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "desc");
        searchEventRest.setSort(sort);
        searchEventRest.setPage(null);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void postTestNullSortBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        searchEventRest.setSort(null);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void postTestSortInvalidOrderBadRequestException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "azertre");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void postTestSuccesUppercaseSortOrder() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "DESC");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestSuccesNoAppliedFilters() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "desc");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestSuccesEmptyQuery() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setScope(publicItem1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "desc");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestWithClickedObjectSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(col1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        searchEventRest.setClickedObject(publicItem1.getID());
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "desc");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void postTestWithClickedObjectNotExisting() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").build();
        Item publicItem1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        SearchEventRest searchEventRest = new SearchEventRest();
        searchEventRest.setQuery("test");
        searchEventRest.setScope(col1.getID());
        searchEventRest.setConfiguration("default");
        searchEventRest.setDsoType("item");
        searchEventRest.setClickedObject(UUID.randomUUID());
        SearchResultsRest.Sorting sort = new SearchResultsRest.Sorting("title", "desc");
        searchEventRest.setSort(sort);
        PageRest pageRest = new PageRest(5, 20, 4, 1);
        searchEventRest.setPage(pageRest);
        SearchResultsRest.AppliedFilter appliedFilter = new SearchResultsRest.AppliedFilter("author", "contains", "test", "test");
        LinkedList<SearchResultsRest.AppliedFilter> appliedFilterList = new LinkedList<SearchResultsRest.AppliedFilter>();
        appliedFilterList.add(appliedFilter);
        searchEventRest.setAppliedFilters(appliedFilterList);
        ObjectMapper mapper = new ObjectMapper();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/statistics/searchevents", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)searchEventRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

