/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.ClaimedTaskMatcher;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.PoolTaskMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.matcher.WorkflowStepMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.PoolTaskBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.state.actions.processingaction.SelectReviewerAction;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class TaskRestRepositoriesIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private XmlWorkflowFactory xmlWorkflowFactory;
    @Autowired
    GroupService groupService;

    @Test
    public void findOnePoolTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findOnePoolUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)this.admin).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOnePoolForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findByUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(authReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-18", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        String authReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(authReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        String authAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-18", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(authAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(authAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
    }

    @Test
    public void findByUserForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem1 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem2 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem3 = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col2).withTitle("Workflow Item 3").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String authReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(authReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        String authReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(authReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByUserUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deletePoolTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)this.admin).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void claimTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))})));
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void claimTaskUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void claimTaskForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void claimTaskNotExistingTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/2147483647")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findOneClaimedTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findOneClaimedTaskUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findOneClaimedTaskForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer, reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void unclaimTaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"pooltask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void unclaimTaskAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"pooltask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void unclaimTaskUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void unclaimTaskForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer, reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void unclaimTaskNotExistingTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/api/workflow/claimedtasks/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findClaimedByUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 2").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry2").build();
        ClaimedTask claimedTask3 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 3").withIssueDate("2017-10-19").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry3").build();
        XmlWorkflowItem witem1 = claimedTask1.getWorkflowItem();
        XmlWorkflowItem witem2 = claimedTask2.getWorkflowItem();
        XmlWorkflowItem witem3 = claimedTask3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask1, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask2, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-18", "ExtraEntry2"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask3, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-19", "ExtraEntry3"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask1, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry")))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask2, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-18", "ExtraEntry2"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask3, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-19", "ExtraEntry3"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findClaimedByUserForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 2").withIssueDate("2017-10-18").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry2").build();
        ClaimedTask claimedTask3 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 3").withIssueDate("2017-10-19").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry3").build();
        XmlWorkflowItem witem1 = claimedTask1.getWorkflowItem();
        XmlWorkflowItem witem2 = claimedTask2.getWorkflowItem();
        XmlWorkflowItem witem3 = claimedTask3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findClaimedByUserUnauthorizedTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void approvalTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void approvalForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void rejectTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String submitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/findBySubmitter", (Object[])new Object[0]).param("size", new String[]{"20"}).param("uuid", new String[]{submitter.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workspaceitems", (Matcher)Matchers.contains((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(null, "Workflow Item 1", "2017-10-17", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void rejectForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void undefinedActionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewerToken = this.getAuthToken(reviewer.getEmail(), this.password);
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0]).param("submit_undefinedaction", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewerToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + claimedTask.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void actionOnNotExistingClaimedTaskTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks/2147483647", (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void fullWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        Step step = this.xmlWorkflowFactory.getStepByName("reviewstep");
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        WorkflowActionConfig workflowAction = this.xmlWorkflowFactory.getActionByName("reviewaction");
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        step = this.xmlWorkflowFactory.getStepByName("editstep");
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        workflowAction = this.xmlWorkflowFactory.getActionByName("editaction");
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        step = this.xmlWorkflowFactory.getStepByName("finaleditstep");
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        workflowAction = this.xmlWorkflowFactory.getActionByName("finaleditaction");
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void defaultWorkflowTest_UntilReviewStep_Reject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the reject in review step"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilReviewStep_NonValidOption_EditMetadata() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_edit_metadata", new String[]{"true"}).param("reason", new String[]{"I need to test the submit_edit_metadata"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void defaultWorkflowTest_UntilEditStep_Reject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test the submit_reject in edit step"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilEditStep_NonValidOption() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        AtomicReference idRefClaimedTask = new AtomicReference();
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_non_valid_option", new String[]{"true"}).param("reason", new String[]{"I need to test an unvalid option"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilFinalEditStep_Reject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_reject", new String[]{"true"}).param("reason", new String[]{"I need to test reject in fina edit step"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void defaultWorkflowTest_UntilFinalEditStep_EditMetadata() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_edit_metadata", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void defaultWorkflowTest_UntilFinalEditStep_NonValidOption() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(3, new EPerson[]{reviewer3}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "finaleditstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_non_valid_option", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void unclaimedTaskTest_Upload_EditMetadataOptionAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = poolTask.getWorkflowItem();
        poolTask.setStepID("editstep");
        poolTask.setActionID("editaction");
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test.bib", "application/x-bibtex", bibtex);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        bibtex.close();
    }

    @Test
    public void unclaimedTaskTest_Patch_EditMetadataOptionAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void uploadTest_ClaimedTask_EditMetadataOptionNotAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("reviewstep");
        claimedTask.setActionID("reviewaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String authToken = this.getAuthToken(reviewer1.getEmail(), this.password);
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test.bib", "application/x-bibtex", bibtex);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        bibtex.close();
    }

    @Test
    public void patchTest_ClaimedTask_EditMetadataOptionNotAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test item full workflow", "2019-03-06", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))})));
        String authToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        ArrayList<Operation> updateTitle = new ArrayList<Operation>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("value", "New Title");
        updateTitle.add((Operation)new ReplaceOperation("/sections/traditionalpageone/dc.title/0", value));
        String patchBody = this.getPatchContent(updateTitle);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void claimedTaskTest_Upload_EditMetadataOptionAllowed() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        claimedTask.setStepID("editstep");
        claimedTask.setActionID("editaction");
        XmlWorkflowItem witem = claimedTask.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        InputStream bibtex = ((Object)((Object)this)).getClass().getResourceAsStream("bibtex-test.bib");
        MockMultipartFile bibtexFile = new MockMultipartFile("file", "bibtex-test.bib", "application/x-bibtex", bibtex);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)("/api/workflow/workflowitems/" + witem.getID()), (Object[])new Object[0]).file(bibtexFile)).andExpect(MockMvcResultMatchers.status().isCreated());
        bibtex.close();
    }

    @Test
    public void findAllPooltasksByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        PoolTask poolTask2 = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 2").withIssueDate("2020-01-19").withAuthor("Tommaso, Donald").withAuthor("Shon, John").withSubject("ExtraEntry").build();
        Item item2 = poolTask2.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{item2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask2.getWorkflowItem(), "Workflow Item 2", "2020-01-19", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllPooltasksByItemUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllPooltasksByItemForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        String tokenSubmitter = this.getAuthToken(submitter.getEmail(), this.password);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllPooltasksByItemWrongUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        String tokenSubmitter = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findAllPooltasksByItemBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, this.admin}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        String tokenSubmitter = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{"wrongID"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findPooltaskByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        PoolTask poolTask2 = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 2").withIssueDate("2020-01-19").withAuthor("Tommaso, Donald").withAuthor("Shon, John").withSubject("ExtraEntry").build();
        Item item2 = poolTask2.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)poolTask.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"pooltask"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
        String tokenReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(tokenReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)poolTask2.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"pooltask"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask2, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(poolTask2.getWorkflowItem(), "Workflow Item 2", "2020-01-19", "ExtraEntry"))));
    }

    @Test
    public void findPooltaskByItemNoContentTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        PoolTask poolTask2 = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 2").withIssueDate("2020-01-19").withAuthor("Tommaso, Donald").withAuthor("Shon, John").withSubject("ExtraEntry").build();
        Item item2 = poolTask2.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        String tokenSubmitter = this.getAuthToken(submitter.getEmail(), this.password);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        String tokenReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(tokenReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findPooltaskByItemWrongUuidOfItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findPooltaskByItemBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{"wrongID"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findPooltaskByItemUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        PoolTask poolTask = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Item item1 = poolTask.getWorkflowItem().getItem();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{item1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findPoolTaskByItemArchivedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2020-06-25").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{publicItem.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findAllPoolTaskByItemArchivedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2020-06-25").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{publicItem.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findAllClaimedTaskByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 2").withIssueDate("2020-10-20").withAuthor("Tommaso, Donald").withAuthor("Shon, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask1, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(claimedTask1.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask2.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$", (Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask2, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(claimedTask2.getWorkflowItem(), "Workflow Item 2", "2020-10-20", "ExtraEntry"))))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    public void findAllClaimedTaskByItemForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenSubmitter = this.getAuthToken(submitter.getEmail(), this.password);
        String tokenReviewer1 = this.getAuthToken(reviewer1.getEmail(), this.password);
        String tokenReviewer2 = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(tokenSubmitter).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenReviewer1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenReviewer2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findAllClaimedTaskByItemUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findAllClaimedTaskByItemWrongUUIDTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findAllClaimedTaskByItemBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{"wrongID"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findAllClaimedTaskByItemArchivedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2020-06-25").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findAllByItem", (Object[])new Object[0]).param("uuid", new String[]{publicItem.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findClaimedTaskByItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 2").withIssueDate("2020-10-19").withAuthor("Tommaso, Donald").withAuthor("Shon, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)claimedTask1.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask1, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(claimedTask1.getWorkflowItem(), "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask2.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)claimedTask2.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)ClaimedTaskMatcher.matchClaimedTask(claimedTask2, "reviewstep")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(claimedTask2.getWorkflowItem(), "Workflow Item 2", "2020-10-19", "ExtraEntry"))));
    }

    @Test
    public void findClaimedTaskByItemNoContentTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1, reviewer2}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 2").withWorkflowGroup(1, new EPerson[]{reviewer2}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask1 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        ClaimedTask claimedTask2 = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col2, (EPerson)reviewer2).withTitle("Workflow Item 2").withIssueDate("2020-10-19").withAuthor("Tommaso, Donald").withAuthor("Shon, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String submitterToken = this.getAuthToken(submitter.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask2.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask2.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask1.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(submitterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask2.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findClaimedTaskByItemUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{claimedTask.getWorkflowItem().getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findClaimedTaskByItemWrongUuidTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void findClaimedTaskByItemBadRequestTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        ClaimedTask claimedTask = ClaimedTaskBuilder.createClaimedTask((Context)this.context, (Collection)col1, (EPerson)reviewer1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{"wrongID"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findClaimedTaskByItemArchivedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).build();
        Item publicItem = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item").withIssueDate("2020-06-25").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{publicItem.getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findPooltaksByItemInWorkflowWithoutPooltaskTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        EPerson reviewer = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer}).build();
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Workflow Item").withIssueDate("2010-04-24").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByItem", (Object[])new Object[0]).param("uuid", new String[]{witem.getItem().getID().toString()})).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void poolTaskSerchMethodWithSingleModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltask/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void claimedtaskSerchMethodWithSingleModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtask/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void poolTaskSerchMethodWithPluralModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.findByUser.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"/api/workflow/pooltasks/search/findByUser")})));
    }

    @Test
    public void claimedtaskSerchMethodWithPluralModelTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.findByUser.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"/api/workflow/claimedtasks/search/findByUser")})));
    }

    @Test
    public void addReviewerToRunningWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).build();
        EPerson reviewerOther = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewerOther@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{reviewer1}).withWorkflowGroup(2, new EPerson[]{reviewer2}).build();
        Group firstWorkflowGroup = col1.getWorkflowStep1(this.context);
        EPerson submitter = EPersonBuilder.createEPerson((Context)this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col1).withTitle("Test title").withIssueDate("2021-02-11").withSubject("ExtraEntry").build();
        Item item = witem.getItem();
        this.context.restoreAuthSystemState();
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String reviewerOtherToken = this.getAuthToken(reviewerOther.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        Step step = this.xmlWorkflowFactory.getStepByName("reviewstep");
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test title", "2021-02-11", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        Assert.assertFalse((boolean)this.groupService.isMember(this.context, reviewerOther, firstWorkflowGroup));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + firstWorkflowGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("http://localhost/api/eperson/groups/" + reviewerOther.getID())).andExpect(MockMvcResultMatchers.status().isNoContent());
        Assert.assertTrue((boolean)this.groupService.isMember(this.context, reviewerOther, firstWorkflowGroup));
        this.getClient(reviewerOtherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewerOther.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "reviewstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test title", "2021-02-11", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewerOtherToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewerOtherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewerOther.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks[0]._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test title", "2021-02-11", "ExtraEntry")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        WorkflowActionConfig workflowAction = this.xmlWorkflowFactory.getActionByName("reviewaction");
        this.getClient(reviewerOtherToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_approve", new String[]{"true"}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        step = this.xmlWorkflowFactory.getStepByName("editstep");
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/pooltasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()}).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.pooltasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(null, "editstep")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.step", WorkflowStepMatcher.matchWorkflowStepEntry(step)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Test title", "2021-02-11", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/pooltasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$._embedded.pooltasks[0].id", (Predicate[])new Predicate[0])));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + idRef.get())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
    }

    @Test
    public void selectReviewerWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson user = EPersonBuilder.createEPerson((Context)this.context).withEmail("user@example.com").withPassword(this.password).build();
        this.context.setCurrentUser(user);
        EPerson creator = EPersonBuilder.createEPerson((Context)this.context).withEmail("creator@example.com").withPassword(this.password).build();
        EPerson reviewManager1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewManager1@example.com").withPassword(this.password).build();
        EPerson reviewManager2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewManager2@example.com").withPassword(this.password).build();
        EPerson reviewManager3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewManager3@example.com").withPassword(this.password).build();
        GroupBuilder.createGroup((Context)this.context).withName("ReviewManagers").addMember(reviewManager1).addMember(reviewManager2).addMember(reviewManager3).build();
        Group reviewerGroup = GroupBuilder.createGroup((Context)this.context).withName("Reviewers").build();
        EPerson reviewer1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer1@example.com").withPassword(this.password).withGroupMembership(reviewerGroup).build();
        EPerson reviewer2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer2@example.com").withPassword(this.password).withGroupMembership(reviewerGroup).build();
        EPerson reviewer3 = EPersonBuilder.createEPerson((Context)this.context).withEmail("reviewer3@example.com").withPassword(this.password).withGroupMembership(reviewerGroup).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity, (String)"123456789/workflow-test-1").withName("Collection 1").build();
        PoolTask poolTask1 = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)collection, (EPerson)reviewManager1).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem1 = poolTask1.getWorkflowItem();
        PoolTask poolTask2 = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)collection, (EPerson)reviewManager2).withTitle("Workflow Item 2").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem2 = poolTask2.getWorkflowItem();
        PoolTask poolTask3 = PoolTaskBuilder.createPoolTask((Context)this.context, (Collection)collection, (EPerson)reviewManager3).withTitle("Workflow Item 3").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem3 = poolTask3.getWorkflowItem();
        this.context.restoreAuthSystemState();
        String reviewManager1Token = this.getAuthToken(reviewManager1.getEmail(), this.password);
        String reviewManager2Token = this.getAuthToken(reviewManager2.getEmail(), this.password);
        String reviewManager3Token = this.getAuthToken(reviewManager3.getEmail(), this.password);
        String reviewer1Token = this.getAuthToken(reviewer1.getEmail(), this.password);
        String reviewer2Token = this.getAuthToken(reviewer2.getEmail(), this.password);
        String reviewer3Token = this.getAuthToken(reviewer3.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String userToken = this.getAuthToken(user.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)PoolTaskMatcher.matchPoolTask(poolTask1, "selectReviewerStep"))));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/workflow/pooltasks/" + poolTask1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewManager1.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action.id", (Matcher)Matchers.is((Object)"selectrevieweraction")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        SelectReviewerAction.resetGroup();
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_select_reviewer", new String[]{"true"}).param("eperson", new String[]{reviewer1.getID().toString()}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer1.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action.id", (Matcher)Matchers.is((Object)"singleuserreviewaction")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{user.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewManager2Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_select_reviewer", new String[]{"true"}).param("eperson", new String[]{reviewer2.getID().toString()}).param("eperson", new String[]{reviewer3.getID().toString()}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(reviewer2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer2.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action.id", (Matcher)Matchers.is((Object)"singleuserreviewaction")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(reviewer3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer3.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action.id", (Matcher)Matchers.is((Object)"singleuserreviewaction")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(reviewer1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewer1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewer1.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action.id", (Matcher)Matchers.is((Object)"singleuserreviewaction")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem1, "Workflow Item 1", "2017-10-17", "ExtraEntry"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.not((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem2, "Workflow Item 2", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
        this.getClient(reviewManager1Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager1.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager2Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager2.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{user.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/workflow/claimedtasks", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/workflow/pooltasks/" + poolTask3.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask"))}))).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(reviewManager3Token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/workflow/claimedtasks/" + idRef.get()), (Object[])new Object[0]).param("submit_select_reviewer", new String[]{"true"}).param("eperson", new String[]{user.getID().toString()}).contentType(MediaType.APPLICATION_FORM_URLENCODED)).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{user.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(reviewManager3Token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/workflow/claimedtasks/search/findByUser", (Object[])new Object[0]).param("uuid", new String[]{reviewManager3.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.claimedtasks", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks/")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"claimedtask")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.owner", (Matcher)Matchers.is(EPersonMatcher.matchEPersonOnEmail(reviewManager3.getEmail()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.action.id", (Matcher)Matchers.is((Object)"selectrevieweraction")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.workflowitem", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem3, "Workflow Item 3", "2017-10-17", "ExtraEntry"))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/workflow/claimedtasks"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }
}

