/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.matcher.WorkflowDefinitionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class WorkflowDefinitionRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private final XmlWorkflowFactory xmlWorkflowFactory = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory();
    private static final String WORKFLOW_DEFINITIONS_ENDPOINT = "/api/config/workflowdefinitions";

    @Test
    public void getAllWorkflowDefinitionsEndpoint() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        List allConfiguredWorkflows = this.xmlWorkflowFactory.getAllConfiguredWorkflows();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_DEFINITIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)allConfiguredWorkflows.size()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)WORKFLOW_DEFINITIONS_ENDPOINT)));
    }

    @Test
    public void getAllWorkflowDefinitionsEndpoint_Pagination_Size1() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        List allConfiguredWorkflows = this.xmlWorkflowFactory.getAllConfiguredWorkflows();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_DEFINITIONS_ENDPOINT, (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)allConfiguredWorkflows.size()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowdefinitions", (Matcher)Matchers.contains(WorkflowDefinitionMatcher.matchWorkflowDefinitionEntry((Workflow)allConfiguredWorkflows.get(0))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowdefinitions", (Matcher)Matchers.not((Matcher)Matchers.contains(WorkflowDefinitionMatcher.matchWorkflowDefinitionEntry((Workflow)allConfiguredWorkflows.get(1))))));
    }

    @Test
    public void getAllWorkflowDefinitionsEndpoint_Pagination_Size1_Page1() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        List allConfiguredWorkflows = this.xmlWorkflowFactory.getAllConfiguredWorkflows();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_DEFINITIONS_ENDPOINT, (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)allConfiguredWorkflows.size()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowdefinitions", (Matcher)Matchers.contains(WorkflowDefinitionMatcher.matchWorkflowDefinitionEntry((Workflow)allConfiguredWorkflows.get(1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.workflowdefinitions", (Matcher)Matchers.not((Matcher)Matchers.contains(WorkflowDefinitionMatcher.matchWorkflowDefinitionEntry((Workflow)allConfiguredWorkflows.get(0))))));
    }

    @Test
    public void getAllWorkflowDefinitionsEndpoint_NonValidToken() throws Exception {
        String token = "NonValidToken";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_DEFINITIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getAllWorkflowDefinitionsEndpoint_NoToken() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)WORKFLOW_DEFINITIONS_ENDPOINT, (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowDefinitionByName_DefaultWorkflow() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        String workflowName = defaultWorkflow.getID();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + workflowName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)WORKFLOW_DEFINITIONS_ENDPOINT))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.equalToIgnoringCase((String)workflowName))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.isDefault", (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void getWorkflowDefinitionByName_NonDefaultWorkflow() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List allConfiguredWorkflows = this.xmlWorkflowFactory.getAllConfiguredWorkflows();
        String firstNonDefaultWorkflowName = "";
        for (Workflow workflow : allConfiguredWorkflows) {
            if (workflow.getID().equalsIgnoreCase(defaultWorkflow.getID())) continue;
            firstNonDefaultWorkflowName = workflow.getID();
        }
        if (StringUtils.isNotBlank((CharSequence)firstNonDefaultWorkflowName)) {
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + firstNonDefaultWorkflowName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)WORKFLOW_DEFINITIONS_ENDPOINT))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.equalToIgnoringCase((String)firstNonDefaultWorkflowName))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.isDefault", (Matcher)Matchers.is((Object)false)));
        }
    }

    @Test
    public void getWorkflowDefinitionByName_NonExistentWorkflow() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String workflowName = "TestNameNonExistentWorkflow9999";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + workflowName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getWorkflowDefinitionByName_DefaultWorkflow_NonValidToken() throws Exception {
        String token = "UnvalidToken";
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        String workflowName = defaultWorkflow.getID();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + workflowName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowDefinitionByName_DefaultWorkflow_NoToken() throws Exception {
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        String workflowName = defaultWorkflow.getID();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + workflowName), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getWorkflowDefinitionByCollectionId_ExistentCollection() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        Workflow workflowForThisCollection = this.xmlWorkflowFactory.getWorkflow(col1);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/search/findByCollection?uuid=" + col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.name", (Matcher)Matchers.equalToIgnoringCase((String)workflowForThisCollection.getID())));
    }

    @Test
    public void getWorkflowDefinitionByCollectionId_nonValidUUID() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String nonValidUUID = "TestNonValidUUID";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/search/findByCollection?uuid=" + nonValidUUID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.status().reason(Matchers.containsString((String)"A required parameter is invalid")));
    }

    @Test
    public void getWorkflowDefinitionByCollectionId_nonExistentCollection() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        UUID nonExistentCollectionUUID = UUID.randomUUID();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/search/findByCollection?uuid=" + nonExistentCollectionUUID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getCollectionsOfWorkflowByName_DefaultWorkflow_AllNonMappedCollections() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List allNonMappedCollections = this.xmlWorkflowFactory.getAllNonMappedCollectionsHandles(this.context);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)allNonMappedCollections.size())));
    }

    @Test
    public void getCollectionsOfWorkflowByName_DefaultWorkflow_AllNonMappedCollections_Paginated_Size1() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)child1, (String)"123456789/non-mapped-collection").withName("Collection 2").build();
        this.context.restoreAuthSystemState();
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List allNonMappedCollections = this.xmlWorkflowFactory.getAllNonMappedCollectionsHandles(this.context);
        if (allNonMappedCollections.size() > 0) {
            Collection firstNonMappedCollection = (Collection)allNonMappedCollections.get(0);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/collections"), (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)allNonMappedCollections.size()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(WorkflowDefinitionMatcher.matchCollectionEntry(firstNonMappedCollection.getName(), firstNonMappedCollection.getID(), firstNonMappedCollection.getHandle()))));
        }
    }

    @Test
    public void getCollectionsOfWorkflowByName_NonDefaultWorkflow() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1, (String)"123456789/workflow-test-1").withName("Collection 1").build();
        this.context.restoreAuthSystemState();
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List allConfiguredWorkflows = this.xmlWorkflowFactory.getAllConfiguredWorkflows();
        String firstNonDefaultWorkflowName = "";
        for (Workflow workflow : allConfiguredWorkflows) {
            if (workflow.getID().equalsIgnoreCase(defaultWorkflow.getID())) continue;
            firstNonDefaultWorkflowName = workflow.getID();
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)firstNonDefaultWorkflowName)) {
            List mappedCollections = this.xmlWorkflowFactory.getCollectionHandlesMappedToWorkflow(this.context, firstNonDefaultWorkflowName);
            if (mappedCollections.size() > 0) {
                Collection firstMappedCollection = (Collection)mappedCollections.get(0);
                this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + firstNonDefaultWorkflowName + "/collections"), (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)mappedCollections.size()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains(WorkflowDefinitionMatcher.matchCollectionEntry(firstMappedCollection.getName(), firstMappedCollection.getID(), firstMappedCollection.getHandle()))));
            } else {
                this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + firstNonDefaultWorkflowName + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.empty()));
            }
        }
    }

    @Test
    public void getCollectionsOfWorkflowByName_NonExistentWorkflow() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        String workflowName = "TestNameNonExistentWorkflow9999";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + workflowName + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void getCollectionsOfWorkflowByName_DefaultWorkflow_NoValidToken() throws Exception {
        String token = "NonValidToken";
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getCollectionsOfWorkflowByName_DefaultWorkflow_NoToken() throws Exception {
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List allNonMappedCollections = this.xmlWorkflowFactory.getAllNonMappedCollectionsHandles(this.context);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/collections"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getStepsOfWorkflowByName_DefaultWorkflow() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/steps"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)defaultWorkflow.getSteps().size())));
    }

    @Test
    public void getStepsOfWorkflowByName_DefaultWorkflow_Ordered() throws Exception {
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List steps = defaultWorkflow.getSteps();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/steps"), (Object[])new Object[0]).param("projection", new String[]{"full"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)steps.size()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.steps", (Matcher)Matchers.contains(steps.stream().map(WorkflowDefinitionMatcher::matchStep).collect(Collectors.toList()))));
    }

    @Test
    public void getStepsOfWorkflowByName_DefaultWorkflow_NoValidToken() throws Exception {
        String token = "NonValidToken";
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/steps"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getStepsOfWorkflowByName_DefaultWorkflow_NoToken() throws Exception {
        Workflow defaultWorkflow = this.xmlWorkflowFactory.getDefaultWorkflow();
        List allNonMappedCollections = this.xmlWorkflowFactory.getAllNonMappedCollectionsHandles(this.context);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/config/workflowdefinitions/" + defaultWorkflow.getID() + "/steps"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

