/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanClaimItemFeatureIT
extends AbstractControllerIntegrationTest {
    private Item profile;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private Utils utils;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    private AuthorizationFeature canClaimProfileFeature;
    private Collection personCollection;
    private String epersonToken;
    private String adminToken;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Community").build();
        this.personCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("claimableA").build();
        this.epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.context.restoreAuthSystemState();
        this.canClaimProfileFeature = this.authorizationFeatureService.find("canClaimItem");
    }

    @Test
    public void testCanClaimAProfile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail(this.eperson.getEmail()).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.profile)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void testCanClaimAProfileWithAnonymousUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.profile)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testCanClaimWithAdminUser() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail("myemail@test.it").withPersonEmail(this.admin.getEmail()).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.profile)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void testNotClaimableEntityForDifferentEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail(this.eperson.getEmail()).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.profile)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testNotClaimableEntityWithoutEmail() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.profile)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testNotClaimableEntity() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection publicationCollection = CollectionBuilder.createCollection((Context)this.context, (Community)((Community)this.context.reloadEntity((ReloadableEntity)this.parentCommunity))).withEntityType("Publication").withName("notClaimable").build();
        this.context.turnOffAuthorisationSystem();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)publicationCollection).build();
        this.getClient(this.epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(publication)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testItemAlreadyInARelation() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item ownedItem = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withDspaceObjectOwner("owner", "ownerAuthority").build();
        this.context.restoreAuthSystemState();
        this.getClient(this.epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(ownedItem)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testUserWithProfile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withPersonEmail(this.eperson.getEmail()).build();
        ItemBuilder.createItem((Context)this.context, (Collection)this.personCollection).withTitle("User").withDspaceObjectOwner("User", this.eperson.getID().toString()).build();
        this.context.restoreAuthSystemState();
        this.getClient(this.epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.uri(this.profile)}).param("feature", new String[]{this.canClaimProfileFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.equalTo((Object)0)));
    }

    private String uri(Item item) {
        ItemRest itemRest = this.itemConverter.convert(item, Projection.DEFAULT);
        return this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
    }
}

