/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class GenericAuthorizationFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    ConfigurationService configurationService;
    private Community communityA;
    private Community communityAA;
    private Community communityB;
    private Community communityBB;
    private Collection collectionX;
    private Collection collectionY;
    private Item item1;
    private Item item2;
    private Bundle bundle1;
    private Bundle bundle2;
    private Bitstream bitstream1;
    private Bitstream bitstream2;
    private Group item1AdminGroup;
    private EPerson communityAAdmin;
    private EPerson collectionXAdmin;
    private EPerson item1Admin;
    private EPerson communityAWriter;
    private EPerson collectionXWriter;
    private EPerson item1Writer;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.communityAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAAdmin@my.edu").withPassword(this.password).build();
        this.collectionXAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionXAdmin@my.edu").withPassword(this.password).build();
        this.item1Admin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Admin@my.edu").withPassword(this.password).build();
        this.communityAWriter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAWriter@my.edu").withPassword(this.password).build();
        this.collectionXWriter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionXWriter@my.edu").withPassword(this.password).build();
        this.item1Writer = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Writer@my.edu").withPassword(this.password).build();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").withAdminGroup(new EPerson[]{this.communityAAdmin}).build();
        this.communityAA = CommunityBuilder.createCommunity((Context)this.context).withName("communityAA").addParentCommunity(this.context, this.communityA).build();
        this.collectionX = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityAA).withName("collectionX").withAdminGroup(new EPerson[]{this.collectionXAdmin}).build();
        this.item1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionX).withTitle("item1").withIssueDate("2020-07-08").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("item1Entry").build();
        this.bundle1 = BundleBuilder.createBundle((Context)this.context, (Item)this.item1).withName("bundle1").build();
        try (InputStream is = IOUtils.toInputStream((String)"randomContent", (String)"UTF-8");){
            this.bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)this.bundle1, (InputStream)is).withName("bitstream1").withMimeType("text/plain").build();
        }
        this.item1AdminGroup = GroupBuilder.createGroup((Context)this.context).withName("item1AdminGroup").addMember(this.item1Admin).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(11).withGroup(this.item1AdminGroup).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityA).withAction(1).withUser(this.communityAWriter).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionX).withAction(1).withUser(this.collectionXWriter).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(1).withUser(this.item1Writer).build();
        this.communityB = CommunityBuilder.createCommunity((Context)this.context).withName("communityB").build();
        this.communityBB = CommunityBuilder.createCommunity((Context)this.context).withName("communityBB").addParentCommunity(this.context, this.communityB).build();
        this.collectionY = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityBB).withName("collectionY").build();
        this.item2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionY).withTitle("item2").withIssueDate("2020-07-08").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("item2Entry").build();
        this.bundle2 = BundleBuilder.createBundle((Context)this.context, (Item)this.item2).withName("bundle2").build();
        is = IOUtils.toInputStream((String)"randomContent", (String)"UTF-8");
        try {
            this.bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)this.bundle2, (InputStream)is).withName("bitstream2").withMimeType("text/plain").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)"true");
    }

    private void testAdminsHavePermissionsAllDso(String feature) throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String siteId = ContentServiceFactory.getInstance().getSiteService().findSite(this.context).getID().toString();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + siteId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + siteId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionY.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    private void testAdminsHavePermissionsItem(String feature) throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    private void testWriteUsersHavePermissionsAllDso(String feature, boolean hasDSOAccess) throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        if (hasDSOAccess) {
            this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        if (hasDSOAccess) {
            this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        if (hasDSOAccess) {
            this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionY.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    private void testWriteUsersHavePermissionsItem(String feature, boolean hasDSOAccess) throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        if (hasDSOAccess) {
            this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).exists());
        } else {
            this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
        }
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)("$._embedded.authorizations[?(@._embedded.feature.id=='" + feature + "')]"), (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanManagePoliciesAdmin() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canManagePolicies", false);
    }

    @Test
    public void testCanManagePoliciesWriter() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canManagePolicies", false);
    }

    @Test
    public void testCanEditMetadataAdmin() throws Exception {
        this.testAdminsHavePermissionsAllDso("canEditMetadata");
    }

    @Test
    public void testCanEditMetadataWriter() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canEditMetadata", true);
    }

    @Test
    public void testCanMoveAdmin() throws Exception {
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canMove";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        ResourcePolicy removePermission = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).withUser(this.item1Writer).build();
        this.context.restoreAuthSystemState();
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanMoveWriter() throws Exception {
        this.testWriteUsersHavePermissionsItem("canMove", false);
        this.context.turnOffAuthorisationSystem();
        ResourcePolicy removePermission = ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).withUser(this.item1Writer).build();
        this.context.restoreAuthSystemState();
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canMove')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanMakePrivateAdmin() throws Exception {
        this.testAdminsHavePermissionsItem("canMakePrivate");
    }

    @Test
    public void testCanMakePrivateWriter() throws Exception {
        this.testWriteUsersHavePermissionsItem("canMakePrivate", true);
    }

    @Test
    public void testCanMakeDiscoverableAdmin() throws Exception {
        this.testAdminsHavePermissionsItem("canMakeDiscoverable");
    }

    @Test
    public void testCanMakeDiscoverableWriter() throws Exception {
        this.testWriteUsersHavePermissionsItem("canMakeDiscoverable", true);
    }

    @Test
    public void testCanDeleteAdmin() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String siteId = ContentServiceFactory.getInstance().getSiteService().findSite(this.context).getID().toString();
        String feature = "canDelete";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/sites/" + siteId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.context.turnOffAuthorisationSystem();
        EPerson communityAAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAAAdmin@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityAA).withAction(11).withUser(communityAAAdmin).build();
        this.context.restoreAuthSystemState();
        String communityAAAdminToken = this.getAuthToken(communityAAAdmin.getEmail(), this.password);
        this.getClient(communityAAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityB.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionY.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanDeleteAdminParent() throws Exception {
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canDelete";
        this.context.turnOffAuthorisationSystem();
        EPerson communityAAAdmin = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAAAdmin@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityA).withAction(4).withUser(communityAAAdmin).build();
        this.context.restoreAuthSystemState();
        String communityAAAdminToken = this.getAuthToken(communityAAAdmin.getEmail(), this.password);
        this.getClient(communityAAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.context.turnOffAuthorisationSystem();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityAA).withAction(4).withUser(this.collectionXAdmin).build();
        this.context.restoreAuthSystemState();
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.context.turnOffAuthorisationSystem();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).withUser(this.item1Admin).build();
        this.context.restoreAuthSystemState();
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanDeleteWriter() throws Exception {
        this.testWriteUsersHavePermissionsAllDso("canManagePolicies", false);
    }

    @Test
    public void testCanDeleteMinimalPermissions() throws Exception {
        String feature = "canDelete";
        this.context.turnOffAuthorisationSystem();
        EPerson communityADeleter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityADeleter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityA).withAction(2).withUser(communityADeleter).build();
        this.context.restoreAuthSystemState();
        String communityADeleterToken = this.getAuthToken(communityADeleter.getEmail(), this.password);
        this.getClient(communityADeleterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityADeleterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson communityARemover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityARemover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityA).withAction(4).withUser(communityARemover).build();
        this.context.restoreAuthSystemState();
        String communityARemoverToken = this.getAuthToken(communityARemover.getEmail(), this.password);
        this.getClient(communityARemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityARemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(communityARemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson communityAARemover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityAARemover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.communityAA).withAction(4).withUser(communityAARemover).build();
        this.context.restoreAuthSystemState();
        String communityAARemoverToken = this.getAuthToken(communityAARemover.getEmail(), this.password);
        this.getClient(communityAARemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(communityAARemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/communities/" + this.communityAA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAARemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson collectionXRemover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("communityXRemover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).withUser(collectionXRemover).build();
        this.context.restoreAuthSystemState();
        String collectionXRemoverToken = this.getAuthToken(collectionXRemover.getEmail(), this.password);
        this.getClient(collectionXRemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson item1Deleter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Deleter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(2).withUser(item1Deleter).build();
        this.context.restoreAuthSystemState();
        String item1DeleterToken = this.getAuthToken(item1Deleter.getEmail(), this.password);
        this.getClient(item1DeleterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson collectionXRemoverItem1Deleter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("collectionXDeleter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.collectionX).withAction(4).withUser(collectionXRemoverItem1Deleter).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(2).withUser(collectionXRemoverItem1Deleter).build();
        this.context.restoreAuthSystemState();
        String collectionXRemoverItem1DeleterToken = this.getAuthToken(collectionXRemoverItem1Deleter.getEmail(), this.password);
        this.getClient(collectionXRemoverItem1DeleterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXRemoverItem1DeleterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/collections/" + this.collectionX.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXRemoverItem1DeleterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson item1Remover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1Remover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(4).withUser(item1Remover).build();
        this.context.restoreAuthSystemState();
        String item1RemoverToken = this.getAuthToken(item1Remover.getEmail(), this.password);
        this.getClient(item1RemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).exists());
        this.getClient(item1RemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(item1RemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1Remover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1Remover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.bundle1).withAction(4).withUser(bundle1Remover).build();
        this.context.restoreAuthSystemState();
        String bundle1RemoverToken = this.getAuthToken(bundle1Remover.getEmail(), this.password);
        this.getClient(bundle1RemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1item1Remover = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1item1Remover@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.bundle1).withAction(4).withUser(bundle1item1Remover).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(4).withUser(bundle1item1Remover).build();
        this.context.restoreAuthSystemState();
        String bundle1item1RemoverToken = this.getAuthToken(bundle1item1Remover.getEmail(), this.password);
        this.getClient(bundle1item1RemoverToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bitstreams/" + this.bitstream1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canDelete')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanReorderBitstreamsAdmin() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canReorderBitstreams";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanReorderBitstreamsWriter() throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String feature = "canReorderBitstreams";
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canReorderBitstreams')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanCreateBitstreamAdmin() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String communityAAdminToken = this.getAuthToken(this.communityAAdmin.getEmail(), this.password);
        String collectionXAdminToken = this.getAuthToken(this.collectionXAdmin.getEmail(), this.password);
        String item1AdminToken = this.getAuthToken(this.item1Admin.getEmail(), this.password);
        String feature = "canCreateBitstream";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getClient(collectionXAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getClient(item1AdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
        this.getClient(communityAAdminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void testCanCreateBitstreamWriter() throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String feature = "canCreateBitstream";
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1Writer = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1Writer@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.bundle1).withAction(1).withUser(bundle1Writer).build();
        this.context.restoreAuthSystemState();
        String bundle1WriterToken = this.getAuthToken(bundle1Writer.getEmail(), this.password);
        this.getClient(bundle1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1Adder = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1Adder@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.bundle1).withAction(3).withUser(bundle1Adder).build();
        this.context.restoreAuthSystemState();
        String bundle1AdderToken = this.getAuthToken(bundle1Adder.getEmail(), this.password);
        this.getClient(bundle1AdderToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson bundle1WriterAdder = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("bundle1WriterAdder@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.bundle1).withAction(3).withUser(bundle1WriterAdder).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.bundle1).withAction(1).withUser(bundle1WriterAdder).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(3).withUser(bundle1WriterAdder).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(1).withUser(bundle1WriterAdder).build();
        this.context.restoreAuthSystemState();
        String bundle1WriterAdderToken = this.getAuthToken(bundle1WriterAdder.getEmail(), this.password);
        this.getClient(bundle1WriterAdderToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/bundles/" + this.bundle1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBitstream')]", (Object[])new Object[0]).exists());
    }

    @Test
    public void testCanCreateBundleAdmin() throws Exception {
        this.testAdminsHavePermissionsItem("canCreateBundle");
    }

    @Test
    public void testCanCreateBundleWriter() throws Exception {
        String communityAWriterToken = this.getAuthToken(this.communityAWriter.getEmail(), this.password);
        String collectionXWriterToken = this.getAuthToken(this.collectionXWriter.getEmail(), this.password);
        String item1WriterToken = this.getAuthToken(this.item1Writer.getEmail(), this.password);
        String feature = "canCreateBundle";
        this.getClient(communityAWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(collectionXWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).doesNotExist());
        this.getClient(item1WriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).doesNotExist());
        this.context.turnOffAuthorisationSystem();
        EPerson item1AdderWriter = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Jhon", "Brown").withEmail("item1AdderWriter@my.edu").withPassword(this.password).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(3).withUser(item1AdderWriter).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context).withDspaceObject((DSpaceObject)this.item1).withAction(1).withUser(item1AdderWriter).build();
        this.context.restoreAuthSystemState();
        String item1AdderWriterToken = this.getAuthToken(item1AdderWriter.getEmail(), this.password);
        this.getClient(item1AdderWriterToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/search/object?embed=feature&uri=http://localhost/api/core/items/" + this.item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[?(@._embedded.feature.id=='canCreateBundle')]", (Object[])new Object[0]).exists());
    }
}

