/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.GroupConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class ManageGroupFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private Utils utils;
    @Autowired
    private GroupConverter groupConverter;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    protected Community community1;
    protected Group community1AdminGroup;
    protected EPerson community1Admin;
    protected Collection collection1;
    protected Group collection1AdminGroup;
    protected EPerson collection1Admin;
    protected Group collection1SubmitterGroup;
    protected EPerson collection1Submitter;
    protected Community community2;
    protected Group community2AdminGroup;
    protected Collection collection2;
    protected Group collection2AdminGroup;
    protected Group collection2SubmitterGroup;
    protected Community community3;
    protected Collection collection3;
    protected Group anonymousGroup;
    protected Group administratorGroup;
    private AuthorizationFeature canManageGroupFeature;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.canManageGroupFeature = this.authorizationFeatureService.find("canManageGroup");
        this.context.turnOffAuthorisationSystem();
        this.community1Admin = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("community1admin@email.com").withPassword(this.password).withNameInMetadata("Admin", "Community 1").build();
        this.community1 = CommunityBuilder.createCommunity((Context)this.context).withName("Community 1").withAdminGroup(new EPerson[]{this.community1Admin}).build();
        this.community1AdminGroup = this.community1.getAdministrators();
        this.collection1Admin = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("collection1admin@email.com").withPassword(this.password).withNameInMetadata("Admin", "Collection 1").build();
        this.collection1Submitter = EPersonBuilder.createEPerson((Context)this.context).withCanLogin(true).withEmail("collection1submitter@email.com").withPassword(this.password).withNameInMetadata("Submitter", "Collection 1").build();
        this.collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.community1).withName("Collection 1").withAdminGroup(new EPerson[]{this.collection1Admin}).withSubmitterGroup(new EPerson[]{this.collection1Submitter}).build();
        this.collection1AdminGroup = this.collection1.getAdministrators();
        this.collection1SubmitterGroup = this.collection1.getSubmitters();
        this.community2 = CommunityBuilder.createCommunity((Context)this.context).withName("Community 2").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.community2AdminGroup = this.community2.getAdministrators();
        this.collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.community2).withName("Collection 2").withAdminGroup(new EPerson[]{this.eperson}).withSubmitterGroup(new EPerson[]{this.eperson}).build();
        this.collection2AdminGroup = this.collection2.getAdministrators();
        this.collection2SubmitterGroup = this.collection2.getSubmitters();
        this.community3 = CommunityBuilder.createCommunity((Context)this.context).withName("Community 3").build();
        this.collection3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.community3).withName("Collection 3").build();
        this.anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        this.administratorGroup = this.groupService.findByName(this.context, "Administrator");
        this.context.restoreAuthSystemState();
    }

    protected GroupRest getGroupRest(Group group) throws Exception {
        return this.groupConverter.convert((Group)this.context.reloadEntity((ReloadableEntity)group), Projection.DEFAULT);
    }

    protected Authorization getCanManageGroupAuthorization(EPerson user, GroupRest groupRest) {
        return new Authorization(user, this.canManageGroupFeature, (BaseObjectRest)groupRest);
    }

    protected String getGroupLink(GroupRest groupRest) {
        return this.utils.linkToSingleResource((RestAddressableModel)groupRest, "self").getHref();
    }

    protected void canManageGroup(EPerson user, Group group) throws Exception {
        String token = this.getAuthToken(user.getEmail(), this.password);
        GroupRest groupRest = this.getGroupRest(group);
        Authorization authorization = this.getCanManageGroupAuthorization(user, groupRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.getGroupLink(groupRest)}).param("feature", new String[]{"canManageGroup"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{AuthorizationMatcher.matchAuthorization(authorization)})));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/{epersonUuid}_canManageGroup_eperson.group_{groupUuid}", (Object[])new Object[]{user.getID(), group.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", AuthorizationMatcher.matchAuthorization(authorization)));
    }

    protected void canNotManageGroup(EPerson user, Group group) throws Exception {
        String token = this.getAuthToken(user.getEmail(), this.password);
        GroupRest groupRest = this.getGroupRest(group);
        Authorization authorization = this.getCanManageGroupAuthorization(user, groupRest);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{this.getGroupLink(groupRest)}).param("feature", new String[]{"canManageGroup"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Object[])new Object[0]).doesNotExist());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/{epersonUuid}_canManageGroup_eperson.group_{groupUuid}", (Object[])new Object[]{user.getID(), group.getID()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void siteAdminCanManageCommunity1AdminGroup() throws Exception {
        this.canManageGroup(this.admin, this.community1AdminGroup);
    }

    @Test
    public void siteAdminCanManageCollection1AdminGroup() throws Exception {
        this.canManageGroup(this.admin, this.collection1AdminGroup);
    }

    @Test
    public void siteAdminCanManageCollection1SubmitterGroup() throws Exception {
        this.canManageGroup(this.admin, this.collection1SubmitterGroup);
    }

    @Test
    public void siteAdminCanManageCollection2AdminGroup() throws Exception {
        this.canManageGroup(this.admin, this.collection2AdminGroup);
    }

    @Test
    public void siteAdminCanManageCollection2SubmitterGroup() throws Exception {
        this.canManageGroup(this.admin, this.collection2SubmitterGroup);
    }

    @Test
    public void siteAdminCanManageAnonymousGroup() throws Exception {
        this.canManageGroup(this.admin, this.anonymousGroup);
    }

    @Test
    public void siteAdminCanManageAdministratorGroup() throws Exception {
        this.canManageGroup(this.admin, this.administratorGroup);
    }

    @Test
    public void community1AdminCanManageCommunity1AdminGroup() throws Exception {
        this.canManageGroup(this.community1Admin, this.community1AdminGroup);
    }

    @Test
    public void community1AdminCanManageCollection1AdminGroup() throws Exception {
        this.canManageGroup(this.community1Admin, this.collection1AdminGroup);
    }

    @Test
    public void community1AdminCanManageCollection1SubmitterGroup() throws Exception {
        this.canManageGroup(this.community1Admin, this.collection1SubmitterGroup);
    }

    @Test
    public void community1AdminCanNotManageCollection2AdminGroup() throws Exception {
        this.canNotManageGroup(this.community1Admin, this.collection2AdminGroup);
    }

    @Test
    public void community1AdminCanNotManageCollection2SubmitterGroup() throws Exception {
        this.canNotManageGroup(this.community1Admin, this.collection2SubmitterGroup);
    }

    @Test
    public void community1AdminCanNotManageAnonymousGroup() throws Exception {
        this.canNotManageGroup(this.community1Admin, this.anonymousGroup);
    }

    @Test
    public void community1AdminCanNotManageAdministratorGroup() throws Exception {
        this.canNotManageGroup(this.community1Admin, this.administratorGroup);
    }

    @Test
    public void collection1AdminCanNotManageCommunity1AdminGroup() throws Exception {
        this.canNotManageGroup(this.collection1Admin, this.community1AdminGroup);
    }

    @Test
    public void collection1AdminCanManageCollection1AdminGroup() throws Exception {
        this.canManageGroup(this.collection1Admin, this.collection1AdminGroup);
    }

    @Test
    public void collection1AdminCanManageCollection1SubmitterGroup() throws Exception {
        this.canManageGroup(this.collection1Admin, this.collection1SubmitterGroup);
    }

    @Test
    public void collection1AdminCanNotManageCollection2AdminGroup() throws Exception {
        this.canNotManageGroup(this.collection1Admin, this.collection2AdminGroup);
    }

    @Test
    public void collection1AdminCanNotManageCollection2SubmitterGroup() throws Exception {
        this.canNotManageGroup(this.collection1Admin, this.collection2SubmitterGroup);
    }

    @Test
    public void collection1AdminCanNotManageAnonymousGroup() throws Exception {
        this.canNotManageGroup(this.collection1Admin, this.anonymousGroup);
    }

    @Test
    public void collection1AdminCanNotManageAdministratorGroup() throws Exception {
        this.canNotManageGroup(this.collection1Admin, this.administratorGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageCommunity1AdminGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.community1AdminGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageCollection1AdminGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.collection1AdminGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageCollection1SubmitterGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.collection1SubmitterGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageCollection2AdminGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.collection2AdminGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageCollection2SubmitterGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.collection2SubmitterGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageAnonymousGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.anonymousGroup);
    }

    @Test
    public void collection1SubmitterCanNotManageAdministratorGroup() throws Exception {
        this.canNotManageGroup(this.collection1Submitter, this.administratorGroup);
    }
}

