/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RequestCopyFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    ResourcePolicyService resourcePolicyService;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private BitstreamConverter bitstreamConverter;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private Utils utils;
    private AuthorizationFeature requestCopyFeature;
    private Collection collectionA;
    private Item itemA;
    private Bitstream bitstreamA;
    private Bitstream bitstreamB;
    private Item itemInWorkSpace;
    private Bitstream bitstreamFromWorkSpaceItem;
    private Bitstream bitstreamFromCollection;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("request.item.type", (Object)"all");
        this.context.turnOffAuthorisationSystem();
        this.requestCopyFeature = this.authorizationFeatureService.find("canRequestACopy");
        String bitstreamContent = "Dummy content";
        Community communityA = CommunityBuilder.createCommunity((Context)this.context).build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)communityA).withLogo("Blub").build();
        this.bitstreamFromCollection = this.collectionA.getLogo();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).build();
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstreamA = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemA, (InputStream)is).withName("Bitstream").withDescription("Description").withMimeType("text/plain").build();
            this.bitstreamB = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.itemA, (InputStream)is).withName("Bitstream2").withDescription("Description2").withMimeType("text/plain").build();
            WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collectionA).withFulltext("Test", "source", is).build();
            this.itemInWorkSpace = workspaceItem.getItem();
            this.bitstreamFromWorkSpaceItem = (Bitstream)((Bundle)this.itemInWorkSpace.getBundles("ORIGINAL").get(0)).getBitstreams().get(0);
        }
        this.resourcePolicyService.removePolicies(this.context, (DSpaceObject)this.bitstreamB, 0);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void requestCopyOnCollectionAAsAdmin() throws Exception {
        CollectionRest collectionRest = this.collectionConverter.convert(this.collectionA, Projection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnItemAAsAdmin() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnItemInWorkSpaceAsAdmin() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemInWorkSpace, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamAAsAdmin() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamBAsAdmin() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamFromWorkSpaceItemAsAdmin() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamFromWorkSpaceItem, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamFromCollectionAsAdmin() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamFromCollection, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnCollectionAAsAnonymous() throws Exception {
        CollectionRest collectionRest = this.collectionConverter.convert(this.collectionA, Projection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnItemAAsAnonymous() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(null, this.requestCopyFeature, (BaseObjectRest)itemRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void requestCopyOnItemInWorkSpaceAsAnonymous() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemInWorkSpace, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamAAsAnonymous() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamBAsAnonymous() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(null, this.requestCopyFeature, (BaseObjectRest)bitstreamRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void requestCopyOnBitstreamFromWorkSpaceItemAsAnonymous() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamFromWorkSpaceItem, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamFromCollectionAsAnonymous() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamFromCollection, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnCollectionAAsEperson() throws Exception {
        CollectionRest collectionRest = this.collectionConverter.convert(this.collectionA, Projection.DEFAULT);
        String collectionUri = this.utils.linkToSingleResource((RestAddressableModel)collectionRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{collectionUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnItemAAsEperson() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemA, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(this.eperson, this.requestCopyFeature, (BaseObjectRest)itemRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void requestCopyOnItemInWorkSpaceAsEperson() throws Exception {
        ItemRest itemRest = this.itemConverter.convert(this.itemInWorkSpace, Projection.DEFAULT);
        String itemUri = this.utils.linkToSingleResource((RestAddressableModel)itemRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{itemUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamAAsEperson() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamBAsEperson() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(this.eperson, this.requestCopyFeature, (BaseObjectRest)bitstreamRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    @Test
    public void requestCopyOnBitstreamFromWorkSpaceItemAsEperson() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamFromWorkSpaceItem, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestCopyOnBitstreamFromCollectionAsEperson() throws Exception {
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamFromCollection, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    public void requestACopyItemTypeLoggedAsAnonymous() throws Exception {
        this.configurationService.setProperty("request.item.type", (Object)"logged");
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void requestACopyItemTypeLoggedAsEperson() throws Exception {
        this.configurationService.setProperty("request.item.type", (Object)"logged");
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        Authorization authorizationFeature = new Authorization(this.eperson, this.requestCopyFeature, (BaseObjectRest)bitstreamRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authorizationFeature)))));
    }

    public void requestACopyItemTypeEmptyAsAnonymous() throws Exception {
        this.configurationService.setProperty("request.item.type", (Object)"");
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    public void requestACopyItemTypeEmptyAsEperson() throws Exception {
        this.configurationService.setProperty("request.item.type", (Object)"");
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    public void requestACopyItemTypeBogusValueAsAnonymous() throws Exception {
        this.configurationService.setProperty("request.item.type", (Object)"invalid value");
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    public void requestACopyItemTypeBogusValueAsEperson() throws Exception {
        this.configurationService.setProperty("request.item.type", (Object)"invalid value");
        BitstreamRest bitstreamRest = this.bitstreamConverter.convert(this.bitstreamB, Projection.DEFAULT);
        String bitstreamUri = this.utils.linkToSingleResource((RestAddressableModel)bitstreamRest, "self").getHref();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{bitstreamUri}).param("feature", new String[]{this.requestCopyFeature.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }
}

