/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.health;

import com.maxmind.geoip2.DatabaseReader;
import java.util.Map;
import org.dspace.app.rest.configuration.ActuatorConfiguration;
import org.dspace.app.rest.health.GeoIpHealthIndicator;
import org.dspace.statistics.GeoIpService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@RunWith(value=MockitoJUnitRunner.class)
public class GeoIpHealthIndicatorTest {
    @Mock
    private GeoIpService geoIpService;
    @InjectMocks
    private GeoIpHealthIndicator geoIpHealthIndicator;
    @Mock
    private DatabaseReader databaseReader;

    @Test
    public void testWithGeoIpConfiguredCorrectly() {
        Mockito.when((Object)this.geoIpService.getDatabaseReader()).thenReturn((Object)this.databaseReader);
        Health health = this.geoIpHealthIndicator.health();
        MatcherAssert.assertThat((Object)health.getStatus(), (Matcher)Matchers.is((Object)Status.UP));
        MatcherAssert.assertThat((Object)health.getDetails(), (Matcher)Matchers.anEmptyMap());
    }

    @Test
    public void testWithGeoIpWrongConfiguration() {
        Mockito.when((Object)this.geoIpService.getDatabaseReader()).thenThrow(new Throwable[]{new IllegalStateException("Missing db file")});
        Health health = this.geoIpHealthIndicator.health();
        MatcherAssert.assertThat((Object)health.getStatus(), (Matcher)Matchers.is((Object)ActuatorConfiguration.UP_WITH_ISSUES_STATUS));
        MatcherAssert.assertThat((Object)health.getDetails(), (Matcher)Matchers.is(Map.of("reason", "Missing db file")));
    }

    @Test
    public void testWithUnexpectedError() {
        Mockito.when((Object)this.geoIpService.getDatabaseReader()).thenThrow(new Throwable[]{new RuntimeException("Generic error")});
        Health health = this.geoIpHealthIndicator.health();
        MatcherAssert.assertThat((Object)health.getStatus(), (Matcher)Matchers.is((Object)Status.DOWN));
    }
}

