/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.controller;

import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.SimpleMapConverter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class LinksetRestControllerIT
extends AbstractControllerIntegrationTest {
    private static final String doiPattern = "https://doi.org/{0}";
    private static final String orcidPattern = "http://orcid.org/{0}";
    private static final String doi = "10.1007/978-3-642-35233-1_18";
    private static final String PERSON_ENTITY_TYPE = "Person";
    private Collection collection;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private MetadataAuthorityService metadataAuthorityService;
    @Autowired
    private ChoiceAuthorityService choiceAuthorityService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private SimpleMapConverter mapConverterDSpaceToSchemaOrgUri;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection").withEntityType("Publication").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findAllItemsLinksets() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/signposting", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneItemJsonLinksets() throws Exception {
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        String mimeType = "application/vnd.datacite.datacite+xml";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].cite-as[0].href", (Matcher)Matchers.hasToString((String)(url + "/handle/" + item.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].type", (Matcher)Matchers.hasToString((String)mimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].describes[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].describes[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].anchor", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{"application/linkset+json;charset=UTF-8"}));
    }

    @Test
    public void findOneItemJsonLinksetsWithType() throws Exception {
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        String mimeType = "application/vnd.datacite.datacite+xml";
        String articleUri = this.mapConverterDSpaceToSchemaOrgUri.getValue("Article");
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).withType("Article").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].cite-as[0].href", (Matcher)Matchers.hasToString((String)(url + "/handle/" + item.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].type", (Matcher)Matchers.hasToString((String)mimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].type", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].type[0].href", (Matcher)Matchers.hasToString((String)"https://schema.org/AboutPage"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].type[1].href", (Matcher)Matchers.hasToString((String)articleUri))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].describes[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].describes[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].anchor", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{"application/linkset+json;charset=UTF-8"}));
    }

    @Test
    public void findOneItemJsonLinksetsWithLicence() throws Exception {
        String licenceUrl = "https://exmple.com/licence";
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata(MetadataSchemaEnum.DC.getName(), "rights", "uri", licenceUrl).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset", (Matcher)Matchers.hasSize((int)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].type[0].href", (Matcher)Matchers.hasToString((String)"https://schema.org/AboutPage"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].license[0].href", (Matcher)Matchers.hasToString((String)licenceUrl))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].describes[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].describes[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].anchor", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{"application/linkset+json;charset=UTF-8"}));
    }

    @Test
    public void findOneItemJsonLinksetsWithBitstreams() throws Exception {
        String bitstream1Content = "ThisIsSomeDummyText";
        String bitstream1MimeType = "text/plain";
        String bitstream2Content = "ThisIsSomeAlternativeDummyText";
        String bitstream2MimeType = "application/pdf";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstream1Content, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream 1").withDescription("description").withMimeType(bitstream1MimeType).build();
        }
        Bitstream bitstream2 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstream2Content, (String)"UTF-8");){
            bitstream2 = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream 2").withDescription("description").withMimeType(bitstream2MimeType).build();
        }
        this.context.restoreAuthSystemState();
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        String mimeType = "application/vnd.datacite.datacite+xml";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset", (Matcher)Matchers.hasSize((int)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].cite-as[0].href", (Matcher)Matchers.hasToString((String)(url + "/handle/" + item.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].type", (Matcher)Matchers.hasToString((String)mimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item[0].href", (Matcher)Matchers.hasToString((String)(url + "/bitstreams/" + bitstream1.getID() + "/download")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item[0].type", (Matcher)Matchers.hasToString((String)bitstream1MimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item[1].href", (Matcher)Matchers.hasToString((String)(url + "/bitstreams/" + bitstream2.getID() + "/download")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item[1].type", (Matcher)Matchers.hasToString((String)bitstream2MimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].anchor", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].collection[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].collection[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].anchor", (Matcher)Matchers.hasToString((String)(url + "/bitstreams/" + bitstream1.getID() + "/download")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].collection[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].collection[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].anchor", (Matcher)Matchers.hasToString((String)(url + "/bitstreams/" + bitstream2.getID() + "/download")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[3].describes[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[3].describes[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[3].anchor", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{"application/linkset+json;charset=UTF-8"}));
    }

    @Test
    public void findOneItemJsonLinksetsWithBitstreamsFromDifferentBundles() throws Exception {
        Bitstream bitstream;
        String bitstream1Content = "ThisIsSomeDummyText";
        String bitstream1MimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstream1Content, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is, (String)"ORIGINAL").withName("Bitstream 1").withDescription("description").withMimeType(bitstream1MimeType).build();
        }
        is = IOUtils.toInputStream((String)"test", (String)"UTF-8");
        try {
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is, (String)"TEXT").withName("Bitstream 2").withDescription("description").withMimeType("application/pdf").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = IOUtils.toInputStream((String)"test", (String)"UTF-8");
        try {
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is, (String)"THUMBNAIL").withName("Bitstream 3").withDescription("description").withMimeType("application/pdf").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        is = IOUtils.toInputStream((String)"test", (String)"UTF-8");
        try {
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is, (String)"LICENSE").withName("Bitstream 4").withDescription("description").withMimeType("application/pdf").build();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        this.context.restoreAuthSystemState();
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        String mimeType = "application/vnd.datacite.datacite+xml";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].cite-as[0].href", (Matcher)Matchers.hasToString((String)(url + "/handle/" + item.getHandle())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].describedby[0].type", (Matcher)Matchers.hasToString((String)mimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item", (Matcher)Matchers.hasSize((int)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item[0].href", (Matcher)Matchers.hasToString((String)(url + "/bitstreams/" + bitstream1.getID() + "/download")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].item[0].type", (Matcher)Matchers.hasToString((String)bitstream1MimeType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].anchor", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[0].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].collection[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].collection[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[0].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[0].type", (Matcher)Matchers.hasToString((String)"application/linkset"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[1].href", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].linkset[1].type", (Matcher)Matchers.hasToString((String)"application/linkset+json"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[1].anchor", (Matcher)Matchers.hasToString((String)(url + "/bitstreams/" + bitstream1.getID() + "/download")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].describes[0].href", (Matcher)Matchers.hasToString((String)(url + "/entities/publication/" + item.getID())))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].describes[0].type", (Matcher)Matchers.hasToString((String)"text/html"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.linkset[2].anchor", (Matcher)Matchers.hasToString((String)(url + "/" + signpostingUrl + "/describedby/" + item.getID())))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{"application/linkset+json;charset=UTF-8"}));
    }

    @Test
    public void findOneItemThatIsInWorkspaceJsonLinksets() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collection).withTitle("Workspace Item").build();
        this.itemService.addMetadata(this.context, (DSpaceObject)workspaceItem.getItem(), "dc", "identifier", "doi", "*", doi);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + workspaceItem.getItem().getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneWithdrawnItemJsonLinksets() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).withdrawn().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneEmbargoItemJsonLinksets() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).withIssueDate("2017-11-18").withEmbargoPeriod("2 week").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneRestrictedItemJsonLinksets() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).withReaderGroup(internalGroup).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneUnDiscoverableItemJsonLinksets() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneBitstreamJsonLinksets() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + bitstream.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneCollectionJsonLinksets() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + this.collection.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneCommunityJsonLinksets() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + this.parentCommunity.getID() + "/json"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneItemLsetLinksets() throws Exception {
        String bitstream1Content = "ThisIsSomeDummyText";
        String bitstream1MimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").build();
        Bitstream bitstream1 = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstream1Content, (String)"UTF-8");){
            bitstream1 = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream 1").withDescription("description").withMimeType(bitstream1MimeType).build();
        }
        this.context.restoreAuthSystemState();
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        String mimeType = "application/vnd.datacite.datacite+xml";
        String siteAsRelation = "<" + url + "/handle/" + item.getHandle() + "> ; rel=\"cite-as\" ; anchor=\"" + url + "/entities/publication/" + item.getID() + "\" ,";
        String itemRelation = "<" + url + "/bitstreams/" + bitstream1.getID() + "/download> ; rel=\"item\" ; type=\"text/plain\" ; anchor=\"" + url + "/entities/publication/" + item.getID() + "\" ,";
        String typeRelation = "<https://schema.org/AboutPage> ; rel=\"type\" ; anchor=\"" + url + "/entities/publication/" + item.getID() + "\" ,";
        String linksetRelation = "<" + url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "> ; rel=\"linkset\" ; type=\"application/linkset\" ; anchor=\"" + url + "/entities/publication/" + item.getID() + "\" ,";
        String jsonLinksetRelation = "<" + url + "/" + signpostingUrl + "/linksets/" + item.getID().toString() + "/json> ; rel=\"linkset\" ; type=\"application/linkset+json\" ; anchor=\"" + url + "/entities/publication/" + item.getID() + "\" ,";
        String describedByRelation = "<" + url + "/" + signpostingUrl + "/describedby/" + item.getID() + "> ; rel=\"describedby\" ; type=\"" + mimeType + "\" ; anchor=\"" + url + "/entities/publication/" + item.getID() + "\" ,";
        String bitstreamCollectionLink = "<" + url + "/entities/publication/" + item.getID() + "> ; rel=\"collection\" ; type=\"text/html\" ; anchor=\"" + url + "/bitstreams/" + bitstream1.getID() + "/download\"";
        String bitstreamLinksetLink = "<" + url + "/" + signpostingUrl + "/linksets/" + item.getID() + "> ; rel=\"linkset\" ; type=\"application/linkset\" ; anchor=\"" + url + "/bitstreams/" + bitstream1.getID() + "/download\"";
        String bitstreamLinksetJsonLink = "<" + url + "/" + signpostingUrl + "/linksets/" + item.getID() + "/json> ; rel=\"linkset\" ; type=\"application/linkset+json\" ; anchor=\"" + url + "/bitstreams/" + bitstream1.getID() + "/download\"";
        String describesMetadataLink = "<" + url + "/entities/publication/" + item.getID() + "> ; rel=\"describes\" ; type=\"text/html\" ; anchor=\"" + url + "/" + signpostingUrl + "/describedby/" + item.getID() + "\"";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)siteAsRelation))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)itemRelation))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)typeRelation))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)linksetRelation))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)jsonLinksetRelation))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)describedByRelation))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)bitstreamCollectionLink))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)bitstreamLinksetLink))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)bitstreamLinksetJsonLink))).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)describesMetadataLink))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{"application/linkset;charset=UTF-8"}));
    }

    @Test
    public void findOneUnDiscoverableItemLsetLinksets() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/linksets/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findTypedLinkForItemWithAuthor() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        String orcidValue = "orcidValue";
        this.context.turnOffAuthorisationSystem();
        Collection personCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType(PERSON_ENTITY_TYPE).build();
        Item author = ItemBuilder.createItem((Context)this.context, (Collection)personCollection).withPersonIdentifierLastName("familyName").withPersonIdentifierFirstName("firstName").withMetadata(MetadataSchemaEnum.PERSON.getName(), "identifier", "orcid", orcidValue).build();
        Item publication = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).withAuthor("John", author.getID().toString(), 600).build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)publication, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).build();
        }
        EntityType publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Publication").build();
        EntityType authorEntityType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)PERSON_ENTITY_TYPE).build();
        RelationshipType isAuthorOfPublicationRelationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)publicationEntityType, (EntityType)authorEntityType, (String)"isAuthorOfPublication", (String)"isPublicationOfAuthor", null, null, null, null).build();
        isAuthorOfPublicationRelationshipType.setTilted(RelationshipType.Tilted.LEFT);
        isAuthorOfPublicationRelationshipType = this.relationshipTypeService.create(this.context, isAuthorOfPublicationRelationshipType);
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)publication, (Item)author, (RelationshipType)isAuthorOfPublicationRelationshipType).build();
        this.context.restoreAuthSystemState();
        String url = this.configurationService.getProperty("dspace.ui.url");
        String signpostingUrl = this.configurationService.getProperty("signposting.path");
        String mimeType = "application/vnd.datacite.datacite+xml";
        String dcIdentifierUriMetadataValue = this.itemService.getMetadataFirstValue((DSpaceObject)publication, "dc", "identifier", "uri", "*");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + publication.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)7))).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + MessageFormat.format(orcidPattern, orcidValue) + "' && @.rel == 'author')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + url + "/" + signpostingUrl + "/describedby/" + publication.getID() + "' && @.rel == 'describedby' && @.type == '" + mimeType + "')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + dcIdentifierUriMetadataValue + "' && @.rel == 'cite-as')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + url + "/bitstreams/" + bitstream.getID() + "/download' && @.rel == 'item' && @.type == 'text/plain')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.href == 'https://schema.org/AboutPage' && @.rel == 'type')]", (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + url + "/" + signpostingUrl + "/linksets/" + publication.getID().toString() + "' && @.rel == 'linkset' && @.type == 'application/linkset')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + url + "/" + signpostingUrl + "/linksets/" + publication.getID().toString() + "/json' && @.rel == 'linkset' && @.type == 'application/linkset+json')]"), (Object[])new Object[0]).exists());
    }

    @Test
    public void findTypedLinkForBitstream() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).build();
        }
        this.context.restoreAuthSystemState();
        String uiUrl = this.configurationService.getProperty("dspace.ui.url");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)3))).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + uiUrl + "/entities/publication/" + item.getID() + "' && @.rel == 'collection' && @.type == 'text/html')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + uiUrl + "/signposting/linksets/" + item.getID() + "' && @.rel == 'linkset' && @.type == 'application/linkset')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + uiUrl + "/signposting/linksets/" + item.getID() + "/json' && @.rel == 'linkset' && @.type == 'application/linkset+json')]"), (Object[])new Object[0]).exists());
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void findTypedLinkForBitstreamWithType() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).build();
        }
        this.bitstreamService.addMetadata(this.context, (DSpaceObject)bitstream, "dc", "type", null, "*", "Article");
        this.context.restoreAuthSystemState();
        String uiUrl = this.configurationService.getProperty("dspace.ui.url");
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.hasSize((int)4))).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + uiUrl + "/entities/publication/" + item.getID() + "' && @.rel == 'collection' && @.type == 'text/html')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + uiUrl + "/signposting/linksets/" + item.getID() + "' && @.rel == 'linkset' && @.type == 'application/linkset')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)("$[?(@.href == '" + uiUrl + "/signposting/linksets/" + item.getID() + "/json' && @.rel == 'linkset' && @.type == 'application/linkset+json')]"), (Object[])new Object[0]).exists()).andExpect(MockMvcResultMatchers.jsonPath((String)"$[?(@.href == 'https://schema.org/ScholarlyArticle' && @.rel == 'type')]", (Object[])new Object[0]).exists());
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void findTypedLinkForRestrictedBitstream() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).withReaderGroup(internalGroup).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void findTypedLinkForBitstreamUnderEmbargo() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Item Test").withIssueDate("2017-10-17").withMetadata("dc", "identifier", "doi", doi).build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).withEmbargoPeriod("6 months").build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void findTypedLinkForBitstreamOfWorkspaceItem() throws Exception {
        String bitstreamContent = "ThisIsSomeDummyText";
        String bitstreamMimeType = "text/plain";
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collection).withTitle("Workspace Item").build();
        Item item = workspaceItem.getItem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "identifier", "doi", "*", doi);
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)workspaceItem.getItem(), (InputStream)is).withName("Bitstream").withDescription("description").withMimeType(bitstreamMimeType).build();
        }
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + bitstream.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void findTypedLinkForUnDiscoverableItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/links/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        this.metadataAuthorityService.clearCache();
        this.choiceAuthorityService.clearCache();
    }

    @Test
    public void getDescribedBy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currentDateInFormat = dateFormat.format(new Date());
        String title = "Item Test";
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle(title).withMetadata("dc", "identifier", "doi", doi).build();
        String responseMimeType = "application/vnd.datacite.datacite+xml";
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/describedby/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(Matchers.containsString((String)title))).andExpect(MockMvcResultMatchers.header().stringValues("Content-Type", new String[]{responseMimeType + ";charset=UTF-8"}));
    }

    @Test
    public void getDescribedByItemThatIsInWorkspace() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collection).withTitle("Workspace Item").build();
        this.itemService.addMetadata(this.context, (DSpaceObject)workspaceItem.getItem(), "dc", "identifier", "doi", "*", doi);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/describedby/" + workspaceItem.getItem().getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getDescribedByWithdrawnItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).withdrawn().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/describedby/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getDescribedByEmbargoItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).withIssueDate("2017-11-18").withEmbargoPeriod("2 week").build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/describedby/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getDescribedByRestrictedItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group internalGroup = GroupBuilder.createGroup((Context)this.context).withName("Internal Group").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).withReaderGroup(internalGroup).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/describedby/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getDescribedByUnDiscoverableItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Withdrawn Item").withMetadata("dc", "identifier", "doi", doi).makeUnDiscoverable().build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/signposting/describedby/" + item.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }
}

