/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.InvalidSearchRequestException;
import org.dspace.app.rest.parameter.SearchFilter;
import org.dspace.app.rest.utils.RestDiscoverQueryBuilder;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.discovery.configuration.HierarchicalSidebarFacetConfiguration;
import org.dspace.discovery.utils.DiscoverQueryBuilder;
import org.dspace.discovery.utils.parameter.QueryBuilderSearchFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@RunWith(value=MockitoJUnitRunner.class)
public class RestDiscoverQueryBuilderTest {
    @InjectMocks
    private RestDiscoverQueryBuilder restQueryBuilder;
    @Mock
    private DiscoverQueryBuilder discoverQueryBuilder;
    @Mock
    private Context context;
    @Mock
    private IndexableObject scope;
    private DiscoveryConfiguration discoveryConfiguration;
    private String query;
    private SearchFilter searchFilter;
    private QueryBuilderSearchFilter tranformedFilter;
    private PageRequest page;

    @Before
    public void setUp() throws Exception {
        this.discoveryConfiguration = new DiscoveryConfiguration();
        this.discoveryConfiguration.setDefaultFilterQueries(Arrays.asList("archived:true"));
        DiscoveryHitHighlightingConfiguration discoveryHitHighlightingConfiguration = new DiscoveryHitHighlightingConfiguration();
        LinkedList<DiscoveryHitHighlightFieldConfiguration> discoveryHitHighlightFieldConfigurations = new LinkedList<DiscoveryHitHighlightFieldConfiguration>();
        DiscoveryHitHighlightFieldConfiguration discoveryHitHighlightFieldConfiguration = new DiscoveryHitHighlightFieldConfiguration();
        discoveryHitHighlightFieldConfiguration.setField("dc.title");
        DiscoveryHitHighlightFieldConfiguration discoveryHitHighlightFieldConfiguration1 = new DiscoveryHitHighlightFieldConfiguration();
        discoveryHitHighlightFieldConfiguration1.setField("fulltext");
        discoveryHitHighlightFieldConfigurations.add(discoveryHitHighlightFieldConfiguration1);
        discoveryHitHighlightFieldConfigurations.add(discoveryHitHighlightFieldConfiguration);
        discoveryHitHighlightingConfiguration.setMetadataFields(discoveryHitHighlightFieldConfigurations);
        this.discoveryConfiguration.setHitHighlightingConfiguration(discoveryHitHighlightingConfiguration);
        DiscoverySortFieldConfiguration defaultSort = new DiscoverySortFieldConfiguration();
        defaultSort.setMetadataField("dc.date.accessioned");
        defaultSort.setType("date");
        defaultSort.setDefaultSortOrder(DiscoverySortFieldConfiguration.SORT_ORDER.desc);
        ArrayList<DiscoverySortFieldConfiguration> listSortField = new ArrayList<DiscoverySortFieldConfiguration>();
        listSortField.add(defaultSort);
        DiscoverySortConfiguration sortConfiguration = new DiscoverySortConfiguration();
        DiscoverySortFieldConfiguration titleSort = new DiscoverySortFieldConfiguration();
        titleSort.setMetadataField("dc.title");
        titleSort.setDefaultSortOrder(DiscoverySortFieldConfiguration.SORT_ORDER.asc);
        listSortField.add(titleSort);
        sortConfiguration.setSortFields(listSortField);
        sortConfiguration.setDefaultSortField(defaultSort);
        this.discoveryConfiguration.setSearchSortConfiguration(sortConfiguration);
        DiscoverySearchFilterFacet subjectFacet = new DiscoverySearchFilterFacet();
        subjectFacet.setIndexFieldName("subject");
        subjectFacet.setFacetLimit(5);
        DiscoverySearchFilterFacet dateFacet = new DiscoverySearchFilterFacet();
        dateFacet.setIndexFieldName("dateIssued");
        dateFacet.setType("date");
        dateFacet.setFacetLimit(6);
        HierarchicalSidebarFacetConfiguration hierarchyFacet = new HierarchicalSidebarFacetConfiguration();
        hierarchyFacet.setIndexFieldName("hierarchy");
        hierarchyFacet.setType("hierarchical");
        hierarchyFacet.setFacetLimit(7);
        hierarchyFacet.setSortOrderSidebar(DiscoveryConfigurationParameters.SORT.VALUE);
        this.discoveryConfiguration.setSidebarFacets(Arrays.asList(subjectFacet, dateFacet, hierarchyFacet));
        this.discoveryConfiguration.setSearchFilters(Arrays.asList(subjectFacet, dateFacet, hierarchyFacet));
        this.query = "my test case";
        this.searchFilter = new SearchFilter("subject", "equals", "Java");
        this.tranformedFilter = new QueryBuilderSearchFilter("subject", "equals", "Java");
        this.page = PageRequest.of((int)1, (int)10, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"dc.title"});
    }

    @Test
    public void testBuildQuery() throws Exception {
        this.restQueryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "item", (Pageable)this.page);
        ((DiscoverQueryBuilder)Mockito.verify((Object)this.discoverQueryBuilder, (VerificationMode)Mockito.times((int)1))).buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.tranformedFilter), Collections.singletonList("item"), Integer.valueOf(this.page.getPageSize()), Long.valueOf(this.page.getOffset()), "dc.title", "ASC");
    }

    @Test
    public void testBuildQueryDefaults() throws Exception {
        this.restQueryBuilder.buildQuery(this.context, null, this.discoveryConfiguration, null, null, Collections.emptyList(), null);
        ((DiscoverQueryBuilder)Mockito.verify((Object)this.discoverQueryBuilder, (VerificationMode)Mockito.times((int)1))).buildQuery(this.context, null, this.discoveryConfiguration, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null);
    }

    @Test
    public void testSortByScore() throws Exception {
        this.page = PageRequest.of((int)2, (int)10, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"SCORE"});
        this.restQueryBuilder.buildQuery(this.context, null, this.discoveryConfiguration, null, null, Collections.emptyList(), (Pageable)this.page);
        ((DiscoverQueryBuilder)Mockito.verify((Object)this.discoverQueryBuilder, (VerificationMode)Mockito.times((int)1))).buildQuery(this.context, null, this.discoveryConfiguration, null, Collections.emptyList(), Collections.emptyList(), Integer.valueOf(this.page.getPageSize()), Long.valueOf(this.page.getOffset()), "SCORE", "ASC");
    }

    @Test
    public void testSortByDefaultSortField() throws Exception {
        this.page = PageRequest.of((int)2, (int)10);
        this.restQueryBuilder.buildQuery(this.context, null, this.discoveryConfiguration, null, null, Collections.emptyList(), (Pageable)this.page);
        ((DiscoverQueryBuilder)Mockito.verify((Object)this.discoverQueryBuilder, (VerificationMode)Mockito.times((int)1))).buildQuery(this.context, null, this.discoveryConfiguration, null, Collections.emptyList(), Collections.emptyList(), Integer.valueOf(this.page.getPageSize()), Long.valueOf(this.page.getOffset()), null, null);
    }

    @Test(expected=DSpaceBadRequestException.class)
    public void testCatchIllegalArgumentException() throws Exception {
        Mockito.when((Object)this.discoverQueryBuilder.buildQuery((Context)ArgumentMatchers.any(), (IndexableObject)ArgumentMatchers.any(), (DiscoveryConfiguration)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenThrow(IllegalArgumentException.class);
        this.restQueryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "TEST", (Pageable)this.page);
    }

    @Test(expected=InvalidSearchRequestException.class)
    public void testCatchSearchServiceException() throws Exception {
        Mockito.when((Object)this.discoverQueryBuilder.buildQuery((Context)ArgumentMatchers.any(), (IndexableObject)ArgumentMatchers.any(), (DiscoveryConfiguration)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (Integer)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenThrow(SearchServiceException.class);
        this.restQueryBuilder.buildQuery(this.context, this.scope, this.discoveryConfiguration, this.query, Arrays.asList(this.searchFilter), "ITEM", (Pageable)this.page);
    }

    @Test
    public void testBuildFacetQuery() throws Exception {
        this.restQueryBuilder.buildFacetQuery(this.context, this.scope, this.discoveryConfiguration, "prefix", this.query, Collections.singletonList(this.searchFilter), "item", (Pageable)this.page, "subject");
        ((DiscoverQueryBuilder)Mockito.verify((Object)this.discoverQueryBuilder, (VerificationMode)Mockito.times((int)1))).buildFacetQuery(this.context, this.scope, this.discoveryConfiguration, "prefix", this.query, Collections.singletonList(this.tranformedFilter), Collections.singletonList("item"), Integer.valueOf(this.page.getPageSize()), Long.valueOf(this.page.getOffset()), "subject");
    }
}

