/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dspace.app.matcher.GoogleAnalyticsEventMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.GoogleAsyncEventListener;
import org.dspace.google.client.GoogleAnalyticsClient;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class GoogleAsyncEventListenerIT
extends AbstractControllerIntegrationTest {
    private static final String ANALYTICS_KEY = "G-123456";
    @Autowired
    private GoogleAsyncEventListener googleAsyncEventListener;
    @Autowired
    private ConfigurationService configurationService;
    private Bitstream bitstream;
    private Item item;
    private List<GoogleAnalyticsClient> originalGoogleAnalyticsClients;
    private GoogleAnalyticsClient firstGaClientMock = (GoogleAnalyticsClient)Mockito.mock(GoogleAnalyticsClient.class);
    private GoogleAnalyticsClient secondGaClientMock = (GoogleAnalyticsClient)Mockito.mock(GoogleAnalyticsClient.class);

    @Before
    public void setup() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Test community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Test collection").build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Test item").build();
        this.bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)this.item, (InputStream)IOUtils.toInputStream((String)"Test bitstream", (Charset)Charset.defaultCharset())).withName("bitstream.txt").build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("google.analytics.key", (Object)ANALYTICS_KEY);
        this.originalGoogleAnalyticsClients = this.googleAsyncEventListener.getGoogleAnalyticsClients();
        this.googleAsyncEventListener.setGoogleAnalyticsClients(List.of(this.firstGaClientMock, this.secondGaClientMock));
        Mockito.when((Object)this.firstGaClientMock.isAnalyticsKeySupported(ANALYTICS_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.secondGaClientMock.isAnalyticsKeySupported(ANALYTICS_KEY)).thenReturn((Object)true);
    }

    @After
    public void cleanup() {
        this.googleAsyncEventListener.setGoogleAnalyticsClients(this.originalGoogleAnalyticsClients);
    }

    @Test
    public void testOnBitstreamContentDownload() throws Exception {
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        String bitstreamUrl = "/api/core/bitstreams/" + this.bitstream.getID() + "/content";
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadBitstreamContent("Chrome", "ABCDEFG", "REF-1");
        this.downloadBitstreamContent("Chrome", "987654", "REF-2");
        List<GoogleAnalyticsEvent> storedEvents = this.getStoredEventsAsList();
        MatcherAssert.assertThat(storedEvents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{GoogleAnalyticsEventMatcher.event("123456", "127.0.0.1", "Postman", "REF", bitstreamUrl, "Test item"), GoogleAnalyticsEventMatcher.event("ABCDEFG", "127.0.0.1", "Chrome", "REF-1", bitstreamUrl, "Test item"), GoogleAnalyticsEventMatcher.event("987654", "127.0.0.1", "Chrome", "REF-2", bitstreamUrl, "Test item")}));
        this.googleAsyncEventListener.sendCollectedEvents();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).sendEvents(ANALYTICS_KEY, storedEvents);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadWithoutConfiguredAnalyticsKey() throws Exception {
        this.configurationService.setProperty("google.analytics.key", null);
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadBitstreamContent("Chrome", "ABCDEFG", "REF-1");
        this.downloadBitstreamContent("Chrome", "987654", "REF-2");
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        this.googleAsyncEventListener.sendCollectedEvents();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadWithNotSupportedAnalyticsKey() throws Exception {
        Mockito.when((Object)this.firstGaClientMock.isAnalyticsKeySupported(ANALYTICS_KEY)).thenReturn((Object)false);
        Mockito.when((Object)this.secondGaClientMock.isAnalyticsKeySupported(ANALYTICS_KEY)).thenReturn((Object)false);
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadBitstreamContent("Chrome", "ABCDEFG", "REF-1");
        this.downloadBitstreamContent("Chrome", "987654", "REF-2");
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.hasSize((int)3));
        IllegalStateException illegalStateException = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.googleAsyncEventListener.sendCollectedEvents());
        MatcherAssert.assertThat((Object)illegalStateException.getMessage(), (Matcher)Matchers.is((Object)"No Google Analytics Client supports key G-123456"));
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadWithMoreThanOneSupportedClient() throws Exception {
        Mockito.when((Object)this.firstGaClientMock.isAnalyticsKeySupported(ANALYTICS_KEY)).thenReturn((Object)true);
        Mockito.when((Object)this.secondGaClientMock.isAnalyticsKeySupported(ANALYTICS_KEY)).thenReturn((Object)true);
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadBitstreamContent("Chrome", "ABCDEFG", "REF-1");
        this.downloadBitstreamContent("Chrome", "987654", "REF-2");
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.hasSize((int)3));
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.googleAsyncEventListener.sendCollectedEvents());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"More than one Google Analytics Client supports key G-123456"));
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadWithTooManyEvents() throws Exception {
        int eventCount = 26;
        for (int i = 0; i < eventCount; ++i) {
            this.downloadBitstreamContent("Postman", "123456", "REF");
        }
        List<GoogleAnalyticsEvent> storedEvents = this.getStoredEventsAsList();
        MatcherAssert.assertThat(storedEvents, (Matcher)Matchers.hasSize((int)eventCount));
        this.googleAsyncEventListener.sendCollectedEvents();
        List<GoogleAnalyticsEvent> firstEventsChunk = storedEvents.subList(0, 20);
        List<GoogleAnalyticsEvent> secondEventsChunk = storedEvents.subList(20, eventCount);
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.is(secondEventsChunk));
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).sendEvents(ANALYTICS_KEY, firstEventsChunk);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
        this.googleAsyncEventListener.sendCollectedEvents();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock, (VerificationMode)Mockito.times((int)2))).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock, (VerificationMode)Mockito.times((int)2))).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).sendEvents(ANALYTICS_KEY, secondEventsChunk);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadDefaultBundleConfig() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle licenseBundle = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("LICENSE").build();
        Bitstream license = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)licenseBundle, (InputStream)IOUtils.toInputStream((String)"License", (Charset)Charset.defaultCharset())).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        String bitstreamUrl = "/api/core/bitstreams/" + this.bitstream.getID() + "/content";
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadContent("Chrome", "ABCDEFG", "REF-1", license);
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.hasSize((int)1));
        List<GoogleAnalyticsEvent> storedEvents = this.getStoredEventsAsList();
        MatcherAssert.assertThat(storedEvents, (Matcher)Matchers.contains((Matcher)GoogleAnalyticsEventMatcher.event("123456", "127.0.0.1", "Postman", "REF", bitstreamUrl, "Test item")));
        this.googleAsyncEventListener.sendCollectedEvents();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).sendEvents(ANALYTICS_KEY, storedEvents);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadMultipleBundleConfig() throws Exception {
        this.configurationService.setProperty("google-analytics.bundles", List.of("ORIGINAL", "CONTENT"));
        this.context.turnOffAuthorisationSystem();
        Bundle contentBundle = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("CONTENT").build();
        Bitstream content = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)contentBundle, (InputStream)IOUtils.toInputStream((String)"Test Content", (Charset)Charset.defaultCharset())).build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("THUMBNAIL").build();
        Bitstream thumbnail = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)IOUtils.toInputStream((String)"Thumbnail", (Charset)Charset.defaultCharset())).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        String bitstreamUrl = "/api/core/bitstreams/" + this.bitstream.getID() + "/content";
        String contentUrl = "/api/core/bitstreams/" + content.getID() + "/content";
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadContent("Chrome", "ABCDEFG", "REF-1", content);
        this.downloadContent("Chrome", "987654", "REF-2", thumbnail);
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.hasSize((int)2));
        List<GoogleAnalyticsEvent> storedEvents = this.getStoredEventsAsList();
        MatcherAssert.assertThat(storedEvents, (Matcher)Matchers.contains((Matcher[])new Matcher[]{GoogleAnalyticsEventMatcher.event("123456", "127.0.0.1", "Postman", "REF", bitstreamUrl, "Test item"), GoogleAnalyticsEventMatcher.event("ABCDEFG", "127.0.0.1", "Chrome", "REF-1", contentUrl, "Test item")}));
        this.googleAsyncEventListener.sendCollectedEvents();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.firstGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).isAnalyticsKeySupported(ANALYTICS_KEY);
        ((GoogleAnalyticsClient)Mockito.verify((Object)this.secondGaClientMock)).sendEvents(ANALYTICS_KEY, storedEvents);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.firstGaClientMock, this.secondGaClientMock});
    }

    @Test
    public void testOnBitstreamContentDownloadNoneBundleConfig() throws Exception {
        this.configurationService.setProperty("google-analytics.bundles", (Object)"none");
        this.context.turnOffAuthorisationSystem();
        Bundle contentBundle = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("CONTENT").build();
        Bitstream content = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)contentBundle, (InputStream)IOUtils.toInputStream((String)"Test Content", (Charset)Charset.defaultCharset())).build();
        Bundle thumbnailBundle = BundleBuilder.createBundle((Context)this.context, (Item)this.item).withName("THUMBNAIL").build();
        Bitstream thumbnail = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)thumbnailBundle, (InputStream)IOUtils.toInputStream((String)"Thumbnail", (Charset)Charset.defaultCharset())).build();
        this.context.restoreAuthSystemState();
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
        this.downloadBitstreamContent("Postman", "123456", "REF");
        this.downloadContent("Chrome", "ABCDEFG", "REF-1", content);
        this.downloadContent("Chrome", "987654", "REF-2", thumbnail);
        MatcherAssert.assertThat(this.getStoredEventsAsList(), (Matcher)Matchers.empty());
    }

    private List<GoogleAnalyticsEvent> getStoredEventsAsList() {
        ArrayList<GoogleAnalyticsEvent> events = new ArrayList<GoogleAnalyticsEvent>();
        this.googleAsyncEventListener.getEventsBuffer().iterator().forEachRemaining(obj -> events.add((GoogleAnalyticsEvent)obj));
        return events;
    }

    private void downloadContent(String userAgent, String correlationId, String referrer, Bitstream bit) throws Exception {
        this.getClient(this.getAuthToken(this.admin.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/bitstreams/" + bit.getID() + "/content"), (Object[])new Object[0]).header("USER-AGENT", new Object[]{userAgent}).header("X-CORRELATION-ID", new Object[]{correlationId}).header("X-REFERRER", new Object[]{referrer})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void downloadBitstreamContent(String userAgent, String correlationId, String referrer) throws Exception {
        this.downloadContent(userAgent, correlationId, referrer, this.bitstream);
    }
}

