/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.io.Serializable;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.model.SubmissionVisibilityRest;
import org.dspace.app.rest.model.VisibilityEnum;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.springframework.stereotype.Component;

@Component
public class SubmissionSectionConverter
implements DSpaceConverter<SubmissionStepConfig, SubmissionSectionRest> {
    private static final Logger log = LogManager.getLogger(SubmissionSectionConverter.class);
    private SubmissionConfigService submissionConfigService;

    public SubmissionSectionRest convert(SubmissionStepConfig step, Projection projection) {
        SubmissionSectionRest sp = new SubmissionSectionRest();
        sp.setProjection(projection);
        sp.setMandatory(step.isMandatory());
        sp.setHeader(step.getHeading());
        sp.setSectionType(step.getType());
        sp.setId((Serializable)((Object)step.getId()));
        sp.setVisibility(new SubmissionVisibilityRest(VisibilityEnum.fromString((String)step.getVisibility()), VisibilityEnum.fromString((String)step.getVisibilityOutside())));
        return sp;
    }

    public SubmissionStepConfig toModel(SubmissionSectionRest obj) {
        SubmissionStepConfig step;
        try {
            step = this.getSubmissionConfigService().getStepConfig((String)((Object)obj.getId()));
        }
        catch (IllegalStateException | SQLException | SubmissionConfigReaderException e) {
            throw new RuntimeException(e);
        }
        return step;
    }

    public Class<SubmissionStepConfig> getModelClass() {
        return SubmissionStepConfig.class;
    }

    public SubmissionConfigService getSubmissionConfigService() throws SubmissionConfigReaderException, SQLException, IllegalStateException {
        if (this.submissionConfigService == null) {
            this.submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
        }
        return this.submissionConfigService;
    }
}

