/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.exception;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.InvalidCsrfTokenException;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;

@Component
public class DSpaceAccessDeniedHandler
implements AccessDeniedHandler {
    @Lazy
    @Autowired
    private CsrfTokenRepository csrfTokenRepository;
    @Autowired
    @Qualifier(value="handlerExceptionResolver")
    private HandlerExceptionResolver handlerExceptionResolver;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException ex) throws IOException, ServletException {
        if (response.isCommitted()) {
            return;
        }
        if (ex instanceof InvalidCsrfTokenException) {
            this.csrfTokenRepository.saveToken(null, request, response);
            CsrfToken newToken = this.csrfTokenRepository.generateToken(request);
            this.csrfTokenRepository.saveToken(newToken, request, response);
        }
        this.handlerExceptionResolver.resolveException(request, response, null, (Exception)((Object)ex));
    }
}

