/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.exception.LinkNotFoundException;
import org.dspace.app.rest.model.VocabularyEntryDetailsRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.utils.AuthorityUtils;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.vocabularyEntryDetail.children")
public class VocabularyEntryDetailsChildrenLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ChoiceAuthorityService choiceAuthorityService;
    @Autowired
    private AuthorityUtils authorityUtils;

    @PreAuthorize(value="permitAll()")
    public Page<VocabularyEntryDetailsRest> getChildren(@Nullable HttpServletRequest request, String name, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        String[] parts = StringUtils.split((String)name, (String)":", (int)2);
        if (parts.length != 2) {
            return null;
        }
        String vocabularyName = parts[0];
        String id = parts[1];
        Pageable pageable = this.utils.getPageable(optionalPageable);
        ArrayList<VocabularyEntryDetailsRest> results = new ArrayList<VocabularyEntryDetailsRest>();
        ChoiceAuthority authority = this.choiceAuthorityService.getChoiceAuthorityByAuthorityName(vocabularyName);
        if (StringUtils.isNotBlank((CharSequence)id) && authority.isHierarchical()) {
            Choices choices = this.choiceAuthorityService.getChoicesByParent(vocabularyName, id, (int)pageable.getOffset(), pageable.getPageSize(), context.getCurrentLocale().toString());
            for (Choice value : choices.values) {
                results.add(this.authorityUtils.convertEntryDetails(value, vocabularyName, authority.isHierarchical(), this.utils.obtainProjection()));
            }
            PageImpl resources = new PageImpl(results, pageable, (long)choices.total);
            return resources;
        }
        throw new LinkNotFoundException("submission", "vocabularyEntryDetail", name);
    }
}

