/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.resourcePolicy.ResourcePolicyUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyPolicyTypeAddOperation<R>
extends PatchOperation<R> {
    @Autowired
    ResourcePolicyUtils resourcePolicyUtils;

    public R perform(Context context, R resource, Operation operation) {
        this.checkOperationValue(operation.getValue());
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.checkResourcePolicyForNonExistingPolicyTypeValue(resourcePolicy);
            this.add(resourcePolicy, operation);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void add(ResourcePolicy resourcePolicy, Operation operation) {
        String policyType = (String)operation.getValue();
        resourcePolicy.setRpType(policyType);
    }

    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof ResourcePolicy && operation.getOp().trim().equalsIgnoreCase("add") && operation.getPath().trim().equalsIgnoreCase("/policyType");
    }

    void checkResourcePolicyForNonExistingPolicyTypeValue(ResourcePolicy resource) {
        if (resource.getRpType() != null) {
            throw new DSpaceBadRequestException("Attempting to add a value to an already existing path.");
        }
    }
}

