/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class OrcidHistorySendToOrcidRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    @Autowired
    private RequestService requestService;
    @Autowired
    private OrcidQueueService orcidQueueService;
    @Autowired
    private ItemService itemService;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        DSpaceRestPermission restPermission = DSpaceRestPermission.convert((Object)permission);
        if (!DSpaceRestPermission.ADD.equals((Object)restPermission)) {
            return false;
        }
        if (!targetType.equals("ORCID_HISTORY")) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((HttpServletRequest)request.getHttpServletRequest());
        EPerson currentUser = context.getCurrentUser();
        String url = targetId.toString();
        Pattern pattern = Pattern.compile("\\[.*\\/api\\/eperson\\/orcidqueues\\/(.*)\\]");
        Matcher matcher = pattern.matcher(url);
        matcher.find();
        String id = matcher.group(1);
        int queueId = Integer.parseInt(id);
        OrcidQueue orcidQueue = null;
        try {
            orcidQueue = this.orcidQueueService.find(context, queueId);
            if (currentUser == null) {
                return false;
            }
            if (orcidQueue == null) {
                return true;
            }
            if (this.hasAccess(context, currentUser, orcidQueue)) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return false;
    }

    private boolean hasAccess(Context context, EPerson currentUser, OrcidQueue orcidQueue) {
        List value;
        return orcidQueue != null && ((MetadataValue)(value = this.itemService.getMetadata((DSpaceObject)orcidQueue.getProfileItem(), "dspace", "object", "owner", null)).get(0)).getAuthority().equals(currentUser.getID().toString());
    }
}

