/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class PoolTaskRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LoggerFactory.getLogger(PoolTaskRestPermissionEvaluatorPlugin.class);
    @Autowired
    private RequestService requestService;
    @Autowired
    private PoolTaskService poolTaskService;
    @Autowired
    private EPersonService ePersonService;

    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission permission) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)"pooltask", (CharSequence)targetType)) {
            return false;
        }
        Request request = this.requestService.getCurrentRequest();
        Context context = ContextUtil.obtainContext((HttpServletRequest)request.getHttpServletRequest());
        EPerson ePerson = null;
        try {
            ePerson = this.ePersonService.findByEmail(context, (String)authentication.getPrincipal());
            if (ePerson == null) {
                return false;
            }
            int dsoId = Integer.parseInt(targetId.toString());
            PoolTask poolTask = (PoolTask)this.poolTaskService.find(context, dsoId);
            if (poolTask == null) {
                return true;
            }
            XmlWorkflowItem workflowItem = poolTask.getWorkflowItem();
            PoolTask poolTask2 = this.poolTaskService.findByWorkflowIdAndEPerson(context, workflowItem, ePerson);
            if (poolTask2 != null && poolTask2.getID().equals(poolTask.getID())) {
                return true;
            }
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }
}

