/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.item;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.item.ItemSignpostingProcessor;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.util.FrontendUrlService;

public class ItemIdentifierProcessor
extends ItemSignpostingProcessor {
    private final ItemService itemService;

    public ItemIdentifierProcessor(FrontendUrlService frontendUrlService, ItemService itemService) {
        super(frontendUrlService);
        this.itemService = itemService;
        this.setRelation(LinksetRelationType.CITE_AS);
    }

    public void addLinkSetNodes(Context context, HttpServletRequest request, Item item, List<LinksetNode> linksetNodes) {
        String identifier = this.itemService.getMetadataFirstValue((DSpaceObject)item, new MetadataFieldName(this.getMetadataField()), "*");
        if (Objects.nonNull(identifier)) {
            if (StringUtils.isNotBlank((CharSequence)this.getPattern())) {
                identifier = MessageFormat.format(this.getPattern(), item);
            }
            linksetNodes.add(new LinksetNode(identifier, this.getRelation(), this.buildAnchor(context, item)));
        }
    }
}

