/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.submit.factory.impl.ReplacePatchOperation;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.submit.model.AccessConditionConfiguration;
import org.dspace.submit.model.AccessConditionConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessConditionDiscoverableReplacePatchOperation
extends ReplacePatchOperation<String> {
    @Autowired
    private AccessConditionConfigurationService accessConditionConfigurationService;

    void replace(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String string, Object value) throws Exception {
        String stepId = (String)currentRequest.getAttribute("accessConditionSectionId");
        AccessConditionConfiguration configuration = this.accessConditionConfigurationService.getAccessConfigurationById(stepId);
        if (Objects.isNull(configuration) || !configuration.getCanChangeDiscoverable().booleanValue()) {
            throw new UnprocessableEntityException("The current access configurations does not allow the user to specify the visibility of the item");
        }
        Boolean discoverable = value instanceof String ? BooleanUtils.toBooleanObject((String)((String)value)) : (Boolean)value;
        if (Objects.isNull(discoverable)) {
            throw new UnprocessableEntityException("Value is not a valid boolean expression permitted value: true|false");
        }
        Item item = source.getItem();
        if (discoverable.booleanValue() == item.isDiscoverable()) {
            return;
        }
        item.setDiscoverable(discoverable.booleanValue());
    }

    protected Class<String[]> getArrayClassForEvaluation() {
        return String[].class;
    }

    protected Class<String> getClassForEvaluation() {
        return String.class;
    }
}

