/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="loginOnBehalfOf", description="It can be used by administrators to login on behalf of a different user")
public class LoginOnBehalfOfFeature
implements AuthorizationFeature {
    public static final String NAME = "loginOnBehalfOf";
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private EPersonService ePersonService;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (!StringUtils.equals((CharSequence)object.getType(), (CharSequence)"site") && !StringUtils.equals((CharSequence)object.getType(), (CharSequence)"eperson")) {
            return false;
        }
        if (!this.authorizeService.isAdmin(context)) {
            return false;
        }
        if (!this.configurationService.getBooleanProperty("webui.user.assumelogin")) {
            return false;
        }
        if (StringUtils.equals((CharSequence)object.getType(), (CharSequence)"eperson")) {
            EPersonRest ePersonRest = (EPersonRest)object;
            EPerson currentUser = context.getCurrentUser();
            if (StringUtils.equalsIgnoreCase((CharSequence)currentUser.getEmail(), (CharSequence)ePersonRest.getEmail())) {
                return false;
            }
            EPerson ePerson = this.ePersonService.findByEmail(context, ePersonRest.getEmail());
            if (this.authorizeService.isAdmin(context, ePerson)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site", "eperson.eperson"};
    }
}

