/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import org.atteo.evo.inflector.English;
import org.dspace.app.rest.RestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.SubmissionSectionRest;
import org.dspace.app.rest.model.hateoas.SubmissionSectionResource;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class SubmissionSectionHalLinkFactory
extends HalLinkFactory<SubmissionSectionResource, RestResourceController> {
    @Override
    protected void addLinks(SubmissionSectionResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        SubmissionSectionRest sd = (SubmissionSectionRest)halResource.getContent();
        if ("submission-form".equals(sd.getSectionType())) {
            this.buildLink(list, sd, "config", "submissionform");
        }
        if ("upload".equals(sd.getSectionType())) {
            this.buildLink(list, sd, "config", "submissionupload");
        }
        if ("accessCondition".equals(sd.getSectionType())) {
            this.buildLink(list, sd, "config", "submissionaccessoption");
        }
    }

    private void buildLink(LinkedList<Link> list, SubmissionSectionRest sd, String category, String name) {
        UriComponentsBuilder uriComponentsBuilder = WebMvcLinkBuilder.linkTo((Object)((RestResourceController)this.getMethodOn(category, name)).findRel(null, null, category, English.plural((String)name), (String)sd.getId(), "", null, null)).toUriComponentsBuilder();
        String uribuilder = uriComponentsBuilder.build().toString();
        list.add(this.buildLink("config", uribuilder.substring(0, uribuilder.lastIndexOf("/"))));
    }

    @Override
    protected Class<RestResourceController> getControllerClass() {
        return RestResourceController.class;
    }

    @Override
    protected Class<SubmissionSectionResource> getResourceClass() {
        return SubmissionSectionResource.class;
    }
}

