/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.BundleRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.service.BundleService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bundle.primaryBitstream")
public class BundlePrimaryBitstreamLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    BundleService bundleService;

    @PreAuthorize(value="hasPermission(#bundleId, 'BUNDLE', 'READ')")
    public BitstreamRest getPrimaryBitstream(@Nullable HttpServletRequest request, UUID bundleId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Bundle bundle = (Bundle)this.bundleService.find(context, bundleId);
            if (bundle == null) {
                throw new ResourceNotFoundException("No such bundle: " + bundleId);
            }
            if (bundle.getPrimaryBitstream() == null) {
                return null;
            }
            return (BitstreamRest)this.converter.toRest(bundle.getPrimaryBitstream(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @PreAuthorize(value="hasPermission(#bundleId, 'BUNDLE', 'WRITE')")
    public BundleRest createPrimaryBitstream(Context context, UUID bundleId, Bitstream bitstream, Projection projection) {
        try {
            Bundle bundle = this.setPrimaryBitstream(context, bundleId, bitstream, true);
            return (BundleRest)this.converter.toRest((Bundle)context.reloadEntity((ReloadableEntity)bundle), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @PreAuthorize(value="hasPermission(#bundleId, 'BUNDLE', 'WRITE')")
    public BundleRest updatePrimaryBitstream(Context context, UUID bundleId, Bitstream bitstream, Projection projection) {
        try {
            Bundle bundle = this.setPrimaryBitstream(context, bundleId, bitstream, false);
            return (BundleRest)this.converter.toRest((Bundle)context.reloadEntity((ReloadableEntity)bundle), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @PreAuthorize(value="hasPermission(#bundleId, 'BUNDLE', 'WRITE')")
    public void deletePrimaryBitstream(Context context, UUID bundleId) {
        try {
            Bundle bundle = this.setPrimaryBitstream(context, bundleId, null, false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Bundle setPrimaryBitstream(Context context, UUID bundleId, Bitstream bitstream, boolean shouldBeSet) throws SQLException {
        Bundle bundle = (Bundle)this.bundleService.find(context, bundleId);
        if (bundle == null) {
            throw new ResourceNotFoundException("No such bundle: " + bundleId);
        }
        if (!shouldBeSet && bundle.getPrimaryBitstream() == null) {
            throw new DSpaceBadRequestException("Bundle '" + bundle.getName() + "' does not have a primary bitstream.");
        }
        if (shouldBeSet && bundle.getPrimaryBitstream() != null) {
            throw new DSpaceBadRequestException("Bundle '" + bundle.getName() + "' already has a primary bitstream.");
        }
        if (bitstream != null && !bundle.getBitstreams().contains(bitstream)) {
            throw new UnprocessableEntityException("Bundle '" + bundle.getName() + "' does not contain bitstream with id: " + bitstream.getID());
        }
        bundle.setPrimaryBitstreamID(bitstream);
        context.commit();
        return bundle;
    }
}

