/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.signposting.processor.bitstream;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.rest.signposting.model.LinksetNode;
import org.dspace.app.rest.signposting.model.LinksetRelationType;
import org.dspace.app.rest.signposting.processor.bitstream.BitstreamSignpostingProcessor;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.util.FrontendUrlService;

public class BitstreamLinksetProcessor
extends BitstreamSignpostingProcessor {
    private static final Logger log = Logger.getLogger(BitstreamLinksetProcessor.class);
    private final BitstreamService bitstreamService;
    private final ConfigurationService configurationService;

    public BitstreamLinksetProcessor(FrontendUrlService frontendUrlService, BitstreamService bitstreamService, ConfigurationService configurationService) {
        super(frontendUrlService);
        this.bitstreamService = bitstreamService;
        this.configurationService = configurationService;
        this.setRelation(LinksetRelationType.LINKSET);
    }

    @Override
    public void addLinkSetNodes(Context context, HttpServletRequest request, Bitstream bitstream, List<LinksetNode> linksetNodes) {
        try {
            Item item = (Item)this.bitstreamService.getParentObject(context, (DSpaceObject)bitstream);
            if (item != null) {
                String signpostingPath = this.configurationService.getProperty("signposting.path");
                String baseUrl = this.configurationService.getProperty("dspace.ui.url");
                String linksetUrl = String.format("%s/%s/linksets/%s", baseUrl, signpostingPath, item.getID());
                String linksetJsonUrl = linksetUrl + "/json";
                List<LinksetNode> links = List.of(new LinksetNode(linksetUrl, this.getRelation(), "application/linkset", this.buildAnchor(bitstream)), new LinksetNode(linksetJsonUrl, this.getRelation(), "application/linkset+json", this.buildAnchor(bitstream)));
                linksetNodes.addAll(links);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

