/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.AccessConditionDTO;
import org.dspace.app.rest.submit.factory.impl.RemovePatchOperation;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessConditionRemovePatchOperation
extends RemovePatchOperation<AccessConditionDTO> {
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ResourcePolicyService resourcePolicyService;

    @Override
    void remove(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws Exception {
        String[] absolutePath = this.getAbsolutePath(path).split("/");
        Item item = source.getItem();
        if (absolutePath.length == 1) {
            this.authorizeService.removePoliciesActionFilter(context, (DSpaceObject)item, 0);
        } else if (absolutePath.length == 2) {
            Integer idxToDelete = null;
            try {
                idxToDelete = Integer.parseInt(absolutePath[1]);
            }
            catch (NumberFormatException e) {
                throw new UnprocessableEntityException("The provided index format is not correct! Must be a number!");
            }
            List policies = this.resourcePolicyService.find(context, (DSpaceObject)item, ResourcePolicy.TYPE_CUSTOM);
            if (idxToDelete < 0 || idxToDelete >= policies.size()) {
                throw new UnprocessableEntityException("The provided index:" + idxToDelete + " is not supported, currently the are " + policies.size() + " access conditions");
            }
            ResourcePolicy resourcePolicyToDelete = (ResourcePolicy)policies.get(idxToDelete);
            item.getResourcePolicies().remove(resourcePolicyToDelete);
            context.commit();
            this.resourcePolicyService.delete(context, resourcePolicyToDelete);
        } else {
            throw new UnprocessableEntityException("The patch operation for path:" + path + " is not supported!");
        }
    }

    @Override
    protected Class<AccessConditionDTO[]> getArrayClassForEvaluation() {
        return AccessConditionDTO[].class;
    }

    @Override
    protected Class<AccessConditionDTO> getClassForEvaluation() {
        return AccessConditionDTO.class;
    }
}

