/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.submit.factory.impl.ReplacePatchOperation;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectionReplacePatchOperation
extends ReplacePatchOperation<String> {
    @Autowired
    CollectionService collectionService;
    @Autowired
    ItemService itemService;
    @Autowired
    WorkspaceItemService workspaceItemService;

    @Override
    void replace(Context context, HttpServletRequest currentRequest, InProgressSubmission source, String path, Object value) throws SQLException, DCInputsReaderException {
        if (!(source instanceof WorkspaceItem)) {
            throw new IllegalArgumentException("the replace operation is only supported on workspaceitem");
        }
        WorkspaceItem wsi = (WorkspaceItem)source;
        String uuid = (String)value;
        Collection fromCollection = source.getCollection();
        Collection toCollection = (Collection)this.collectionService.find(context, UUIDUtils.fromString((String)uuid));
        this.workspaceItemService.move(context, (InProgressSubmission)wsi, fromCollection, toCollection);
    }

    @Override
    protected Class<String[]> getArrayClassForEvaluation() {
        return String[].class;
    }

    @Override
    protected Class<String> getClassForEvaluation() {
        return String.class;
    }
}

