/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkaccesscontrol;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dspace.app.matcher.ResourcePolicyMatcher;
import org.dspace.app.rest.converter.DSpaceRunnableParameterConverter;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ProcessBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class BulkAccessControlScriptIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private DSpaceRunnableParameterConverter dSpaceRunnableParameterConverter;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ProcessService processService;
    private static final String SCRIPTS_ENDPOINT = "/api/system/scripts";
    private static final String CURATE_SCRIPT_ENDPOINT = "/api/system/scripts/bulk-access-control/processes";

    @After
    public void destroy() throws Exception {
        List processes = this.processService.findAll(this.context);
        for (Process process : processes) {
            ProcessBuilder.deleteProcess((Integer)process.getID());
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkAccessScriptWithAdminUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity).withName("collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").withSubject("ExtraEntry").build();
        String json = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.json", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-u", item.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-f", "test.json"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkAccessScriptWithAdminUserOfTargetCommunityTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        String json = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.json", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-u", this.parentCommunity.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-f", "test.json"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            String token = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkAccessScriptWithAdminUserOfTargetCollectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity).withName("collection").withAdminGroup(new EPerson[]{this.eperson}).build();
        String json = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.json", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-u", collection.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-f", "test.json"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            String token = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkAccessScriptWithAdminUserOfTargetItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity).withName("collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item").withSubject("ExtraEntry").withAdminUser(this.eperson).build();
        String json = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.json", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-u", item.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-f", "test.json"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            String token = this.getAuthToken(this.eperson.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkAccessScriptWithMultipleTargetUuidsWithAdminUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunity = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity).withName("collection").build();
        Item itemOne = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item one").build();
        Item itemTwo = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item two").build();
        Item itemThree = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("Public item three").build();
        String json = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.json", "text/plain", (InputStream)inputStream);
        AtomicReference idRef = new AtomicReference();
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-u", itemOne.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-u", itemTwo.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-u", itemThree.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-f", "test.json"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        try {
            String token = this.getAuthToken(this.admin.getEmail(), this.password);
            this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isAccepted()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.processId", (Predicate[])new Predicate[0])));
            itemOne = (Item)this.context.reloadEntity((ReloadableEntity)itemOne);
            itemTwo = (Item)this.context.reloadEntity((ReloadableEntity)itemTwo);
            itemThree = (Item)this.context.reloadEntity((ReloadableEntity)itemThree);
            Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
            MatcherAssert.assertThat((Object)itemOne.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)itemTwo.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)itemThree.getResourcePolicies(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)itemOne.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches((int)0, (Group)anonymousGroup, (String)"openaccess", (String)ResourcePolicy.TYPE_CUSTOM)));
            MatcherAssert.assertThat((Object)itemTwo.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches((int)0, (Group)anonymousGroup, (String)"openaccess", (String)ResourcePolicy.TYPE_CUSTOM)));
            MatcherAssert.assertThat((Object)itemThree.getResourcePolicies(), (Matcher)Matchers.hasItem((Matcher)ResourcePolicyMatcher.matches((int)0, (Group)anonymousGroup, (String)"openaccess", (String)ResourcePolicy.TYPE_CUSTOM)));
        }
        finally {
            ProcessBuilder.deleteProcess((Integer)((Integer)idRef.get()));
        }
    }

    @Test
    public void bulkAccessScriptWithoutTargetUUIDParameterTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").withAdminGroup(new EPerson[]{this.eperson}).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).param("properties", new String[]{new ObjectMapper().writeValueAsString(List.of())})).andExpect(MockMvcResultMatchers.status().isInternalServerError()).andExpect(result -> Assert.assertTrue((boolean)result.getResolvedException().getMessage().contains("At least one target uuid must be provided")));
    }

    @Test
    public void bulkAccessScriptWithNormalUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        String json = "{ \"item\": {\n      \"mode\": \"replace\",\n      \"accessConditions\": [\n          {\n            \"name\": \"openaccess\"\n          }\n      ]\n   }}\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        MockMultipartFile bitstreamFile = new MockMultipartFile("file", "test.json", "text/plain", (InputStream)inputStream);
        LinkedList<DSpaceCommandLineParameter> parameters = new LinkedList<DSpaceCommandLineParameter>();
        parameters.add(new DSpaceCommandLineParameter("-u", this.parentCommunity.getID().toString()));
        parameters.add(new DSpaceCommandLineParameter("-f", "test.json"));
        List list = parameters.stream().map(dSpaceCommandLineParameter -> this.dSpaceRunnableParameterConverter.convert(dSpaceCommandLineParameter, Projection.DEFAULT)).collect(Collectors.toList());
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)CURATE_SCRIPT_ENDPOINT, (Object[])new Object[0]).file(bitstreamFile).param("properties", new String[]{new ObjectMapper().writeValueAsString(list)})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }
}

