/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.CommunityConverter;
import org.dspace.app.rest.converter.EPersonConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.converter.SiteConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.EPersonRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class AuthorizationRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private static final Logger log = LogManager.getLogger(AuthorizationRestRepositoryIT.class);
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    @Autowired
    private SiteConverter siteConverter;
    @Autowired
    private EPersonConverter ePersonConverter;
    @Autowired
    private CommunityConverter communityConverter;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private Utils utils;
    private SiteService siteService;
    private AuthorizationFeature alwaysTrue;
    private AuthorizationFeature alwaysFalse;
    private AuthorizationFeature alwaysException;
    private AuthorizationFeature trueForAdmins;
    private AuthorizationFeature trueForLoggedUsers;
    private AuthorizationFeature trueForTestUsers;
    private AuthorizationFeature trueForUsersInGroupTest;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.siteService = ContentServiceFactory.getInstance().getSiteService();
        this.alwaysTrue = this.authorizationFeatureService.find("alwaystrue");
        this.alwaysFalse = this.authorizationFeatureService.find("alwaysfalse");
        this.alwaysException = this.authorizationFeatureService.find("alwaysexception");
        this.trueForAdmins = this.authorizationFeatureService.find("alwaystrueadmins");
        this.trueForLoggedUsers = this.authorizationFeatureService.find("alwaystruelogged");
        this.trueForTestUsers = this.authorizationFeatureService.find("alwaystruetest");
        this.trueForUsersInGroupTest = this.authorizationFeatureService.find("alwaystruetestgroup");
        this.configurationService.setProperty("webui.user.assumelogin", (Object)true);
    }

    @Test
    public void findAllTest() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        Authorization authAdminSite = new Authorization(this.admin, this.trueForAdmins, (BaseObjectRest)siteRest);
        Authorization authNormalUserSite = new Authorization(this.eperson, this.trueForLoggedUsers, (BaseObjectRest)siteRest);
        Authorization authAnonymousUserSite = new Authorization(null, this.alwaysTrue, (BaseObjectRest)siteRest);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAdminSite))));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authNormalUserSite))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authNormalUserSite))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(authAnonymousUserSite))));
    }

    @Test
    public void findOneUnauthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        Authorization authAdminSite = new Authorization(this.admin, this.alwaysTrue, (BaseObjectRest)siteRest);
        Authorization authNormalUserSite = new Authorization(this.eperson, this.alwaysTrue, (BaseObjectRest)siteRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        EPerson testEPerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("test-authorization@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        Authorization authAdminSite = new Authorization(this.admin, this.alwaysTrue, (BaseObjectRest)siteRest);
        Authorization authNormalUserSite = new Authorization(this.eperson, this.alwaysTrue, (BaseObjectRest)siteRest);
        String testToken = this.getAuthToken(testEPerson.getEmail(), this.password);
        this.getClient(testToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(testToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        Authorization noTestAuthForNormalUserSite = new Authorization(this.eperson, this.trueForTestUsers, (BaseObjectRest)siteRest);
        this.getClient(testToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + noTestAuthForNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        EPersonRest epersonRest = this.ePersonConverter.convert(this.eperson, DefaultProjection.DEFAULT);
        this.context.restoreAuthSystemState();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Authorization authAdminSite = new Authorization(this.admin, this.alwaysFalse, (BaseObjectRest)siteRest);
        Authorization authNormalUserSite = new Authorization(this.eperson, this.alwaysFalse, (BaseObjectRest)siteRest);
        Authorization authAnonymousUserSite = new Authorization(null, this.alwaysFalse, (BaseObjectRest)siteRest);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAnonymousUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String authInvalidType = this.getAuthorizationID(this.admin, this.trueForAdmins, (BaseObjectRest)epersonRest);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authInvalidType), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String authNotExistingObject = this.getAuthorizationID(this.admin, this.alwaysTrue, "core.item", (Serializable)UUID.randomUUID());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNotExistingObject), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String authNotExistingEPerson = this.getAuthorizationID(UUID.randomUUID(), this.alwaysTrue, (BaseObjectRest)siteRest);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNotExistingEPerson), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String authNotExistingFeature = this.getAuthorizationID(this.admin, "notexistingfeature", (BaseObjectRest)siteRest);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNotExistingFeature), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        Authorization noAdminAuthForNormalUserSite = new Authorization(this.eperson, this.trueForAdmins, (BaseObjectRest)siteRest);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + noAdminAuthForNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String notValidID = "notvalidID";
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + notValidID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String notValidIDWithWrongEpersonPart = this.getAuthorizationID("1", this.alwaysTrue.getName(), "core.site", (Serializable)((Object)site.getID().toString()));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + notValidIDWithWrongEpersonPart), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String notValidIDWithWrongObjectTypePart = this.getAuthorizationID(this.eperson.getID().toString(), this.alwaysTrue.getName(), "SITE", (Serializable)((Object)site.getID().toString()));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + notValidIDWithWrongObjectTypePart), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        String notValidIDWithUnknownObjectTypePart = this.getAuthorizationID(this.eperson.getID().toString(), this.alwaysTrue.getName(), "core.unknown", (Serializable)((Object)"1"));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + notValidIDWithUnknownObjectTypePart), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findOneInternalServerErrorTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        Authorization authAdminSite = new Authorization(this.admin, this.alwaysException, (BaseObjectRest)siteRest);
        Authorization authNormalUserSite = new Authorization(this.eperson, this.alwaysException, (BaseObjectRest)siteRest);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void findByObjectTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher)Matchers.is((Object)this.alwaysTrue.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName()), (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.admin.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher)Matchers.is((Object)this.alwaysTrue.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName()), (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.admin.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher)Matchers.is((Object)this.alwaysTrue.getName()), (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.eperson.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher)Matchers.is((Object)this.alwaysTrue.getName()), (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.eperson.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher)Matchers.is((Object)this.alwaysTrue.getName()), (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.eperson.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher)Matchers.is((Object)this.alwaysTrue.getName()), (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.eperson.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("projection", new String[]{"full"}).param("uri", new String[]{siteUri})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.everyItem((Matcher)Matchers.anyOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.is((Object)this.alwaysTrue.getName())})), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature", (Matcher)Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)this.alwaysFalse.getName()), (Matcher)Matchers.is((Object)this.alwaysException.getName()), (Matcher)Matchers.is((Object)this.trueForTestUsers.getName()), (Matcher)Matchers.is((Object)this.trueForAdmins.getName())))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.resourcetypes", (Matcher)Matchers.hasItem((Matcher)Matchers.is((Object)"authorization"))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.anyOf((Matcher)Matchers.startsWith((String)this.eperson.getID().toString()), (Matcher)Matchers.endsWith((String)(siteRest.getUniqueType() + "_" + siteRest.getId())))))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Test
    public void findByNotExistingObjectTest() throws Exception {
        String wrongSiteUri = "http://localhost/api/core/sites/" + UUID.randomUUID();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)JsonPathMatchers.hasNoJsonPath((String)"$._embedded.authorizations"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/authz/authorizations/search/object"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByObjectBadRequestTest() throws Exception {
        String[] invalidUris = new String[]{"invalid-uri", "", "http://localhost/api/wrongcategory/wrongmodel/1", "http://localhost/api/core/sites/this-is-not-an-uuid"};
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        for (String invalidUri : invalidUris) {
            log.debug("findByObjectBadRequestTest - Testing the URI: " + invalidUri);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        }
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByObjectUnauthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).header("X-On-Behalf-Of", new Object[]{this.admin.getID()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByObjectForbiddenTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.context.turnOffAuthorisationSystem();
        EPerson anotherEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("another@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String anotherToken = this.getAuthToken(anotherEperson.getEmail(), this.password);
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).header("X-On-Behalf-Of", new Object[]{this.admin.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByObjectInternalServerErrorTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("size", new String[]{"100"}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("size", new String[]{"100"}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("size", new String[]{"100"})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void findByObjectAndFeatureTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A test community").build();
        CommunityRest comRest = this.communityConverter.convert(com, DefaultProjection.DEFAULT);
        String comUri = this.utils.linkToSingleResource((RestAddressableModel)comRest, "self").getHref();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))))));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue())))));
    }

    @Test
    public void findByObjectAndFeatureNotGrantedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysFalse.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysFalse.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForAdmins.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForAdmins.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForAdmins.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForAdmins.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForLoggedUsers.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByNotExistingObjectAndFeatureTest() throws Exception {
        String wrongSiteUri = "http://localhost/api/core/sites/" + UUID.randomUUID();
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{wrongSiteUri}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{"not-existing-feature"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByObjectAndFeatureBadRequestTest() throws Exception {
        String[] invalidUris = new String[]{"invalid-uri", "", "http://localhost/api/wrongcategory/wrongmodel/1", "http://localhost/api/core/sites/this-is-not-an-uuid"};
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        for (String invalidUri : invalidUris) {
            log.debug("findByObjectAndFeatureBadRequestTest - Testing the URI: " + invalidUri);
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{invalidUri}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        }
    }

    @Test
    public void findByObjectAndFeatureUnauthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.admin.getID()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByObjectAndFeatureForbiddenTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.context.turnOffAuthorisationSystem();
        EPerson anotherEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("another@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String anotherToken = this.getAuthToken(anotherEperson.getEmail(), this.password);
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.admin.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByObjectAndFeatureInternalServerErrorTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysException.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysException.getName()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysException.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysException.getName()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.alwaysException.getName()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void findByMultipleObjectsAndFeaturesTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A test community").build();
        String comId = com.getID().toString();
        CommunityRest comRest = this.communityConverter.convert(com, DefaultProjection.DEFAULT);
        Community secondCom = CommunityBuilder.createCommunity((Context)this.context).withName("Another test community").build();
        String secondComId = secondCom.getID().toString();
        CommunityRest secondComRest = this.communityConverter.convert(secondCom, DefaultProjection.DEFAULT);
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Supplier<MockHttpServletRequestBuilder> baseFeatureRequest = () -> MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.community"}).param("uuid", new String[]{comId}).param("uuid", new String[]{secondComId}).param("projection", new String[]{"level"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.trueForLoggedUsers.getName()}).param("feature", new String[]{this.trueForAdmins.getName()});
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get().param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForAdmins.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForAdmins.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForAdmins.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForAdmins.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString())))})));
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForAdmins.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForAdmins.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForAdmins.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForAdmins.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString())))})));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)baseFeatureRequest.get().param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString())))})));
        this.getClient(epersonToken).perform((RequestBuilder)baseFeatureRequest.get()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString())))})));
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get().param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString())))})));
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get().header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString())))})));
        this.getClient().perform((RequestBuilder)baseFeatureRequest.get()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue())), Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue()))})));
    }

    @Test
    public void findByMultipleObjectsAndFeaturesPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A test community").build();
        String comId = com.getID().toString();
        CommunityRest comRest = this.communityConverter.convert(com, DefaultProjection.DEFAULT);
        Community secondCom = CommunityBuilder.createCommunity((Context)this.context).withName("Another test community").build();
        String secondComId = secondCom.getID().toString();
        CommunityRest secondComRest = this.communityConverter.convert(secondCom, DefaultProjection.DEFAULT);
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Supplier<MockHttpServletRequestBuilder> baseFeatureRequest = () -> MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.community"}).param("uuid", new String[]{comId}).param("uuid", new String[]{secondComId}).param("projection", new String[]{"level"}).param("page", new String[]{"1"}).param("size", new String[]{"1"}).param("embedLevelDepth", new String[]{"1"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.trueForLoggedUsers.getName()}).param("feature", new String[]{this.trueForAdmins.getName()});
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get().param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"page=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))))));
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)6))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"page=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString()))))));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)baseFeatureRequest.get().param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"page=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient(epersonToken).perform((RequestBuilder)baseFeatureRequest.get()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"page=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get().param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"page=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient(adminToken).perform((RequestBuilder)baseFeatureRequest.get().header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)4))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Matcher)Matchers.containsString((String)"page=2"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.trueForLoggedUsers.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.trueForLoggedUsers.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString()))))));
        this.getClient().perform((RequestBuilder)baseFeatureRequest.get()).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.prev.href", (Matcher)Matchers.containsString((String)"page=0"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.next.href", (Object[])new Object[0]).doesNotExist()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.alwaysTrue.getName() + "_" + secondComRest.getUniqueType() + "_" + secondComRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson", (Matcher)Matchers.nullValue())))));
    }

    @Test
    public void findByMultipleObjectsAndFeatureNotGrantedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        String itemId = item.getID().toString();
        ItemRest itemRest = this.itemConverter.convert(item, DefaultProjection.DEFAULT);
        Item secondItem = ItemBuilder.createItem((Context)this.context, (Collection)collection).build();
        String secondItemId = secondItem.getID().toString();
        ItemRest secondItemRest = this.itemConverter.convert(secondItem, DefaultProjection.DEFAULT);
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.alwaysFalse.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.alwaysFalse.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.trueForAdmins.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.trueForAdmins.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.trueForAdmins.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{itemId}).param("uuid", new String[]{secondItemId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.trueForLoggedUsers.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByNotExistingMultipleObjectsAndFeatureTest() throws Exception {
        String wrongSiteId = UUID.randomUUID().toString();
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-feature"}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{"not-existing-feature"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{"not-existing-feature"}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{"not-existing-feature"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{"not-existing-feature"}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{"not-existing-feature"}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{wrongSiteId}).param("feature", new String[]{"not-existing-one"}).param("feature", new String[]{"not-existing-feature"})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findByMultipleObjectsAndFeatureBadRequestTest() throws Exception {
        String[] invalidUris = new String[]{"foo", "", "boo-invalid", "this-is-not-an-uuid"};
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("uuid", new String[]{"foo"}).param("uuid", new String[]{""}).param("uuid", new String[]{"invalid"}).param("uuid", new String[]{"this-is-not-an-uuid"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"INVALID"}).param("uuid", new String[]{UUID.randomUUID().toString()}).param("uuid", new String[]{UUID.randomUUID().toString()}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("uuid", new String[]{UUID.randomUUID().toString()}).param("uuid", new String[]{UUID.randomUUID().toString()}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.item"}).param("feature", new String[]{this.alwaysTrue.getName()})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void findByMultipleObjectsAndFeatureUnauthorizedTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        String siteId = site.getID().toString();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.admin.getID()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findByMultipleObjectsAndFeatureForbiddenTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        String siteId = site.getID().toString();
        this.context.turnOffAuthorisationSystem();
        EPerson anotherEperson = EPersonBuilder.createEPerson((Context)this.context).withEmail("another@example.com").withPassword(this.password).build();
        this.context.restoreAuthSystemState();
        this.configurationService.setProperty("org.dspace.app.rest.authorization.AlwaysThrowExceptionFeature.turnoff", (Object)true);
        String anotherToken = this.getAuthToken(anotherEperson.getEmail(), this.password);
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.admin.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(anotherToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysFalse.getName()}).param("feature", new String[]{this.alwaysTrue.getName()}).header("X-On-Behalf-Of", new Object[]{this.eperson.getID()})).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findByMultipleObjectsAndFeatureInternalServerErrorTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        String siteId = site.getID().toString();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysException.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysException.getName()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysException.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysException.getName()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/objects", (Object[])new Object[0]).param("type", new String[]{"core.site"}).param("uuid", new String[]{siteId}).param("feature", new String[]{this.alwaysException.getName()})).andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    public void verifySpecialGroupMembershipTest() throws Exception {
        Site site = this.siteService.findSite(this.context);
        SiteRest siteRest = this.siteConverter.convert(site, DefaultProjection.DEFAULT);
        String siteUri = this.utils.linkToSingleResource((RestAddressableModel)siteRest, "self").getHref();
        this.context.turnOffAuthorisationSystem();
        EPerson memberOfTestGroup = EPersonBuilder.createEPerson((Context)this.context).withEmail("memberGroupTest@example.com").withPassword(this.password).build();
        EPerson normalUser = EPersonBuilder.createEPerson((Context)this.context).withEmail("normal@example.com").withPassword(this.password).build();
        Group testGroup = GroupBuilder.createGroup((Context)this.context).withName("Test Feature Group").addMember(memberOfTestGroup).build();
        this.context.restoreAuthSystemState();
        Authorization authAdminSite = new Authorization(this.admin, this.trueForUsersInGroupTest, (BaseObjectRest)siteRest);
        Authorization authMemberSite = new Authorization(memberOfTestGroup, this.trueForUsersInGroupTest, (BaseObjectRest)siteRest);
        Authorization authNormalUserSite = new Authorization(normalUser, this.trueForUsersInGroupTest, (BaseObjectRest)siteRest);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String normalUserToken = this.getAuthToken(normalUser.getEmail(), this.password);
        String memberToken = this.getAuthToken(memberOfTestGroup.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{normalUser.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(normalUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(normalUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{normalUser.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authMemberSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{memberOfTestGroup.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(memberToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authMemberSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(memberToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{memberOfTestGroup.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
        this.configurationService.setProperty("authentication-password.login.specialgroup", (Object)"Test Feature Group");
        adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        normalUserToken = this.getAuthToken(normalUser.getEmail(), this.password);
        memberToken = this.getAuthToken(memberOfTestGroup.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authAdminSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{normalUser.getID().toString()})).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0)));
        this.getClient(normalUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authNormalUserSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(normalUserToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{normalUser.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authMemberSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{memberOfTestGroup.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(memberToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + authMemberSite.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk());
        this.getClient(memberToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{siteUri}).param("feature", new String[]{this.trueForUsersInGroupTest.getName()}).param("eperson", new String[]{memberOfTestGroup.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void findByObjectAndFeatureFullProjectionTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity((Context)this.context).withName("A test community").build();
        CommunityRest comRest = this.communityConverter.convert(com, DefaultProjection.DEFAULT);
        String comUri = this.utils.linkToSingleResource((RestAddressableModel)comRest, "self").getHref();
        this.context.restoreAuthSystemState();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"full"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.admin.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.admin.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.admin.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.object.id", (Matcher)Matchers.is((Object)com.getID().toString())))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[0]._embedded.object._embedded.adminGroup", (Matcher)Matchers.nullValue()));
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("uri", new String[]{comUri}).param("projection", new String[]{"full"}).param("feature", new String[]{this.alwaysTrue.getName()}).param("eperson", new String[]{this.eperson.getID().toString()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations", (Matcher)Matchers.contains((Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)(this.eperson.getID().toString() + "_" + this.alwaysTrue.getName() + "_" + comRest.getUniqueType() + "_" + comRest.getId()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"authorization")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.feature.id", (Matcher)Matchers.is((Object)this.alwaysTrue.getName())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.eperson.id", (Matcher)Matchers.is((Object)this.eperson.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$._embedded.object.id", (Matcher)Matchers.is((Object)com.getID().toString())))))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.authorizations[0]._embedded.object._embedded.adminGroup", (Object[])new Object[0]).doesNotExist());
    }

    private String getAuthorizationID(EPerson eperson, AuthorizationFeature feature, BaseObjectRest obj) {
        return this.getAuthorizationID(eperson != null ? eperson.getID().toString() : null, feature.getName(), obj.getUniqueType(), obj.getId());
    }

    private String getAuthorizationID(UUID epersonUuid, AuthorizationFeature feature, BaseObjectRest obj) {
        return this.getAuthorizationID(epersonUuid != null ? epersonUuid.toString() : null, feature.getName(), obj.getUniqueType(), obj.getId());
    }

    private String getAuthorizationID(EPerson eperson, String featureName, BaseObjectRest obj) {
        return this.getAuthorizationID(eperson != null ? eperson.getID().toString() : null, featureName, obj.getUniqueType(), obj.getId());
    }

    private String getAuthorizationID(EPerson eperson, AuthorizationFeature feature, String objUniqueType, Serializable objID) {
        return this.getAuthorizationID(eperson != null ? eperson.getID().toString() : null, feature.getName(), objUniqueType, objID);
    }

    private String getAuthorizationID(String epersonUuid, String featureName, String type, Serializable id) {
        return (String)(epersonUuid != null ? epersonUuid + "_" : "") + featureName + "_" + type + "_" + id.toString();
    }
}

