/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CollectionLogoControllerIT
extends AbstractControllerIntegrationTest {
    private ObjectMapper mapper;
    private String adminAuthToken;
    private String bitstreamContent;
    private MockMultipartFile bitstreamFile;
    private Collection childCollection;

    @Before
    public void createStructure() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.childCollection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.adminAuthToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.bitstreamContent = "Hello, World!";
        this.bitstreamFile = new MockMultipartFile("file", "hello.txt", "text/plain", this.bitstreamContent.getBytes());
        this.mapper = new ObjectMapper();
    }

    private String createLogoInternal() throws Exception {
        MvcResult mvcPostResult = this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
        String postContent = mvcPostResult.getResponse().getContentAsString();
        Map mapPostResult = (Map)this.mapper.readValue(postContent, Map.class);
        return String.valueOf(mapPostResult.get("uuid"));
    }

    @Test
    public void createLogoNotLoggedIn() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void createLogo() throws Exception {
        String postUuid = this.createLogoInternal();
        assert (postUuid != null);
        MvcResult mvcGetResult = this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is2xxSuccessful()).andReturn();
        String getContent = mvcGetResult.getResponse().getContentAsString();
        Map mapGetResult = (Map)this.mapper.readValue(getContent, Map.class);
        String getUuid = String.valueOf(mapGetResult.get("uuid"));
        assert (postUuid.equals(getUuid));
    }

    @Test
    public void createLogoNoRights() throws Exception {
        String userToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createLogoByCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson collectionAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("test4@mail.com").withPassword(this.password).withCanLogin(true).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("New Community").build();
        this.childCollection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("name of collection").withAdminGroup(new EPerson[]{collectionAdmin}).build();
        this.context.restoreAuthSystemState();
        String userToken = this.getAuthToken(collectionAdmin.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    @Test
    public void createDuplicateLogo() throws Exception {
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void createLogoForNonexisting() throws Exception {
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate("16a4b65b-3b3f-4ef5-8058-ef6f5a653ef9"), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void deleteLogoNotLoggedIn() throws Exception {
        String postUuid = this.createLogoInternal();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBitstreamUrlTemplate(postUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void deleteLogo() throws Exception {
        String postUuid = this.createLogoInternal();
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBitstreamUrlTemplate(postUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(this.adminAuthToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteLogoNoRights() throws Exception {
        String postUuid = this.createLogoInternal();
        String userToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBitstreamUrlTemplate(postUuid), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void deleteLogoByCollectionAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson collectionAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("test4@mail.com").withPassword(this.password).withCanLogin(true).build();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("New Community").build();
        this.childCollection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("name of collection").withAdminGroup(new EPerson[]{collectionAdmin}).build();
        this.context.restoreAuthSystemState();
        String userToken = this.getAuthToken(collectionAdmin.getEmail(), this.password);
        MvcResult mvcPostResult = this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)this.getLogoUrlTemplate(this.childCollection.getID().toString()), (Object[])new Object[0]).file(this.bitstreamFile)).andExpect(MockMvcResultMatchers.status().isCreated()).andReturn();
        String postContent = mvcPostResult.getResponse().getContentAsString();
        Map mapPostResult = (Map)this.mapper.readValue(postContent, Map.class);
        this.getClient(userToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)this.getBitstreamUrlTemplate(String.valueOf(mapPostResult.get("uuid"))), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    private String getLogoUrlTemplate(String uuid) {
        return "/api/core/collections/" + uuid + "/logo";
    }

    private String getBitstreamUrlTemplate(String uuid) {
        return "/api/core/bitstreams/" + uuid;
    }
}

