/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.EPersonMatcher;
import org.dspace.app.rest.matcher.GroupMatcher;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.GroupRest;
import org.dspace.app.rest.model.MetadataRest;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CommunityAdminGroupRestControllerIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private CommunityService communityService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CollectionService collectionService;
    @Autowired
    private ConfigurationService configurationService;
    Collection collection;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("test").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void getCommunityAdminGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void getCommunityAdminGroupTestCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void getCommunityAdminGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void getCommunityAdminGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void getCommunityAdminGroupNoContentTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void getCommunityAdminGroupWrongCommunityUuidResourceNotFoundTest() throws Exception {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + UUID.randomUUID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupSuccess() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupExtraMetadataSuccess() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", "testingDescription"), MetadataMatcher.matchMetadata("dc.subject", "testSubject")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupDcTitleUnprocessable() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        metadataRest.put("dc.title", new MetadataValueRest[]{new MetadataValueRest("testTitle")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupSuccessCommunityAdmin() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        AtomicReference idRef = new AtomicReference();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set(UUID.fromString((String)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0]))));
        Group adminGroup = (Group)this.groupService.find(this.context, (UUID)idRef.get());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupUnAuthorized() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupForbidden() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupNotFound() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + UUID.randomUUID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupUnProcessableName() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        groupRest.setName("Fail");
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void postCommunityAdminGroupCreateAdminGroupUnProcessablePermanent() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GroupRest groupRest = new GroupRest();
        groupRest.setPermanent(true);
        MetadataRest metadataRest = new MetadataRest();
        metadataRest.put("dc.description", new MetadataValueRest[]{new MetadataValueRest("testingDescription")});
        metadataRest.put("dc.subject", new MetadataValueRest[]{new MetadataValueRest("testSubject")});
        groupRest.setMetadata(metadataRest);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)groupRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCommunityAdminGroupTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCommunityAdminGroupTestCommunityAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Group adminGroup = this.communityService.createAdministrators(this.context, child1);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + child1.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + child1.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void deleteCommunityAdminGroupUnAuthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void deleteCommunityAdminGroupForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", GroupMatcher.matchGroupEntry(adminGroup.getID(), adminGroup.getName())));
    }

    @Test
    public void deleteCommunityAdminGroupNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/communities/" + UUID.randomUUID() + "/adminGroup"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void communityAdminAddMembersToCommunityAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)false);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.not((Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail())))));
    }

    @Test
    public void communityAdminRemoveMembersFromCommunityAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)false);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
    }

    @Test
    public void communityAdminAddChildGroupToCommunityAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)false);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.not((Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName())))));
    }

    @Test
    public void communityAdminRemoveChildGroupFromCommunityAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.communityService.createAdministrators(this.context, this.parentCommunity);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
        this.configurationService.setProperty("core.authorization.community-admin.admin-group", (Object)false);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
    }

    @Test
    public void communityAdminAddChildGroupToCollectionAdminGroupSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
    }

    @Test
    public void communityAdminRemoveChildGroupFromCollectionAdminGroupSuccess() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.not((Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName())))));
    }

    @Test
    public void communityAdminAddMembersToCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.not((Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail())))));
    }

    @Test
    public void communityAdminRemoveMembersFromCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        EPerson ePerson = EPersonBuilder.createEPerson((Context)this.context).withEmail("testToAdd@test.com").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/epersons/" + ePerson.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons/" + ePerson.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/epersons"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.epersons", (Matcher)Matchers.hasItem(EPersonMatcher.matchEPersonOnEmail(ePerson.getEmail()))));
    }

    @Test
    public void communityAdminAddChildGroupToCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.not((Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName())))));
    }

    @Test
    public void communityAdminRemoveChildGroupFromCollectionAdminGroupPropertySetToFalse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group adminGroup = this.collectionService.createAdministrators(this.context, this.collection);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.parentCommunity, 11, this.eperson);
        Group group = GroupBuilder.createGroup((Context)this.context).withName("testGroup").build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.post((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/eperson/groups/" + group.getID()));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
        this.configurationService.setProperty("core.authorization.community-admin.collection.admin-group", (Object)false);
        this.configurationService.setProperty("core.authorization.collection-admin.admin-group", (Object)false);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups/" + group.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/groups/" + adminGroup.getID() + "/subgroups"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.subgroups", (Matcher)Matchers.hasItem(GroupMatcher.matchGroupWithName(group.getName()))));
    }
}

