/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class EntityTypeLabelRestControllerIT
extends AbstractEntityIntegrationTest {
    @Autowired
    private EntityTypeService entityTypeService;

    @Test
    public void testGetEntityTypeByLabel_ExistingLabel() throws Exception {
        String testLabel = "Person";
        EntityType entityType = this.entityTypeService.findByEntityType(this.context, testLabel);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/entitytypes/label/" + testLabel), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.id", (Matcher)Matchers.is((Object)entityType.getID()))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.label", (Matcher)Matchers.containsString((String)testLabel)));
    }

    @Test
    public void testGetEntityTypeByLabel_NonExistentLabel() throws Exception {
        String testLabel = "Person2";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/entitytypes/label" + testLabel), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

