/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.app.rest.matcher.ExternalSourceEntryMatcher;
import org.dspace.app.rest.matcher.ExternalSourceMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OpenAIREFundingExternalSourcesIT
extends AbstractControllerIntegrationTest {
    @Test
    public void findOneOpenAIREFundingExternalSourceTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalsources", (Matcher)Matchers.hasItem(ExternalSourceMatcher.matchExternalSource("openAIREFunding", "openAIREFunding", false))));
    }

    @Test
    public void findOneOpenAIREFundingExternalSourceEntriesEmptyWithQueryTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openAIREFunding/entries", (Object[])new Object[0]).param("query", new String[]{"empty"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findOneOpenAIREFundingExternalSourceEntriesWithQueryMultipleKeywordsTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openAIREFunding/entries", (Object[])new Object[0]).param("query", new String[]{"empty+results"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0)));
    }

    @Test
    public void findOneOpenAIREFundingExternalSourceEntriesWithQueryTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/integration/externalsources/openAIREFunding/entries", (Object[])new Object[0]).param("query", new String[]{"mushroom"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.externalSourceEntries", (Matcher)Matchers.hasItem(ExternalSourceEntryMatcher.matchExternalSourceEntry("aW5mbzpldS1yZXBvL2dyYW50QWdyZWVtZW50L05XTy8rLzIzMDAxNDc3MjgvTkw=", "Master switches of initiation of mushroom formation", "Master switches of initiation of mushroom formation", "openAIREFunding"))));
    }

    @Test
    public void findOneOpenAIREFundingExternalSourceEntryValueTest() throws Exception {
        String projectID = "aW5mbzpldS1yZXBvL2dyYW50QWdyZWVtZW50L0ZDVC81ODc2LVBQQ0RUSS8xMTAwNjIvUFQ=";
        String projectName = "Portuguese Wild Mushrooms: Chemical characterization and functional study of antiproliferative and proapoptotic properties in cancer cell lines";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/integration/externalsources/openAIREFunding/entryValues/" + projectID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)projectID)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.display", (Matcher)Matchers.is((Object)projectName)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.value", (Matcher)Matchers.is((Object)projectName)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.externalSource", (Matcher)Matchers.is((Object)"openAIREFunding")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"externalSourceEntry")))));
    }
}

