/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.model.MetadataValueRest;
import org.dspace.app.rest.model.patch.AddOperation;
import org.dspace.app.rest.model.patch.MoveOperation;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.model.patch.RemoveOperation;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractEntityIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class PatchMetadataIT
extends AbstractEntityIntegrationTest {
    private static final String SECTIONS_TRADITIONALPAGEONE_DC_CONTRIBUTOR_AUTHOR = "/sections/traditionalpageone/dc.contributor.author/%1$s";
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private WorkspaceItemService workspaceItemService;
    @Autowired
    private ConfigurationService configurationService;
    private Collection collection;
    private Collection collection2;
    private WorkspaceItem publicationWorkspaceItem;
    private Item publicationItem;
    private Item personItem1;
    private Item personItem2;
    private RelationshipType publicationPersonRelationshipType;
    private List<String> authorsOriginalOrder;
    private List<MetadataValue> authorsMetadataOriginalOrder;
    private AtomicReference<Integer> idRef1;
    private AtomicReference<Integer> idRef2;
    private String addedAuthor;
    private String replacedAuthor;

    private static final String getPath(Object element) {
        return String.format(SECTIONS_TRADITIONALPAGEONE_DC_CONTRIBUTOR_AUTHOR, element);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("Parent community").build();
        this.collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withEntityType("Person").build();
        this.collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("Collection").withEntityType("Publication").build();
        this.context.restoreAuthSystemState();
    }

    @After
    public void destroy() throws Exception {
        super.destroy();
        this.cleanupPersonRelations();
    }

    private void initPersonPublicationWorkspace() throws Exception {
        this.authorsOriginalOrder = new ArrayList<String>();
        this.authorsOriginalOrder.add("Whyte, William");
        this.authorsOriginalOrder.add("Dahlen, Sarah");
        this.authorsOriginalOrder.add("Peterson, Karrie");
        this.authorsOriginalOrder.add("Perotti, Enrico");
        this.authorsOriginalOrder.add("Linton, Oliver");
        this.addedAuthor = "Semple, Robert";
        this.replacedAuthor = "New Value";
        this.context.turnOffAuthorisationSystem();
        this.personItem1 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Person 1").withPersonIdentifierFirstName("Sarah").withPersonIdentifierLastName("Dahlen").build();
        this.personItem2 = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Person 2").withPersonIdentifierFirstName("Oliver").withPersonIdentifierLastName("Linton").build();
        this.publicationWorkspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collection2).withTitle("Publication 1").withEntityType("Publication").build();
        this.publicationPersonRelationshipType = this.relationshipTypeService.findbyTypesAndTypeName(this.context, this.entityTypeService.findByEntityType(this.context, "Publication"), this.entityTypeService.findByEntityType(this.context, "Person"), "isAuthorOfPublication", "isPublicationOfAuthor");
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        WorkspaceItem publication = this.workspaceItemService.find(this.context, this.publicationWorkspaceItem.getID().intValue());
        this.itemService.addMetadata(this.context, (DSpaceObject)publication.getItem(), "dc", "contributor", "author", "*", this.authorsOriginalOrder.get(0));
        this.workspaceItemService.update(this.context, (InProgressSubmission)publication);
        this.context.restoreAuthSystemState();
        this.idRef1 = new AtomicReference();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.publicationPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publicationWorkspaceItem.getItem().getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.personItem1.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> this.idRef1.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.context.turnOffAuthorisationSystem();
        ArrayList<String> regularMetadata = new ArrayList<String>();
        publication = this.workspaceItemService.find(this.context, this.publicationWorkspaceItem.getID().intValue());
        regularMetadata.add(this.authorsOriginalOrder.get(2));
        regularMetadata.add(this.authorsOriginalOrder.get(3));
        this.itemService.addMetadata(this.context, (DSpaceObject)publication.getItem(), "dc", "contributor", "author", null, regularMetadata);
        this.workspaceItemService.update(this.context, (InProgressSubmission)publication);
        this.context.restoreAuthSystemState();
        AtomicReference idRef2 = new AtomicReference();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/core/relationships", (Object[])new Object[0]).param("relationshipType", new String[]{this.publicationPersonRelationshipType.getID().toString()}).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("https://localhost:8080/server/api/core/items/" + this.publicationWorkspaceItem.getItem().getID() + "\nhttps://localhost:8080/server/api/core/items/" + this.personItem2.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef2.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        publication = this.workspaceItemService.find(this.context, this.publicationWorkspaceItem.getID().intValue());
        this.authorsMetadataOriginalOrder = this.itemService.getMetadata((DSpaceObject)publication.getItem(), "dc", "contributor", "author", "*");
        Assert.assertEquals((long)this.authorsMetadataOriginalOrder.size(), (long)5L);
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(0).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(0)));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(0).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(1).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(1)));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(1).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(2).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(2)));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(2).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(3).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(3)));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(3).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(4).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(4)));
        MatcherAssert.assertThat((Object)this.authorsMetadataOriginalOrder.get(4).getAuthority(), (Matcher)CoreMatchers.startsWith((String)"virtual::"));
    }

    private void initSimplePublicationItem() throws Exception {
        this.authorsOriginalOrder = new ArrayList<String>();
        this.authorsOriginalOrder.add("Whyte, William");
        this.authorsOriginalOrder.add("Dahlen, Sarah");
        this.authorsOriginalOrder.add("Peterson, Karrie");
        this.authorsOriginalOrder.add("Perotti, Enrico");
        this.authorsOriginalOrder.add("Linton, Oliver");
        this.authorsOriginalOrder.add("bla, Oliver");
        this.context.turnOffAuthorisationSystem();
        this.publicationItem = ItemBuilder.createItem((Context)this.context, (Collection)this.collection).withTitle("Publication 1").build();
        for (String author : this.authorsOriginalOrder) {
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publicationItem, "dc", "contributor", "author", "*", author);
        }
        this.context.restoreAuthSystemState();
    }

    private void cleanupPersonRelations() throws IOException, SQLException {
        if (this.idRef1 != null) {
            RelationshipBuilder.deleteRelationship((Integer)this.idRef1.get());
            this.idRef1 = null;
        }
        if (this.idRef2 != null) {
            RelationshipBuilder.deleteRelationship((Integer)this.idRef2.get());
            this.idRef2 = null;
        }
    }

    private void initPlainTextPublicationWorkspace() throws Exception {
        this.authorsOriginalOrder = new ArrayList<String>();
        this.authorsOriginalOrder.add("Whyte, William");
        this.authorsOriginalOrder.add("Dahlen, Sarah");
        this.authorsOriginalOrder.add("Peterson, Karrie");
        this.authorsOriginalOrder.add("Perotti, Enrico");
        this.authorsOriginalOrder.add("Linton, Oliver");
        this.addedAuthor = "Semple, Robert";
        this.replacedAuthor = "New Value";
        this.context.turnOffAuthorisationSystem();
        this.publicationWorkspaceItem = WorkspaceItemBuilder.createWorkspaceItem((Context)this.context, (Collection)this.collection).withTitle("Publication 1").withEntityType("Publication").build();
        WorkspaceItem publication = this.workspaceItemService.find(this.context, this.publicationWorkspaceItem.getID().intValue());
        this.itemService.addMetadata(this.context, (DSpaceObject)publication.getItem(), "dc", "contributor", "author", "*", this.authorsOriginalOrder);
        this.workspaceItemService.update(this.context, (InProgressSubmission)publication);
        this.context.restoreAuthSystemState();
        publication = this.workspaceItemService.find(this.context, this.publicationWorkspaceItem.getID().intValue());
        List publicationAuthorList = this.itemService.getMetadata((DSpaceObject)publication.getItem(), "dc", "contributor", "author", "*");
        Assert.assertEquals((long)publicationAuthorList.size(), (long)5L);
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(0)));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(0)).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(1)));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(1)).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(2)).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(2)));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(2)).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(3)).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(3)));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(3)).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(4)).getValue(), (Matcher)CoreMatchers.equalTo((Object)this.authorsOriginalOrder.get(4)));
        MatcherAssert.assertThat((Object)((MetadataValue)publicationAuthorList.get(4)).getAuthority(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.startsWith((String)"virtual::")));
    }

    @Test
    public void moveTraditionalPageOneAuthorOneToZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(1, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOneAuthorTwoToZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(2, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOneAuthorThreeToZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(3, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOneAuthorFourToZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        this.moveTraditionalPageOneAuthorTest(4, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOneAuthorOneToThreeTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(1, 3, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOneAuthorOneToFourTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        this.moveTraditionalPageOneAuthorTest(1, 4, expectedOrder);
    }

    @Test
    public void replaceTraditionalPageOneAuthorZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.replacedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.replaceTraditionalPageOneAuthorTest(0, expectedOrder);
    }

    @Test
    public void replaceTraditionalPageOneAuthorTwoTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.replacedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.replaceTraditionalPageOneAuthorTest(2, expectedOrder);
    }

    @Test
    public void replaceTraditionalPageOneAuthorThreeTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.replacedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.replaceTraditionalPageOneAuthorTest(3, expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlaceZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("0", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlaceOneTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("1", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlaceTwoTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("2", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlaceThreeTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("3", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlaceFourTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("4", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOneLastPlaceTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        expectedOrder.add(this.addedAuthor);
        this.addTraditionalPageOneAuthorTest("-", expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPageFromPlaceZeroTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(0, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPageFromPlaceOneTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(1, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPageFromPlaceTwoTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(2, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPageFromPlaceThreeTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(3, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPageFromPlaceFourTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(4, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOnePlainTextAuthorOneToZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(1, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOnePlainTextAuthorTwoToZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(2, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOnePlainTextAuthorThreeToZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(3, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOnePlainTextAuthorFourToZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        this.moveTraditionalPageOneAuthorTest(4, 0, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOnePlainTextAuthorOneToThreeTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.moveTraditionalPageOneAuthorTest(1, 3, expectedOrder);
    }

    @Test
    public void moveTraditionalPageOnePlainTextAuthorOneToFourTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        this.moveTraditionalPageOneAuthorTest(1, 4, expectedOrder);
    }

    @Test
    public void replaceTraditionalPagePlainTextOneAuthorZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.replacedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.replaceTraditionalPageOneAuthorTest(0, expectedOrder);
    }

    @Test
    public void replaceTraditionalPagePlainTextOneAuthorTwoTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.replacedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.replaceTraditionalPageOneAuthorTest(2, expectedOrder);
    }

    @Test
    public void replaceTraditionalPageOnePlainTextAuthorThreeTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.replacedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.replaceTraditionalPageOneAuthorTest(3, expectedOrder);
    }

    @Test
    public void replaceMultipleTraditionalPageOnePlainTextAuthorTest() throws Exception {
        boolean virtualMetadataEnabled = this.configurationService.getBooleanProperty("item.enable-virtual-metadata", false);
        this.configurationService.setProperty("item.enable-virtual-metadata", (Object)false);
        try {
            this.initPlainTextPublicationWorkspace();
            Map<Integer, String> replacedAuthors = Map.of(0, this.authorsOriginalOrder.get(4), 1, this.authorsOriginalOrder.get(1), 2, this.authorsOriginalOrder.get(2), 3, this.authorsOriginalOrder.get(3), 4, this.authorsOriginalOrder.get(0));
            List<String> expectedOrder = List.of(this.authorsOriginalOrder.get(4), this.authorsOriginalOrder.get(1), this.authorsOriginalOrder.get(2), this.authorsOriginalOrder.get(3), this.authorsOriginalOrder.get(0));
            this.replaceTraditionalPageMultipleAuthorsTest(replacedAuthors, expectedOrder);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.configurationService.setProperty("item.enable-virtual-metadata", (Object)virtualMetadataEnabled);
        }
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlainTextPlaceZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("0", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlainTextPlaceOneTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("1", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlainTextPlaceTwoTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("2", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlainTextPlaceThreeTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("3", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOnePlainTextPlaceFourTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.addedAuthor);
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.addTraditionalPageOneAuthorTest("4", expectedOrder);
    }

    @Test
    public void addAuthorOnTraditionalPageOneLastPlainTextPlaceTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        expectedOrder.add(this.addedAuthor);
        this.addTraditionalPageOneAuthorTest("-", expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPagePlainTextFromPlaceZeroTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(0, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPagePlainTextFromPlaceOneTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(1, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPagePlainTextFromPlaceTwoTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(2, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPagePlainTextFromPlaceThreeTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(4));
        this.removeTraditionalPageOneAuthorTest(3, expectedOrder);
    }

    @Test
    public void removeAuthorOnTraditionalPagePlainTextFromPlaceFourTest() throws Exception {
        this.initPlainTextPublicationWorkspace();
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add(this.authorsOriginalOrder.get(0));
        expectedOrder.add(this.authorsOriginalOrder.get(1));
        expectedOrder.add(this.authorsOriginalOrder.get(2));
        expectedOrder.add(this.authorsOriginalOrder.get(3));
        this.removeTraditionalPageOneAuthorTest(4, expectedOrder);
    }

    @Test
    public void removeAllAuthorsOnTraditionalPageTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation("/sections/traditionalpageone/dc.contributor.author");
        ops.add((Operation)removeOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        String authorField = "dc.contributor.author";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone", (Matcher)Matchers.allOf((Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, this.authorsOriginalOrder.get(1), 0)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, this.authorsOriginalOrder.get(4), 1)))));
    }

    @Test
    public void patchAddAllAuthorsOnTraditionalPageTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<MetadataValue> expectedValues = new ArrayList<MetadataValue>();
        expectedValues.add(this.authorsMetadataOriginalOrder.get(2));
        expectedValues.add(this.authorsMetadataOriginalOrder.get(4));
        expectedValues.add(this.authorsMetadataOriginalOrder.get(0));
        this.patchAddEntireArray(expectedValues);
    }

    @Test
    public void patchAddAllAuthorsOnTraditionalPageNotExistentRelationTest() throws Exception {
        this.initPersonPublicationWorkspace();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ArrayList<MetadataValueRest> value = new ArrayList<MetadataValueRest>();
        MetadataValueRest mrv = new MetadataValueRest();
        value.add(mrv);
        mrv.setValue("Dumbar, John");
        mrv.setAuthority("virtual::2147483647");
        AddOperation add = new AddOperation("/sections/traditionalpageone/dc.contributor.author", value);
        ops.add((Operation)add);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }

    @Test
    public void moveMetadataAuthorOneToTwoTest() throws Exception {
        this.initSimplePublicationItem();
        List<String> expectedOrder = List.of(this.authorsOriginalOrder.get(0), this.authorsOriginalOrder.get(2), this.authorsOriginalOrder.get(1), this.authorsOriginalOrder.get(3), this.authorsOriginalOrder.get(4));
        List<MoveOperation> moves = List.of(this.getMetadataMoveAuthorOperation(1, 2));
        this.moveMetadataAuthorTest(moves, expectedOrder);
    }

    @Test
    public void moveMetadataAuthorTwoToOneTest() throws Exception {
        this.initSimplePublicationItem();
        List<String> expectedOrder = List.of(this.authorsOriginalOrder.get(0), this.authorsOriginalOrder.get(2), this.authorsOriginalOrder.get(1), this.authorsOriginalOrder.get(3), this.authorsOriginalOrder.get(4));
        List<MoveOperation> moves = List.of(this.getMetadataMoveAuthorOperation(2, 1));
        this.moveMetadataAuthorTest(moves, expectedOrder);
    }

    @Test
    public void moveMetadataAuthorOneToFourTest() throws Exception {
        this.initSimplePublicationItem();
        List<String> expectedOrder = List.of(this.authorsOriginalOrder.get(0), this.authorsOriginalOrder.get(2), this.authorsOriginalOrder.get(3), this.authorsOriginalOrder.get(4), this.authorsOriginalOrder.get(1));
        List<MoveOperation> moves = List.of(this.getMetadataMoveAuthorOperation(1, 4));
        this.moveMetadataAuthorTest(moves, expectedOrder);
    }

    @Test
    public void moveMetadataAuthorFourToOneTest() throws Exception {
        this.initSimplePublicationItem();
        List<String> expectedOrder = List.of(this.authorsOriginalOrder.get(0), this.authorsOriginalOrder.get(4), this.authorsOriginalOrder.get(1), this.authorsOriginalOrder.get(2), this.authorsOriginalOrder.get(3));
        List<MoveOperation> moves = List.of(this.getMetadataMoveAuthorOperation(4, 1));
        this.moveMetadataAuthorTest(moves, expectedOrder);
    }

    @Test
    public void moveMetadataAuthorFourToOneMultiOpTest() throws Exception {
        this.initSimplePublicationItem();
        List<String> expectedOrder = List.of(this.authorsOriginalOrder.get(0), this.authorsOriginalOrder.get(4), this.authorsOriginalOrder.get(1), this.authorsOriginalOrder.get(2), this.authorsOriginalOrder.get(3));
        List<MoveOperation> moves = List.of(this.getMetadataMoveAuthorOperation(1, 2), this.getMetadataMoveAuthorOperation(1, 3), this.getMetadataMoveAuthorOperation(2, 4), this.getMetadataMoveAuthorOperation(3, 1));
        this.moveMetadataAuthorTest(moves, expectedOrder);
    }

    private void moveTraditionalPageOneAuthorTest(int from, int path, List<String> expectedOrder) throws Exception {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        MoveOperation moveOperation = this.getTraditionalPageOneMoveAuthorOperation(from, path);
        ops.add((Operation)moveOperation);
        String patchBody = this.getPatchContent(ops);
        this.assertReplacementOrder(expectedOrder, patchBody);
    }

    private void moveMetadataAuthorTest(List<Operation> moves, List<String> expectedOrder) throws Exception {
        String patchBody = this.getPatchContent(moves);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/items/" + this.publicationItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        String authorField = "dc.contributor.author";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + this.publicationItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf((Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(0), 0)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(1), 1)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(2), 2)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(3), 3)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(4), 4)))));
    }

    private void replaceTraditionalPageOneAuthorTest(int path, List<String> expectedOrder) throws Exception {
        String patchBody = this.getPatchContent(List.of(this.mapToReplaceOperation(path, this.replacedAuthor)));
        this.assertReplacementOrder(expectedOrder, patchBody);
    }

    private void replaceTraditionalPageMultipleAuthorsTest(Map<Integer, String> values, List<String> expectedOrder) throws Exception {
        List<Operation> ops = values.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> this.mapToReplaceOperation((Integer)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        String patchBody = this.getPatchContent(ops);
        this.assertReplacementOrder(expectedOrder, patchBody);
    }

    private ReplaceOperation mapToReplaceOperation(int path, String author) {
        return new ReplaceOperation(PatchMetadataIT.getPath(path), (Object)new MetadataValueRest(author));
    }

    private void assertReplacementOrder(List<String> expectedOrder, String patchBody) throws Exception, SQLException {
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        String authorField = "dc.contributor.author";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone", (Matcher)Matchers.allOf((Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(0), 0)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(1), 1)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(2), 2)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(3), 3)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(4), 4)))));
    }

    private void addTraditionalPageOneAuthorTest(String path, List<String> expectedOrder) throws Exception {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        MetadataValueRest value = new MetadataValueRest();
        value.setValue(this.addedAuthor);
        AddOperation addOperation = new AddOperation(PatchMetadataIT.getPath(path), (Object)value);
        ops.add((Operation)addOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        String authorField = "dc.contributor.author";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone", (Matcher)Matchers.allOf((Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(0), 0)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(1), 1)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(2), 2)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(3), 3)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(4), 4)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(5), 5)))));
    }

    private void removeTraditionalPageOneAuthorTest(int path, List<String> expectedOrder) throws Exception {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        RemoveOperation removeOperation = new RemoveOperation(PatchMetadataIT.getPath(path));
        ops.add((Operation)removeOperation);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        String authorField = "dc.contributor.author";
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone", (Matcher)Matchers.allOf((Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(0), 0)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(1), 1)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(2), 2)), (Matcher)Matchers.is(MetadataMatcher.matchMetadata(authorField, expectedOrder.get(3), 3)))));
    }

    private void patchAddEntireArray(List<MetadataValue> metadataValues) throws Exception {
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ArrayList value = new ArrayList();
        metadataValues.stream().forEach(mv -> {
            MetadataValueRest mrv = new MetadataValueRest();
            value.add(mrv);
            mrv.setValue(mv.getValue());
            if (mv.getAuthority() != null && mv.getAuthority().startsWith("virtual::")) {
                mrv.setAuthority(mv.getAuthority());
                mrv.setConfidence(mv.getConfidence());
            }
        });
        AddOperation add = new AddOperation("/sections/traditionalpageone/dc.contributor.author", value);
        ops.add((Operation)add);
        String patchBody = this.getPatchContent(ops);
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0]).content(patchBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk());
        String authorField = "dc.contributor.author";
        ArrayList matchers = new ArrayList();
        IntStream.range(0, metadataValues.size()).forEach(i -> matchers.add(Matchers.is(MetadataMatcher.matchMetadata("dc.contributor.author", ((MetadataValue)metadataValues.get(i)).getValue(), i))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/submission/workspaceitems/" + this.publicationWorkspaceItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().contentType(this.contentType)).andExpect(MockMvcResultMatchers.jsonPath((String)"$.sections.traditionalpageone", (Matcher)Matchers.allOf(matchers)));
    }

    private MoveOperation getTraditionalPageOneMoveAuthorOperation(int from, int path) {
        return new MoveOperation(PatchMetadataIT.getPath(path), PatchMetadataIT.getPath(from));
    }

    private MoveOperation getMetadataMoveAuthorOperation(int from, int path) {
        return new MoveOperation("/metadata/dc.contributor.author/" + path, "/metadata/dc.contributor.author/" + from);
    }
}

