/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.matcher.RegistrationMatcher;
import org.dspace.app.rest.model.RegistrationRest;
import org.dspace.app.rest.repository.RegistrationRestRepository;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.EPersonBuilder;
import org.dspace.core.Context;
import org.dspace.eperson.CaptchaServiceImpl;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.dao.RegistrationDataDAO;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class RegistrationRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private CaptchaServiceImpl captchaService;
    @Autowired
    private RegistrationDataDAO registrationDataDAO;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private RegistrationRestRepository registrationRestRepository;

    @Test
    public void findByTokenTestExistingUserTest() throws Exception {
        String email = this.eperson.getEmail();
        this.createTokenForEmail(email);
        RegistrationData registrationData = this.registrationDataDAO.findByEmail(this.context, email);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, this.eperson.getID()))));
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
            email = "newUser@testnewuser.com";
            this.createTokenForEmail(email);
            registrationData = this.registrationDataDAO.findByEmail(this.context, email);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, null))));
        }
        finally {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @Test
    public void findByTokenTestNewUserTest() throws Exception {
        String email = "newUser@testnewuser.com";
        this.createTokenForEmail(email);
        RegistrationData registrationData = this.registrationDataDAO.findByEmail(this.context, email);
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registrations/search/findByToken", (Object[])new Object[0]).param("token", new String[]{registrationData.getToken()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(RegistrationMatcher.matchRegistration(email, null))));
        }
        finally {
            this.registrationDataDAO.delete(this.context, (Object)registrationData);
        }
    }

    @Test
    public void findByTokenNotExistingTokenTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/registration/search/findByToken", (Object[])new Object[0]).param("token", new String[]{"ThisTokenDoesNotExist"})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private void createTokenForEmail(String email) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(email);
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registrationFlowTest() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        Assert.assertEquals((long)0L, (long)registrationDataList.size());
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
            String newEmail = "newEPersonTest@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertTrue((registrationDataList.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) || StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
            this.configurationService.setProperty("user.registration", (Object)false);
            newEmail = "newEPersonTestTwo@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is(401));
            Assert.assertEquals((long)2L, (long)registrationDataList.size());
            Assert.assertTrue((!StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) && !StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterDomainRegistered() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            this.configurationService.setProperty("authentication-password.domain.valid", (Object)"test.com");
            RegistrationRest registrationRest = new RegistrationRest();
            String email = "testPerson@test.com";
            registrationRest.setEmail(email);
            ObjectMapper mapper = new ObjectMapper();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)email));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterDomainNotRegistered() throws Exception {
        try {
            this.configurationService.setProperty("authentication-password.domain.valid", (Object)"test.com");
            RegistrationRest registrationRest = new RegistrationRest();
            String email = "testPerson@bladibla.com";
            registrationRest.setEmail(email);
            ObjectMapper mapper = new ObjectMapper();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        }
        finally {
            List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterMailAddressRegistered() throws Exception {
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            this.context.turnOffAuthorisationSystem();
            String email = "test@gmail.com";
            EPersonBuilder.createEPerson((Context)this.context).withEmail(email).withCanLogin(true).build();
            this.context.restoreAuthSystemState();
            RegistrationRest registrationRest = new RegistrationRest();
            registrationRest.setEmail(email);
            ObjectMapper mapper = new ObjectMapper();
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)email));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void forgotPasswordTest() throws Exception {
        this.configurationService.setProperty("user.registration", (Object)false);
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        try {
            Assert.assertEquals((long)0L, (long)registrationDataList.size());
            ObjectMapper mapper = new ObjectMapper();
            RegistrationRest registrationRest = new RegistrationRest();
            registrationRest.setEmail(this.eperson.getEmail());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"forgot"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
        }
        finally {
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
        }
    }

    @Test
    public void registrationFlowWithNoHeaderCaptchaTokenTest() throws Exception {
        String originVerification = this.configurationService.getProperty("registration.verification.enabled");
        String originSecret = this.configurationService.getProperty("google.recaptcha.key.secret");
        String originVresion = this.configurationService.getProperty("google.recaptcha.version");
        this.reloadCaptchaProperties("true", "test-secret", "v2");
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.reloadCaptchaProperties(originVerification, originSecret, originVresion);
    }

    @Test
    public void registrationFlowWithInvalidCaptchaTokenTest() throws Exception {
        String originVerification = this.configurationService.getProperty("registration.verification.enabled");
        String originSecret = this.configurationService.getProperty("google.recaptcha.key.secret");
        String originVresion = this.configurationService.getProperty("google.recaptcha.version");
        this.reloadCaptchaProperties("true", "test-secret", "v2");
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        String captchaToken = "invalid-captcha-Token";
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).header("X-Recaptcha-Token", new Object[]{captchaToken}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.reloadCaptchaProperties(originVerification, originSecret, originVresion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void registrationFlowWithValidCaptchaTokenTest() throws Exception {
        String originVerification = this.configurationService.getProperty("registration.verification.enabled");
        String originSecret = this.configurationService.getProperty("google.recaptcha.key.secret");
        String originVresion = this.configurationService.getProperty("google.recaptcha.version");
        this.reloadCaptchaProperties("true", "test-secret", "v2");
        String captchaToken = "123456";
        String captchaToken1 = "12345676866";
        CaptchaService captchaServiceMock = (CaptchaService)Mockito.mock(CaptchaService.class);
        this.registrationRestRepository.setCaptchaService(captchaServiceMock);
        ((CaptchaService)Mockito.doThrow((Throwable[])new Throwable[]{new InvalidReCaptchaException("Invalid captcha token")}).when((Object)captchaServiceMock)).processResponse((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((CaptchaService)Mockito.doNothing().when((Object)captchaServiceMock)).processResponse((String)ArgumentMatchers.eq((Object)captchaToken), (String)ArgumentMatchers.eq((Object)"register_email"));
        List registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
        Assert.assertEquals((long)0L, (long)registrationDataList.size());
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        try {
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).header("X-Recaptcha-Token", new Object[]{captchaToken1}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isForbidden());
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).header("X-Recaptcha-Token", new Object[]{captchaToken}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertEquals((long)1L, (long)registrationDataList.size());
            Assert.assertTrue((boolean)StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)this.eperson.getEmail()));
            String newEmail = "newEPersonTest@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).header("X-Recaptcha-Token", new Object[]{captchaToken}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isCreated());
            registrationDataList = this.registrationDataDAO.findAll(this.context, RegistrationData.class);
            Assert.assertTrue((registrationDataList.size() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) || StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
            this.configurationService.setProperty("user.registration", (Object)false);
            newEmail = "newEPersonTestTwo@gmail.com";
            registrationRest.setEmail(newEmail);
            this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"register"}).header("X-Recaptcha-Token", new Object[]{captchaToken}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().is(401));
            Assert.assertEquals((long)2L, (long)registrationDataList.size());
            Assert.assertTrue((!StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(0)).getEmail(), (CharSequence)newEmail) && !StringUtils.equalsIgnoreCase((CharSequence)((RegistrationData)registrationDataList.get(1)).getEmail(), (CharSequence)newEmail) ? 1 : 0) != 0);
        }
        finally {
            this.registrationRestRepository.setCaptchaService((CaptchaService)this.captchaService);
            for (RegistrationData registrationData : registrationDataList) {
                this.registrationDataDAO.delete(this.context, (Object)registrationData);
            }
            this.reloadCaptchaProperties(originVerification, originSecret, originVresion);
        }
    }

    private void reloadCaptchaProperties(String verification, String secret, String version) {
        this.configurationService.setProperty("registration.verification.enabled", (Object)verification);
        this.configurationService.setProperty("google.recaptcha.key.secret", (Object)secret);
        this.configurationService.setProperty("google.recaptcha.version", (Object)version);
        this.captchaService.init();
    }

    @Test
    public void accountEndpoint_WithoutAccountTypeParam() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void accountEndpoint_WrongAccountTypeParam() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        RegistrationRest registrationRest = new RegistrationRest();
        registrationRest.setEmail(this.eperson.getEmail());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/registrations", (Object[])new Object[0]).param("accountRequestType", new String[]{"nonValidValue"}).content(mapper.writeValueAsBytes((Object)registrationRest)).contentType(this.contentType)).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }
}

