/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.dspace.app.rest.AbstractLiveImportIntegrationTest;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.liveimportclient.service.LiveImportClientImpl;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.scopus.service.ScopusImportMetadataSourceServiceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class ScopusImportMetadataSourceServiceIT
extends AbstractLiveImportIntegrationTest {
    @Autowired
    private ScopusImportMetadataSourceServiceImpl scopusServiceImpl;
    @Autowired
    private LiveImportClientImpl liveImportClientImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scopusImportMetadataGetRecordsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String originApiKey = this.scopusServiceImpl.getApiKey();
        if (StringUtils.isBlank((CharSequence)originApiKey)) {
            this.scopusServiceImpl.setApiKey("testApiKey");
        }
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("scopus-ex.xml");){
            String scopusXmlResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(scopusXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            ArrayList<ImportRecord> collection2match = this.getRecords();
            Collection recordsImported = this.scopusServiceImpl.getRecords("roma", 0, 2);
            Assert.assertEquals((long)2L, (long)recordsImported.size());
            this.matchRecords(new ArrayList<ImportRecord>(recordsImported), collection2match);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
            this.scopusServiceImpl.setApiKey(originApiKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scopusImportMetadataGetRecordsCountTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String originApiKey = this.scopusServiceImpl.getApiKey();
        if (StringUtils.isBlank((CharSequence)originApiKey)) {
            this.scopusServiceImpl.setApiKey("testApiKey");
        }
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("scopus-ex.xml");){
            String scopusXmlResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(scopusXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            int tot = this.scopusServiceImpl.getRecordsCount("roma");
            Assert.assertEquals((long)2L, (long)tot);
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
            this.scopusServiceImpl.setApiKey(originApiKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scopusImportMetadataGetRecordsEmptyResponseTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        String originApiKey = this.scopusServiceImpl.getApiKey();
        if (StringUtils.isBlank((CharSequence)originApiKey)) {
            this.scopusServiceImpl.setApiKey("testApiKey");
        }
        CloseableHttpClient originalHttpClient = this.liveImportClientImpl.getHttpClient();
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        try (InputStream file = ((Object)((Object)this)).getClass().getResourceAsStream("scopus-empty-resp.xml");){
            String scopusXmlResp = IOUtils.toString((InputStream)file, (Charset)Charset.defaultCharset());
            this.liveImportClientImpl.setHttpClient(httpClient);
            CloseableHttpResponse response = this.mockResponse(scopusXmlResp, 200, "OK");
            Mockito.when((Object)httpClient.execute((HttpUriRequest)ArgumentMatchers.any())).thenReturn((Object)response);
            this.context.restoreAuthSystemState();
            Collection recordsImported = this.scopusServiceImpl.getRecords("roma", 0, 20);
            Assert.assertTrue((boolean)recordsImported.isEmpty());
        }
        finally {
            this.liveImportClientImpl.setHttpClient(originalHttpClient);
            this.scopusServiceImpl.setApiKey(originApiKey);
        }
    }

    private ArrayList<ImportRecord> getRecords() {
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        MetadatumDTO doi = this.createMetadatumDTO("dc", "identifier", null, "10.3934/mine.2023004");
        MetadatumDTO title = this.createMetadatumDTO("dc", "title", null, "Hardy potential versus lower order terms in Dirichlet problems: regularizing effects<sup>\u2020</sup>");
        MetadatumDTO type = this.createMetadatumDTO("dc", "type", null, "Journal");
        MetadatumDTO date = this.createMetadatumDTO("dc", "date", "issued", "2023-01-01");
        MetadatumDTO scopusId = this.createMetadatumDTO("dc", "identifier", "other", "2-s2.0-85124241875");
        MetadatumDTO citationVolume = this.createMetadatumDTO("oaire", "citation", "volume", "5");
        MetadatumDTO citationIssue = this.createMetadatumDTO("oaire", "citation", "issue", "1");
        MetadatumDTO subject = this.createMetadatumDTO("dc", "subject", null, "Hardy potentials | Laplace equation | Summability of solutions");
        MetadatumDTO author = this.createMetadatumDTO("dc", "contributor", "author", "Arcoya D.");
        MetadatumDTO scopusAuthorId = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "6602330574");
        MetadatumDTO orgunit = this.createMetadatumDTO("person", "affiliation", "name", "Universidad de Granada");
        MetadatumDTO author2 = this.createMetadatumDTO("dc", "contributor", "author", "Boccardo L.");
        MetadatumDTO scopusAuthorId2 = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "7003612261");
        MetadatumDTO orgunit2 = this.createMetadatumDTO("person", "affiliation", "name", "Sapienza Universit\u00e0 di Roma");
        MetadatumDTO author3 = this.createMetadatumDTO("dc", "contributor", "author", "Orsina L.");
        MetadatumDTO scopusAuthorId3 = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "6602595438");
        MetadatumDTO orgunit3 = this.createMetadatumDTO("person", "affiliation", "name", "Sapienza Universit\u00e0 di Roma");
        MetadatumDTO rights = this.createMetadatumDTO("dc", "rights", null, "true");
        MetadatumDTO ispartof = this.createMetadatumDTO("dc", "relation", "ispartof", "Mathematics In Engineering");
        MetadatumDTO ispartofseries = this.createMetadatumDTO("dc", "relation", "ispartofseries", "Mathematics In Engineering");
        metadatums.add(doi);
        metadatums.add(title);
        metadatums.add(type);
        metadatums.add(date);
        metadatums.add(scopusId);
        metadatums.add(citationVolume);
        metadatums.add(citationIssue);
        metadatums.add(subject);
        metadatums.add(author);
        metadatums.add(scopusAuthorId);
        metadatums.add(orgunit);
        metadatums.add(author2);
        metadatums.add(scopusAuthorId2);
        metadatums.add(orgunit2);
        metadatums.add(author3);
        metadatums.add(scopusAuthorId3);
        metadatums.add(orgunit3);
        metadatums.add(rights);
        metadatums.add(ispartof);
        metadatums.add(ispartofseries);
        ImportRecord firstrRecord = new ImportRecord(metadatums);
        ArrayList<MetadatumDTO> metadatums2 = new ArrayList<MetadatumDTO>();
        MetadatumDTO doi2 = this.createMetadatumDTO("dc", "identifier", null, "10.3934/mine.2023001");
        MetadatumDTO title2 = this.createMetadatumDTO("dc", "title", null, "Large deviations for a binary collision model: energy evaporation<sup>\u2020</sup>");
        MetadatumDTO date2 = this.createMetadatumDTO("dc", "date", "issued", "2023-01-01");
        MetadatumDTO scopusId2 = this.createMetadatumDTO("dc", "identifier", "other", "2-s2.0-85124226483");
        MetadatumDTO type2 = this.createMetadatumDTO("dc", "type", null, "Journal");
        MetadatumDTO citationVolume2 = this.createMetadatumDTO("oaire", "citation", "volume", "5");
        MetadatumDTO citationIssue2 = this.createMetadatumDTO("oaire", "citation", "issue", "1");
        MetadatumDTO subject2 = this.createMetadatumDTO("dc", "subject", null, "Boltzmann equation | Discrete energy model | Kac model | Large deviations | Violation of energy conservation");
        MetadatumDTO author4 = this.createMetadatumDTO("dc", "contributor", "author", "Basile G.");
        MetadatumDTO scopusAuthorId4 = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "55613229065");
        MetadatumDTO orgunit4 = this.createMetadatumDTO("person", "affiliation", "name", "Sapienza Universit\u00e0 di Roma");
        MetadatumDTO author5 = this.createMetadatumDTO("dc", "contributor", "author", "Benedetto D.");
        MetadatumDTO scopusAuthorId5 = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "55893665100");
        MetadatumDTO orgunit5 = this.createMetadatumDTO("person", "affiliation", "name", "Sapienza Universit\u00e0 di Roma");
        MetadatumDTO author6 = this.createMetadatumDTO("dc", "contributor", "author", "Caglioti E.");
        MetadatumDTO scopusAuthorId6 = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "7004588675");
        MetadatumDTO orgunit6 = this.createMetadatumDTO("person", "affiliation", "name", "Sapienza Universit\u00e0 di Roma");
        MetadatumDTO author7 = this.createMetadatumDTO("dc", "contributor", "author", "Bertini L.");
        MetadatumDTO scopusAuthorId7 = this.createMetadatumDTO("person", "identifier", "scopus-author-id", "7005555198");
        MetadatumDTO orgunit7 = this.createMetadatumDTO("person", "affiliation", "name", "Sapienza Universit\u00e0 di Roma");
        MetadatumDTO rights2 = this.createMetadatumDTO("dc", "rights", null, "true");
        MetadatumDTO ispartof2 = this.createMetadatumDTO("dc", "relation", "ispartof", "Mathematics In Engineering");
        MetadatumDTO ispartofseries2 = this.createMetadatumDTO("dc", "relation", "ispartofseries", "Mathematics In Engineering");
        metadatums2.add(doi2);
        metadatums2.add(title2);
        metadatums2.add(type2);
        metadatums2.add(date2);
        metadatums2.add(scopusId2);
        metadatums2.add(citationVolume2);
        metadatums2.add(citationIssue2);
        metadatums2.add(subject2);
        metadatums2.add(author4);
        metadatums2.add(scopusAuthorId4);
        metadatums2.add(orgunit4);
        metadatums2.add(author5);
        metadatums2.add(scopusAuthorId5);
        metadatums2.add(orgunit5);
        metadatums2.add(author6);
        metadatums2.add(scopusAuthorId6);
        metadatums2.add(orgunit6);
        metadatums2.add(author7);
        metadatums2.add(scopusAuthorId7);
        metadatums2.add(orgunit7);
        metadatums2.add(rights2);
        metadatums2.add(ispartof2);
        metadatums2.add(ispartofseries2);
        ImportRecord secondRecord = new ImportRecord(metadatums2);
        records.add(firstrRecord);
        records.add(secondRecord);
        return records;
    }
}

