/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.util.List;
import java.util.UUID;
import org.dspace.app.rest.matcher.MetadataMatcher;
import org.dspace.app.rest.matcher.SiteMatcher;
import org.dspace.app.rest.model.patch.ReplaceOperation;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.test.MetadataPatchSuite;
import org.dspace.builder.SiteBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.Site;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class SiteRestRepositoryIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private SiteService siteService;

    @Test
    public void findAll() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/core/sites", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.sites[0]", SiteMatcher.matchEntry(site))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/sites"))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)20)));
    }

    @Test
    public void findOne() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/sites/" + site.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", SiteMatcher.matchEntry(site))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/sites")));
    }

    @Test
    public void findOneWrongUUID() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/sites/" + UUID.randomUUID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void patchSiteMetadataAuthorized() throws Exception {
        this.runPatchMetadataTests(this.admin, 200);
    }

    @Test
    public void patchSiteMetadataUnauthorized() throws Exception {
        this.runPatchMetadataTests(this.eperson, 403);
    }

    @Test
    public void patchReplaceMultipleDescriptionSite() throws Exception {
        this.context.turnOffAuthorisationSystem();
        List<String> siteDescriptions = List.of("FIRST", "SECOND", "THIRD");
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.siteService.addMetadata(this.context, (DSpaceObject)site, MetadataSchemaEnum.DC.getName(), "description", null, "*", siteDescriptions);
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/sites/" + site.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(0), 0), MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(1), 1), MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(2), 2))));
        List<ReplaceOperation> ops = List.of(new ReplaceOperation("/metadata/dc.description/0", (Object)siteDescriptions.get(2)), new ReplaceOperation("/metadata/dc.description/1", (Object)siteDescriptions.get(0)), new ReplaceOperation("/metadata/dc.description/2", (Object)siteDescriptions.get(1)));
        String requestBody = this.getPatchContent(ops);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.patch((String)("/api/core/sites/" + site.getID()), (Object[])new Object[0]).content(requestBody).contentType("application/json-patch+json")).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(2), 0), MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(0), 1), MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(1), 2))));
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/sites/" + site.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.metadata", (Matcher)Matchers.allOf(MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(2), 0), MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(0), 1), MetadataMatcher.matchMetadata("dc.description", siteDescriptions.get(1), 2))));
    }

    private void runPatchMetadataTests(EPerson asUser, int expectedStatus) throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        String token = this.getAuthToken(asUser.getEmail(), this.password);
        new MetadataPatchSuite().runWith(this.getClient(token), "/api/core/sites/" + site.getID(), expectedStatus);
    }
}

