/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.GroupBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.SiteBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class UUIDLookupRestControllerIT
extends AbstractControllerIntegrationTest {
    @Test
    public void testSiteUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Site site = SiteBuilder.createSite((Context)this.context).build();
        this.context.restoreAuthSystemState();
        String uuid = site.getID().toString();
        String siteDetail = "http://localhost/api/core/sites/" + uuid;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", siteDetail));
    }

    @Test
    public void testCommunityUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("A Community").build();
        this.context.restoreAuthSystemState();
        String uuid = community.getID().toString();
        String communityDetail = "http://localhost/api/core/communities/" + uuid;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", communityDetail));
    }

    @Test
    public void testCollectionUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("A Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("A Collection").build();
        this.context.restoreAuthSystemState();
        String uuid = collection.getID().toString();
        String collectionDetail = "http://localhost/api/core/collections/" + uuid;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", collectionDetail));
    }

    @Test
    public void testItemUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("A Community").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("A Collection").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("An Item").build();
        this.context.restoreAuthSystemState();
        String uuid = item.getID().toString();
        String itemDetail = "http://localhost/api/core/items/" + uuid;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", itemDetail));
    }

    @Test
    @Ignore
    public void testBundleUUID() throws Exception {
    }

    @Test
    public void testBitstreamUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity((Context)this.context).withName("A Community").withLogo("Community Logo").build();
        Collection collection = CollectionBuilder.createCollection((Context)this.context, (Community)community).withName("A Collection").withLogo("Collection Logo").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)collection).withTitle("An Item").build();
        Bitstream bitstream = null;
        try (InputStream is = IOUtils.toInputStream((String)"bitstreamContent", (String)"UTF-8");){
            bitstream = BitstreamBuilder.createBitstream((Context)this.context, (Item)item, (InputStream)is).withName("Bitstream").withDescription("description").withMimeType("text/plain").build();
        }
        this.context.restoreAuthSystemState();
        String uuid = bitstream.getID().toString();
        String colLogoUuid = community.getLogo().getID().toString();
        String comLogoUuid = collection.getLogo().getID().toString();
        String bitstreamDetail = "http://localhost/api/core/bitstreams/" + uuid;
        String colLogoDetail = "http://localhost/api/core/bitstreams/" + colLogoUuid;
        String comLogoDetail = "http://localhost/api/core/bitstreams/" + comLogoUuid;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", bitstreamDetail));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{comLogoUuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", comLogoDetail));
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{colLogoUuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", colLogoDetail));
    }

    @Test
    public void testEPersonUUID() throws Exception {
        String uuid = this.eperson.getID().toString();
        String epersonDetail = "http://localhost/api/eperson/epersons/" + uuid;
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", epersonDetail));
    }

    @Test
    public void testGroupUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Group group = GroupBuilder.createGroup((Context)this.context).withName("Test Group").build();
        this.context.restoreAuthSystemState();
        String uuid = group.getID().toString();
        String groupDetail = "http://localhost/api/eperson/groups/" + uuid;
        String token = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{uuid})).andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", groupDetail));
    }

    @Test
    public void testUnexistentUUID() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{UUID.randomUUID().toString()})).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testInvalidUUID() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find?uuid={uuid}", (Object[])new Object[]{"invalidUUID"})).andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @Ignore
    public void testMissingIdentifierParameter() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/dso/find", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
    }
}

