/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.rest.matcher.VersionHistoryMatcher;
import org.dspace.app.rest.matcher.VersionMatcher;
import org.dspace.app.rest.matcher.WorkflowItemMatcher;
import org.dspace.app.rest.matcher.WorkspaceItemMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.VersionBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class VersionHistoryRestRepositoryIT
extends AbstractControllerIntegrationTest {
    VersionHistory versionHistory;
    Item item;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private VersionHistoryService versionHistoryService;
    @Autowired
    private VersioningService versioningService;
    @Autowired
    private WorkspaceItemService workspaceItemService;

    @Before
    public void setup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.versionHistory = (VersionHistory)this.versionHistoryService.create(this.context);
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("Sub Community").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)child1).withName("Collection 1").build();
        this.item = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
    }

    @After
    public void cleanup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.versionHistoryService.delete(this.context, (Object)this.versionHistory);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void findOnePublicVersionHistoryTest() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionHistoryMatcher.matchEntry(this.versionHistory)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.versions.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.draftVersion.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versionhistories/" + this.versionHistory.getID() + "/draftVersion"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versionhistories/" + this.versionHistory.getID()))})));
    }

    @Test
    public void findOnePublicVersionHistoryWithVersioningDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.enabled", (Object)false);
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOnePrivateVersionHistoryByAdminTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)true);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, item);
        this.context.turnOffAuthorisationSystem();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.draftVersion", (Matcher)Matchers.is((Object)true))).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionHistoryMatcher.matchEntry(versionHistory))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)true);
        String token = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(token).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneWrongIDTest() throws Exception {
        int wrongVersionHistoryId = (this.versionHistory.getID() + 5) * 57;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + wrongVersionHistoryId), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findVersionsOneWrongIDTest() throws Exception {
        int wrongVersionHistoryId = (this.versionHistory.getID() + 5) * 57;
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + wrongVersionHistoryId + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findVersionsOfVersionHistoryAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, item);
        Version version = this.versioningService.getVersion(this.context, item);
        this.context.turnOffAuthorisationSystem();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.containsInRelativeOrder((Matcher[])new Matcher[]{VersionMatcher.matchEntry(version2), VersionMatcher.matchEntry(version)})));
        this.context.turnOffAuthorisationSystem();
        Version version3 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test3").build();
        this.context.restoreAuthSystemState();
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.containsInRelativeOrder((Matcher[])new Matcher[]{VersionMatcher.matchEntry(version3), VersionMatcher.matchEntry(version2), VersionMatcher.matchEntry(version)})));
    }

    @Test
    public void findVersionsOfVersionHistoryUnauthorizedTest() throws Exception {
        this.configurationService.setProperty("versioning.item.history.view.admin", (Object)true);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, item);
        this.context.turnOffAuthorisationSystem();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findVersionsOfVersionHistoryLoggedUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, item);
        Version version2 = this.versioningService.getVersion(this.context, item);
        this.context.turnOffAuthorisationSystem();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{VersionMatcher.matchEntry(version), VersionMatcher.matchEntry(version2)})));
    }

    @Test
    public void findVersionsOfVersionHistoryPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, item);
        Version v1 = this.versioningService.getVersion(this.context, item);
        Version v3 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test3").build();
        this.context.turnOffAuthorisationSystem();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(v3)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(v2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"}).param("page", new String[]{"2"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(v1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)3))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)3)));
    }

    @Test
    public void findVersionsOfVersionHistoryWithVersioningDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.enabled", (Object)false);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + this.versionHistory.getID() + "/versions"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findWorkspaceItemOfDraftVersionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory vh = this.versionHistoryService.findByItem(this.context, item);
        WorkspaceItem witem = this.workspaceItemService.findByItem(this.context, v2.getItem());
        this.context.turnOffAuthorisationSystem();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + vh.getID() + "/draftVersion"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Public test item", "2021-04-27", "ExtraEntry"))));
    }

    @Test
    public void findWorkspaceItemOfDraftVersionUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory vh = this.versionHistoryService.findByItem(this.context, item);
        this.context.turnOffAuthorisationSystem();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + vh.getID() + "/draftVersion"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findDraftOfVersionNotFoundTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        this.context.turnOffAuthorisationSystem();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647/draftVersion", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void findDraftOfVersionNoContentTest() throws Exception {
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").withSubmitterGroup(new EPerson[]{this.admin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").grantLicense().build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory vh = this.versionHistoryService.findByItem(this.context, version.getItem());
        this.context.turnOffAuthorisationSystem();
        AtomicReference idRef = new AtomicReference();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(version.getItem().getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + idRef.get()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + vh.getID() + "/draftVersion"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNoContent());
    }

    @Test
    public void findWorkflowItemOfDraftVersionAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").withWorkflowGroup(1, new EPerson[]{this.admin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        XmlWorkflowItem witem = WorkflowItemBuilder.createWorkflowItem((Context)this.context, (Collection)col).withTitle("Workflow Item 1").withIssueDate("2017-10-17").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version version = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        version.setItem(witem.getItem());
        VersionHistory vh = this.versionHistoryService.findByItem(this.context, version.getItem());
        this.context.turnOffAuthorisationSystem();
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + vh.getID() + "/draftVersion"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkflowItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Workflow Item 1", "2017-10-17", "ExtraEntry"))));
    }

    @Test
    public void findWorkspaceItemOfDraftVersionLoggedUserTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-04-27").withAuthor("Doe, John").withSubject("ExtraEntry").build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory vh = this.versionHistoryService.findByItem(this.context, item);
        WorkspaceItem witem = this.workspaceItemService.findByItem(this.context, v2.getItem());
        this.context.turnOffAuthorisationSystem();
        String ePersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(ePersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + vh.getID() + "/draftVersion"), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is((Matcher)WorkspaceItemMatcher.matchItemWithTitleAndDateIssuedAndSubject(witem, "Public test item", "2021-04-27", "ExtraEntry"))));
    }

    @Test
    public void findDraftVersionWithVersioningDisabledTest() throws Exception {
        this.configurationService.setProperty("versioning.enabled", (Object)false);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647/draftVersion", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647/draftVersion", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/versioning/versionhistories/2147483647/draftVersion", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findVersionsOfVersionHistoryCheckPaginationAfterDeletingOfVersionTest() throws Exception {
        this.configurationService.setProperty("webui.submit.upload.required", (Object)false);
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection test").withSubmitterGroup(new EPerson[]{this.admin}).build();
        Item item = ItemBuilder.createItem((Context)this.context, (Collection)col).withTitle("Public test item").withIssueDate("2021-03-20").withAuthor("Doe, John").withSubject("ExtraEntry").grantLicense().build();
        Version v2 = VersionBuilder.createVersion((Context)this.context, (Item)item, (String)"test").build();
        VersionHistory versionHistory = this.versionHistoryService.findByItem(this.context, item);
        Item lastVersionItem = v2.getItem();
        Version v1 = this.versioningService.getVersion(this.context, item);
        this.context.restoreAuthSystemState();
        AtomicReference idRef = new AtomicReference();
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        Integer versionID = v2.getID();
        Item versionItem = v2.getItem();
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)false)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/submission/workspaceitems/search/item", (Object[])new Object[0]).param("uuid", new String[]{String.valueOf(lastVersionItem.getID())})).andExpect(MockMvcResultMatchers.status().isOk()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"http://localhost/api/workflow/workflowitems", (Object[])new Object[0]).content("/api/submission/workspaceitems/" + idRef.get()).contentType(this.textUriContentType)).andExpect(MockMvcResultMatchers.status().isCreated());
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/items/" + lastVersionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.inArchive", (Matcher)Matchers.is((Object)true)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versions/" + versionID), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(VersionMatcher.matchEntry(v2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.versionhistory.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/versionhistory"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.item.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID() + "/item"))}))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)("api/versioning/versions/" + v2.getID()))})));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(v2)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)2))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)2)));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.delete((String)("/api/core/items/" + versionItem.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().is(204));
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/versioning/versionhistories/" + versionHistory.getID() + "/versions"), (Object[])new Object[0]).param("size", new String[]{"1"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.versions", (Matcher)Matchers.contains(VersionMatcher.matchEntry(v1)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.size", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.number", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)1)));
    }
}

