/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.dspace.app.rest.authorization.Authorization;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureService;
import org.dspace.app.rest.converter.BitstreamConverter;
import org.dspace.app.rest.converter.CollectionConverter;
import org.dspace.app.rest.converter.ItemConverter;
import org.dspace.app.rest.matcher.AuthorizationMatcher;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.RestAddressableModel;
import org.dspace.app.rest.projection.DefaultProjection;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.BundleBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.ResourcePolicyBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CanManageMappingsFeatureIT
extends AbstractControllerIntegrationTest {
    @Autowired
    private Utils utils;
    @Autowired
    private CollectionConverter collectionConverter;
    @Autowired
    private BitstreamConverter bitstreamConverter;
    @Autowired
    private ItemConverter itemConverter;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private AuthorizationFeatureService authorizationFeatureService;
    private EPerson userA;
    private Community communityA;
    private Collection collectionA;
    private Collection collectionB;
    private CollectionRest collectionARest;
    private Item itemA;
    private Bitstream bitstreamA;
    private BitstreamRest bitstreamARest;
    private Bundle bundleA;
    private AuthorizationFeature canManageMappingsFeature;
    final String feature = "canManageMappings";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.userA = EPersonBuilder.createEPerson((Context)this.context).withEmail("userEmail@test.com").withPassword(this.password).build();
        this.communityA = CommunityBuilder.createCommunity((Context)this.context).withName("communityA").build();
        this.collectionA = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("collectionA").build();
        this.collectionB = CollectionBuilder.createCollection((Context)this.context, (Community)this.communityA).withName("collectionB").build();
        this.itemA = ItemBuilder.createItem((Context)this.context, (Collection)this.collectionA).withTitle("itemA").build();
        this.bundleA = BundleBuilder.createBundle((Context)this.context, (Item)this.itemA).withName("ORIGINAL").build();
        String bitstreamContent = "Dummy content";
        try (InputStream is = IOUtils.toInputStream((String)bitstreamContent, (String)"UTF-8");){
            this.bitstreamA = BitstreamBuilder.createBitstream((Context)this.context, (Bundle)this.bundleA, (InputStream)is).withName("bistreamA").build();
        }
        this.canManageMappingsFeature = this.authorizationFeatureService.find("canManageMappings");
        this.context.restoreAuthSystemState();
        this.collectionARest = this.collectionConverter.convert(this.collectionA, Projection.DEFAULT);
        this.bitstreamARest = this.bitstreamConverter.convert(this.bitstreamA, Projection.DEFAULT);
    }

    @Test
    public void adminCollectionAdminSuccess() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappings"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void epersonCollectionNotFound() throws Exception {
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappings"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void addWriteEpersonCollectionSuccess() throws Exception {
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.collectionA).withAction(3).build();
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.collectionA).withAction(1).build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappings"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void adminEpersonCollectionSuccess() throws Exception {
        ResourcePolicyBuilder.createResourcePolicy((Context)this.context, (EPerson)this.eperson, null).withDspaceObject((DSpaceObject)this.collectionA).withAction(11).build();
        String epersonToken = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(epersonToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappings"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).exists());
    }

    @Test
    public void anonymousCollectionNotFound() throws Exception {
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappings"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.collectionARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void adminBitstreamNotFound() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/authz/authorizations/search/object", (Object[])new Object[0]).param("embed", new String[]{"feature"}).param("feature", new String[]{"canManageMappings"}).param("uri", new String[]{this.utils.linkToSingleResource((RestAddressableModel)this.bitstreamARest, "self").getHref()})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalElements", (Matcher)Matchers.is((Object)0))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded", (Object[])new Object[0]).doesNotExist());
    }

    @Test
    public void canManageMappingsWithUserThatCanManageTwoCollectionsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collectionA, 3, this.userA);
        this.authorizeService.addPolicy(this.context, (DSpaceObject)this.collectionB, 3, this.userA);
        this.context.restoreAuthSystemState();
        ItemRest itemRestA = this.itemConverter.convert(this.itemA, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenAUser = this.getAuthToken(this.userA.getEmail(), this.password);
        String tokenEPerson = this.getAuthToken(this.eperson.getEmail(), this.password);
        Authorization admin2ItemA = new Authorization(this.admin, this.canManageMappingsFeature, (BaseObjectRest)itemRestA);
        Authorization userA2ItemA = new Authorization(this.userA, this.canManageMappingsFeature, (BaseObjectRest)itemRestA);
        Authorization eperson2ItemA = new Authorization(this.eperson, this.canManageMappingsFeature, (BaseObjectRest)itemRestA);
        Authorization anonymous2ItemA = new Authorization(null, this.canManageMappingsFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2ItemA))));
        this.getClient(tokenAUser).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userA2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenEPerson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + eperson2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + anonymous2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canManageMappingsOnlyAdminHasAccessTest() throws Exception {
        ItemRest itemRestA = this.itemConverter.convert(this.itemA, DefaultProjection.DEFAULT);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        String tokenAUser = this.getAuthToken(this.userA.getEmail(), this.password);
        Authorization admin2ItemA = new Authorization(this.admin, this.canManageMappingsFeature, (BaseObjectRest)itemRestA);
        Authorization userA2ItemA = new Authorization(this.userA, this.canManageMappingsFeature, (BaseObjectRest)itemRestA);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + admin2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(admin2ItemA))));
        this.getClient(tokenAUser).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userA2ItemA.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void canManageMappingsCommunityAdminAndCollectionsAdminTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson userComAdmin = EPersonBuilder.createEPerson((Context)this.context).withEmail("userComAdminEmail@test.com").withPassword(this.password).build();
        EPerson user1 = EPersonBuilder.createEPerson((Context)this.context).withEmail("user1Email@test.com").withPassword(this.password).build();
        EPerson user2 = EPersonBuilder.createEPerson((Context)this.context).withEmail("user2Email@test.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        Community subCommunity1 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("SubCommunity 1").withAdminGroup(new EPerson[]{userComAdmin}).build();
        Community subCommunity2 = CommunityBuilder.createSubCommunity((Context)this.context, (Community)this.parentCommunity).withName("SubCommunity 2").build();
        Collection col1 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity1).withName("Collection 1").withAdminGroup(new EPerson[]{user1}).build();
        Collection col2 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity1).withName("Collection 2").withAdminGroup(new EPerson[]{user1, user2}).build();
        Collection col3 = CollectionBuilder.createCollection((Context)this.context, (Community)subCommunity2).withName("Collection 3").build();
        Item item1 = ItemBuilder.createItem((Context)this.context, (Collection)col1).withTitle("Test Item 1").build();
        Item item2 = ItemBuilder.createItem((Context)this.context, (Collection)col2).withTitle("Test Item 2").build();
        Item item3 = ItemBuilder.createItem((Context)this.context, (Collection)col3).withTitle("Test Item 3").build();
        this.context.restoreAuthSystemState();
        ItemRest itemRest1 = this.itemConverter.convert(item1, DefaultProjection.DEFAULT);
        ItemRest itemRest2 = this.itemConverter.convert(item2, DefaultProjection.DEFAULT);
        ItemRest itemRest3 = this.itemConverter.convert(item3, DefaultProjection.DEFAULT);
        CollectionRest colRest1 = this.collectionConverter.convert(col1, DefaultProjection.DEFAULT);
        CollectionRest colRest2 = this.collectionConverter.convert(col2, DefaultProjection.DEFAULT);
        CollectionRest colRest3 = this.collectionConverter.convert(col3, DefaultProjection.DEFAULT);
        String tokenUserComAdmin = this.getAuthToken(userComAdmin.getEmail(), this.password);
        String tokenUser1 = this.getAuthToken(user1.getEmail(), this.password);
        String tokenUser2 = this.getAuthToken(user2.getEmail(), this.password);
        Authorization userComAdminItem1 = new Authorization(userComAdmin, this.canManageMappingsFeature, (BaseObjectRest)itemRest1);
        Authorization userComAdminItem2 = new Authorization(userComAdmin, this.canManageMappingsFeature, (BaseObjectRest)itemRest2);
        Authorization userComAdminItem3 = new Authorization(userComAdmin, this.canManageMappingsFeature, (BaseObjectRest)itemRest3);
        Authorization userComAdminCol1 = new Authorization(userComAdmin, this.canManageMappingsFeature, (BaseObjectRest)colRest1);
        Authorization userComAdminCol2 = new Authorization(userComAdmin, this.canManageMappingsFeature, (BaseObjectRest)colRest2);
        Authorization userComAdminCol3 = new Authorization(userComAdmin, this.canManageMappingsFeature, (BaseObjectRest)colRest3);
        Authorization user1Item1 = new Authorization(user1, this.canManageMappingsFeature, (BaseObjectRest)itemRest1);
        Authorization user1Item2 = new Authorization(user1, this.canManageMappingsFeature, (BaseObjectRest)itemRest2);
        Authorization user1Item3 = new Authorization(user1, this.canManageMappingsFeature, (BaseObjectRest)itemRest3);
        Authorization user1Col1 = new Authorization(user1, this.canManageMappingsFeature, (BaseObjectRest)colRest1);
        Authorization user1Col2 = new Authorization(user1, this.canManageMappingsFeature, (BaseObjectRest)colRest2);
        Authorization user1Col3 = new Authorization(user1, this.canManageMappingsFeature, (BaseObjectRest)colRest3);
        Authorization user2Item1 = new Authorization(user2, this.canManageMappingsFeature, (BaseObjectRest)itemRest1);
        Authorization user2Item2 = new Authorization(user2, this.canManageMappingsFeature, (BaseObjectRest)itemRest2);
        Authorization user2Item3 = new Authorization(user2, this.canManageMappingsFeature, (BaseObjectRest)itemRest3);
        Authorization user2Col1 = new Authorization(user2, this.canManageMappingsFeature, (BaseObjectRest)colRest1);
        Authorization user2Col2 = new Authorization(user2, this.canManageMappingsFeature, (BaseObjectRest)colRest2);
        Authorization user2Col3 = new Authorization(user2, this.canManageMappingsFeature, (BaseObjectRest)colRest3);
        this.getClient(tokenUserComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userComAdminItem1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(userComAdminItem1))));
        this.getClient(tokenUserComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userComAdminItem2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(userComAdminItem2))));
        this.getClient(tokenUserComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userComAdminCol1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(userComAdminCol1))));
        this.getClient(tokenUserComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userComAdminCol2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(userComAdminCol2))));
        this.getClient(tokenUserComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userComAdminItem3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUserComAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + userComAdminCol3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user1Item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(user1Item1))));
        this.getClient(tokenUser1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user1Item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(user1Item2))));
        this.getClient(tokenUser1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user1Col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(user1Col1))));
        this.getClient(tokenUser1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user1Col2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(user1Col2))));
        this.getClient(tokenUser1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user1Item3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser1).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user1Col3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user2Col2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(AuthorizationMatcher.matchAuthorization(user2Col2))));
        this.getClient(tokenUser2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user2Item1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user2Item2.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user2Col1.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user2Item3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
        this.getClient(tokenUser2).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/authz/authorizations/" + user2Col3.getID()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }
}

