/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.matcher;

import com.jayway.jsonpath.matchers.JsonPathMatchers;
import org.dspace.content.EntityType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class EntityTypeMatcher {
    private EntityTypeMatcher() {
    }

    public static Matcher<? super Object> matchEntityTypeEntry(EntityType entityType) {
        return EntityTypeMatcher.matchEntityTypeExplicitValuesEntry(entityType.getID(), entityType.getLabel());
    }

    public static Matcher<? super Object> matchEntityTypeEntryForLabel(String label) {
        return EntityTypeMatcher.matchEntityTypeExplicitValuesEntry(0, label);
    }

    private static Matcher<? super Object> matchId(int id) {
        return id == 0 ? Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.not((Matcher)Matchers.empty()))}) : Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)id))});
    }

    private static Matcher<? super Object> matchSelfLink(int id) {
        return id == 0 ? Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)"/api/core/entitytypes/"))}) : Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/core/entitytypes/" + id)))});
    }

    public static Matcher<? super Object> matchEntityTypeExplicitValuesEntry(int id, String label) {
        return Matchers.allOf(EntityTypeMatcher.matchId(id), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.label", (Matcher)Matchers.is((Object)label)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"entitytype")), EntityTypeMatcher.matchSelfLink(id));
    }
}

