/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import java.util.ArrayList;
import java.util.Map;
import org.dspace.app.rest.model.hateoas.EmbeddedPageHeader;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class EmbeddedPageHeaderTest {
    @Test
    public void testGetPageInfoOnePage() throws Exception {
        PageRequest pageRequest = PageRequest.of((int)1, (int)20);
        PageImpl page = new PageImpl(new ArrayList(), (Pageable)pageRequest, 20L);
        EmbeddedPageHeader embeddedPageHeader = new EmbeddedPageHeader("http://mydspace/", (Page)page, true);
        Map pageInfo = embeddedPageHeader.getPageInfo();
        Assert.assertEquals((long)1L, (long)((Long)pageInfo.get("number")).intValue());
        Assert.assertEquals((long)20L, (long)((Long)pageInfo.get("size")).intValue());
        Assert.assertEquals((long)1L, (long)((Long)pageInfo.get("totalPages")).intValue());
        Assert.assertEquals((long)20L, (long)((Long)pageInfo.get("totalElements")).intValue());
    }

    @Test
    public void testGetPageInfoTotalUnknown() throws Exception {
        PageRequest pageRequest = PageRequest.of((int)1, (int)20);
        PageImpl page = new PageImpl(new ArrayList(), (Pageable)pageRequest, 20L);
        EmbeddedPageHeader embeddedPageHeader = new EmbeddedPageHeader("http://mydspace/", (Page)page, false);
        Map pageInfo = embeddedPageHeader.getPageInfo();
        Assert.assertEquals((long)1L, (long)((Long)pageInfo.get("number")).intValue());
        Assert.assertEquals((long)20L, (long)((Long)pageInfo.get("size")).intValue());
        Assert.assertFalse((boolean)pageInfo.containsKey("totalPages"));
        Assert.assertFalse((boolean)pageInfo.containsKey("totalElements"));
    }

    @Test
    public void testGetPageInfoMultiplePages() throws Exception {
        PageRequest pageRequest = PageRequest.of((int)1, (int)10);
        PageImpl page = new PageImpl(new ArrayList(), (Pageable)pageRequest, 50L);
        EmbeddedPageHeader embeddedPageHeader = new EmbeddedPageHeader("http://mydspace/", (Page)page, true);
        Map pageInfo = embeddedPageHeader.getPageInfo();
        Assert.assertEquals((long)1L, (long)((Long)pageInfo.get("number")).intValue());
        Assert.assertEquals((long)10L, (long)((Long)pageInfo.get("size")).intValue());
        Assert.assertEquals((long)5L, (long)((Long)pageInfo.get("totalPages")).intValue());
        Assert.assertEquals((long)50L, (long)((Long)pageInfo.get("totalElements")).intValue());
    }

    @Test
    public void testGetLinksOnFirstPage() throws Exception {
        String dspaceURL = "http://mydspace/server";
        PageRequest pageRequest = PageRequest.of((int)0, (int)10);
        PageImpl page = new PageImpl(new ArrayList(), (Pageable)pageRequest, 50L);
        EmbeddedPageHeader embeddedPageHeader = new EmbeddedPageHeader(dspaceURL, (Page)page, true);
        Map links = embeddedPageHeader.getLinks();
        Assert.assertEquals((Object)(dspaceURL + "?size=10"), (Object)((EmbeddedPageHeader.Href)links.get("self")).getHref());
        Assert.assertFalse((boolean)links.containsKey("first"));
        Assert.assertFalse((boolean)links.containsKey("prev"));
        Assert.assertEquals((Object)(dspaceURL + "?page=1&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("next")).getHref());
        Assert.assertEquals((Object)(dspaceURL + "?page=4&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("last")).getHref());
    }

    @Test
    public void testGetLinksOnSecondPage() throws Exception {
        String dspaceBaseURL = "http://mydspace/server";
        String dspaceURL = dspaceBaseURL + "?page=1&size=10";
        PageRequest pageRequest = PageRequest.of((int)1, (int)10);
        PageImpl page = new PageImpl(new ArrayList(), (Pageable)pageRequest, 50L);
        EmbeddedPageHeader embeddedPageHeader = new EmbeddedPageHeader(dspaceURL, (Page)page, true);
        Map links = embeddedPageHeader.getLinks();
        Assert.assertEquals((Object)dspaceURL, (Object)((EmbeddedPageHeader.Href)links.get("self")).getHref());
        Assert.assertEquals((Object)(dspaceBaseURL + "?page=0&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("first")).getHref());
        Assert.assertEquals((Object)(dspaceBaseURL + "?page=0&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("prev")).getHref());
        Assert.assertEquals((Object)(dspaceBaseURL + "?page=2&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("next")).getHref());
        Assert.assertEquals((Object)(dspaceBaseURL + "?page=4&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("last")).getHref());
    }

    @Test
    public void testGetLinksOnLastPage() throws Exception {
        String dspaceBaseURL = "http://mydspace/server";
        String dspaceURL = dspaceBaseURL + "?page=4&size=10";
        PageRequest pageRequest = PageRequest.of((int)4, (int)10);
        PageImpl page = new PageImpl(new ArrayList(), (Pageable)pageRequest, 50L);
        EmbeddedPageHeader embeddedPageHeader = new EmbeddedPageHeader(dspaceURL, (Page)page, true);
        Map links = embeddedPageHeader.getLinks();
        Assert.assertEquals((Object)dspaceURL, (Object)((EmbeddedPageHeader.Href)links.get("self")).getHref());
        Assert.assertEquals((Object)(dspaceBaseURL + "?page=0&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("first")).getHref());
        Assert.assertEquals((Object)(dspaceBaseURL + "?page=3&size=10"), (Object)((EmbeddedPageHeader.Href)links.get("prev")).getHref());
        Assert.assertFalse((boolean)links.containsKey("next"));
        Assert.assertFalse((boolean)links.containsKey("last"));
    }
}

