/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.orcid;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.matchers.JsonPathMatchers;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.dspace.app.matcher.LambdaMatcher;
import org.dspace.app.rest.matcher.OrcidHistoryMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.OrcidHistoryBuilder;
import org.dspace.builder.OrcidQueueBuilder;
import org.dspace.builder.OrcidTokenBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.RelationshipType;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.client.OrcidClient;
import org.dspace.orcid.client.OrcidResponse;
import org.dspace.orcid.exception.OrcidClientException;
import org.dspace.orcid.service.impl.OrcidHistoryServiceImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.orcid.jaxb.model.common.Iso3166Country;
import org.orcid.jaxb.model.v3.release.common.FuzzyDate;
import org.orcid.jaxb.model.v3.release.record.Address;
import org.orcid.jaxb.model.v3.release.record.Funding;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class OrcidHistoryRestRepositoryIT
extends AbstractControllerIntegrationTest {
    private static final String ACCESS_TOKEN = "f5af9f51-07e6-4332-8f1a-c0c11c1e3728";
    private static final String ORCID = "0000-0002-1825-0097";
    private EPerson researcher;
    private Collection persons;
    private Collection publications;
    private Item profile;
    private Item publication;
    @Autowired
    private OrcidHistoryServiceImpl orcidHistoryService;
    private OrcidClient orcidClient;
    private OrcidClient orcidClientMock;

    @Before
    public void setup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.researcher = EPersonBuilder.createEPerson((Context)this.context).withNameInMetadata("Josiah", "Carberry").withEmail("josiah.Carberry@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).withName("Parent Community").build();
        this.persons = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Person").withName("Collection 1").build();
        this.publications = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Publication").withName("Collection 2").build();
        this.profile = ItemBuilder.createItem((Context)this.context, (Collection)this.persons).withPersonIdentifierFirstName("Josiah").withPersonIdentifierLastName("Carberry").withPersonCountry("IT").withDspaceObjectOwner(this.researcher.getFullName(), this.researcher.getID().toString()).withOrcidIdentifier(ORCID).build();
        OrcidTokenBuilder.create((Context)this.context, (EPerson)this.researcher, (String)ACCESS_TOKEN).withProfileItem(this.profile).build();
        this.publication = ItemBuilder.createItem((Context)this.context, (Collection)this.publications).withAuthor("Josiah, Carberry").withTitle("A Methodology for the Emulation of Architecture").withIssueDate("2013-08-03").withType("Controlled Vocabulary for Resource Type Genres::text::book").withDoiIdentifier("10.1000/182").build();
        this.context.restoreAuthSystemState();
        this.orcidClientMock = (OrcidClient)Mockito.mock(OrcidClient.class);
        this.orcidClient = this.orcidHistoryService.getOrcidClient();
        this.orcidHistoryService.setOrcidClient(this.orcidClientMock);
    }

    @After
    public void after() {
        this.orcidHistoryService.setOrcidClient(this.orcidClient);
    }

    @Test
    public void findAllTest() throws Exception {
        String authToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidhistories", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isMethodNotAllowed());
    }

    @Test
    public void findOneTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidHistory orcidHistory = OrcidHistoryBuilder.createOrcidHistory((Context)this.context, (Item)this.profile, (Item)this.publication).withResponseMessage("<xml><work>...</work>").withPutCode("123456").withStatus(Integer.valueOf(201)).build();
        this.context.restoreAuthSystemState();
        String tokenResearcher = this.getAuthToken(this.researcher.getEmail(), this.password);
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenResearcher).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + orcidHistory.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidHistoryMatcher.matchOrcidHistory(orcidHistory, 201, "123456", "<xml><work>...</work>")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/orcidhistories/" + orcidHistory.getID()))));
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + orcidHistory.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.is(OrcidHistoryMatcher.matchOrcidHistory(orcidHistory, 201, "123456", "<xml><work>...</work>")))).andExpect(MockMvcResultMatchers.jsonPath((String)"$._links.self.href", (Matcher)Matchers.containsString((String)("/api/eperson/orcidhistories/" + orcidHistory.getID()))));
    }

    @Test
    public void findOneForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidHistory orcidHistory = OrcidHistoryBuilder.createOrcidHistory((Context)this.context, (Item)this.profile, (Item)this.publication).withResponseMessage("<xml><work>...</work>").withPutCode("123456").withStatus(Integer.valueOf(201)).build();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + orcidHistory.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void findOneisUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidHistory orcidHistory = OrcidHistoryBuilder.createOrcidHistory((Context)this.context, (Item)this.profile, (Item)this.publication).withResponseMessage("<xml><work>...</work>").withPutCode("123456").withStatus(Integer.valueOf(201)).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + orcidHistory.getID().toString()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findOneNotFoundTest() throws Exception {
        String tokenAdmin = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(tokenAdmin).perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/api/eperson/orcidhistories/2147483647", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void createForbiddenTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).build();
        this.context.restoreAuthSystemState();
        String tokenEperson = this.getAuthToken(this.eperson.getEmail(), this.password);
        this.getClient(tokenEperson).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void createUnauthorizedTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).build();
        this.context.restoreAuthSystemState();
        this.getClient().perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationInsert() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).withDescription("A Methodology for the Emulation of Architecture").withOperation(OrcidOperation.INSERT).withRecordType("Publication").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.publication.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)201)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.is((Object)"12345")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), captor.capture());
        Object sentObject = captor.getValue();
        MatcherAssert.assertThat((Object)sentObject, (Matcher)Matchers.instanceOf(Work.class));
        Work work = (Work)sentObject;
        MatcherAssert.assertThat((Object)work.getPutCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getWorkTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"A Methodology for the Emulation of Architecture"));
        MatcherAssert.assertThat((Object)work.getPublicationDate(), (Matcher)LambdaMatcher.matches(this.date("2013", "08", "03")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationInsertWithOrcidClientException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).withDescription("A Methodology for the Emulation of Architecture").withOperation(OrcidOperation.INSERT).withRecordType("Publication").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenThrow(new Throwable[]{new OrcidClientException(400, "Invalid resource")});
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.publication.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.responseMessage", (Matcher)Matchers.is((Object)"Invalid resource")), JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)400)), JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory"))})));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.notNullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any(Work.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationInsertWithGenericException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).withDescription("A Methodology for the Emulation of Architecture").withOperation(OrcidOperation.INSERT).withRecordType("Publication").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("GENERIC ERROR")});
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.publication.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.responseMessage", (Matcher)Matchers.is((Object)"GENERIC ERROR")), JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)500)), JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory"))})));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.notNullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any(Work.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationUpdate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).withDescription("A Methodology for the Emulation of Architecture").withOperation(OrcidOperation.UPDATE).withRecordType("Publication").withPutCode("12345").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.update((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"12345"))).thenReturn((Object)this.updatedResponse("12345"));
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.publication.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)200)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.is((Object)"12345")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).update((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), captor.capture(), (String)ArgumentMatchers.eq((Object)"12345"));
        Object sentObject = captor.getValue();
        MatcherAssert.assertThat((Object)sentObject, (Matcher)Matchers.instanceOf(Work.class));
        Work work = (Work)sentObject;
        MatcherAssert.assertThat((Object)work.getPutCode(), (Matcher)Matchers.is((Object)12345L));
        MatcherAssert.assertThat((Object)work.getWorkTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"A Methodology for the Emulation of Architecture"));
        MatcherAssert.assertThat((Object)work.getPublicationDate(), (Matcher)LambdaMatcher.matches(this.date("2013", "08", "03")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationUpdateWithForceAddition() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.publication).withDescription("A Methodology for the Emulation of Architecture").withOperation(OrcidOperation.UPDATE).withRecordType("Publication").withPutCode("12345").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID()).param("forceAddition", new String[]{"true"})).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.publication.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)201)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.is((Object)"12345")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), captor.capture());
        Object sentObject = captor.getValue();
        MatcherAssert.assertThat((Object)sentObject, (Matcher)Matchers.instanceOf(Work.class));
        Work work = (Work)sentObject;
        MatcherAssert.assertThat((Object)work.getPutCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)work.getWorkTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"A Methodology for the Emulation of Architecture"));
        MatcherAssert.assertThat((Object)work.getPublicationDate(), (Matcher)LambdaMatcher.matches(this.date("2013", "08", "03")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationDeletion() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (String)"Description", (String)"Publication", (String)"12345").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/work")).thenReturn((Object)this.deletedResponse());
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)204)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/work");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForPublicationDeletionWithNotFound() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (String)"Description", (String)"Publication", (String)"12345").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/work")).thenReturn((Object)this.notFoundResponse());
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)204)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/work");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForProfileDataInsert() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.profile).withDescription("IT").withOperation(OrcidOperation.INSERT).withRecordType("COUNTRY").withMetadata("person.country::IT").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)201)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.is((Object)"12345")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), captor.capture());
        Object sentObject = captor.getValue();
        MatcherAssert.assertThat((Object)sentObject, (Matcher)Matchers.instanceOf(Address.class));
        Address address = (Address)sentObject;
        MatcherAssert.assertThat((Object)address.getPutCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)address.getCountry().getValue(), (Matcher)Matchers.is((Object)Iso3166Country.IT));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForProfileDataDeletion() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)this.profile).withDescription("IT").withOperation(OrcidOperation.DELETE).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("12345").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/address")).thenReturn((Object)this.deletedResponse());
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)204)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/address");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForFundingInsert() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection fundings = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withName("Collection 3").build();
        Collection orgUnits = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("OrgUnit").withName("Collection 4").build();
        Item orgUnit = ItemBuilder.createItem((Context)this.context, (Collection)orgUnits).withOrgUnitLegalName("4Science").withOrgUnitCountry("IT").withOrgUnitLocality("Milan").withOrgUnitCrossrefIdentifier("12345").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)fundings).withTitle("Test funding").withProjectStartDate("2013-08-03").withIdentifier("888-666-444").build();
        EntityType fundingType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType orgUnitType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)orgUnitType, (EntityType)fundingType, (String)"isOrgUnitOfProject", (String)"isProjectOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)orgUnit, (Item)funding, (RelationshipType)isAuthorOfPublication).build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)funding).withDescription("Test funding").withOperation(OrcidOperation.INSERT).withRecordType("Project").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)funding.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)201)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.is((Object)"12345")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), captor.capture());
        Object sentObject = captor.getValue();
        MatcherAssert.assertThat((Object)sentObject, (Matcher)Matchers.instanceOf(Funding.class));
        Funding sentFunding = (Funding)sentObject;
        MatcherAssert.assertThat((Object)sentFunding.getPutCode(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)sentFunding.getTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"Test funding"));
        MatcherAssert.assertThat((Object)sentFunding.getStartDate(), (Matcher)LambdaMatcher.matches(this.date("2013", "08", "03")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForFundingInsertWithOrcidClientException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection fundings = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withName("Collection 3").build();
        Collection orgUnits = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("OrgUnit").withName("Collection 4").build();
        Item orgUnit = ItemBuilder.createItem((Context)this.context, (Collection)orgUnits).withOrgUnitLegalName("4Science").withOrgUnitCountry("IT").withOrgUnitLocality("Milan").withOrgUnitCrossrefIdentifier("12345").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)fundings).withTitle("Test funding").withProjectStartDate("2013-08-03").withIdentifier("888-666-444").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)funding).withDescription("Test funding").withOperation(OrcidOperation.INSERT).withRecordType("Project").build();
        EntityType fundingType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType orgUnitType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)orgUnitType, (EntityType)fundingType, (String)"isOrgUnitOfProject", (String)"isProjectOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)orgUnit, (Item)funding, (RelationshipType)isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenThrow(new Throwable[]{new OrcidClientException(400, "Invalid resource")});
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)funding.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.responseMessage", (Matcher)Matchers.is((Object)"Invalid resource")), JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)400)), JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory"))})));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.notNullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any(Funding.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForFundingInsertWithGenericException() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection fundings = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withName("Collection 3").build();
        Collection orgUnits = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("OrgUnit").withName("Collection 4").build();
        Item orgUnit = ItemBuilder.createItem((Context)this.context, (Collection)orgUnits).withOrgUnitLegalName("4Science").withOrgUnitCountry("IT").withOrgUnitLocality("Milan").withOrgUnitCrossrefIdentifier("12345").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)fundings).withTitle("Test funding").withProjectStartDate("2013-08-03").withIdentifier("888-666-444").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)funding).withDescription("Test funding").withOperation(OrcidOperation.INSERT).withRecordType("Project").build();
        EntityType fundingType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType orgUnitType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)orgUnitType, (EntityType)fundingType, (String)"isOrgUnitOfProject", (String)"isProjectOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)orgUnit, (Item)funding, (RelationshipType)isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("GENERIC ERROR")});
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)funding.getID().toString())), JsonPathMatchers.hasJsonPath((String)"$.responseMessage", (Matcher)Matchers.is((Object)"GENERIC ERROR")), JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)500)), JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory"))})));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.notNullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any(Funding.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForFundingUpdate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection fundings = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withName("Collection 3").build();
        Collection orgUnits = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("OrgUnit").withName("Collection 4").build();
        Item orgUnit = ItemBuilder.createItem((Context)this.context, (Collection)orgUnits).withOrgUnitLegalName("4Science").withOrgUnitCountry("IT").withOrgUnitLocality("Milan").withOrgUnitCrossrefIdentifier("12345").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)fundings).withTitle("Test funding").withProjectStartDate("2013-08-03").withIdentifier("888-666-444").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)funding).withDescription("Test funding").withOperation(OrcidOperation.UPDATE).withRecordType("Project").withPutCode("12345").build();
        EntityType fundingType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"Project").build();
        EntityType orgUnitType = EntityTypeBuilder.createEntityTypeBuilder((Context)this.context, (String)"OrgUnit").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder((Context)this.context, (EntityType)orgUnitType, (EntityType)fundingType, (String)"isOrgUnitOfProject", (String)"isProjectOfOrgUnit", (Integer)0, null, (Integer)0, null).build();
        RelationshipBuilder.createRelationshipBuilder((Context)this.context, (Item)orgUnit, (Item)funding, (RelationshipType)isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.update((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"12345"))).thenReturn((Object)this.updatedResponse("12345"));
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.is((Object)funding.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)200)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.is((Object)"12345")), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).update((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), captor.capture(), (String)ArgumentMatchers.eq((Object)"12345"));
        Object sentObject = captor.getValue();
        MatcherAssert.assertThat((Object)sentObject, (Matcher)Matchers.instanceOf(Funding.class));
        Funding sentFunding = (Funding)sentObject;
        MatcherAssert.assertThat((Object)sentFunding.getPutCode(), (Matcher)Matchers.is((Object)12345L));
        MatcherAssert.assertThat((Object)sentFunding.getTitle().getTitle().getContent(), (Matcher)Matchers.is((Object)"Test funding"));
        MatcherAssert.assertThat((Object)sentFunding.getStartDate(), (Matcher)LambdaMatcher.matches(this.date("2013", "08", "03")));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationForFundingDeletion() throws Exception {
        this.context.turnOffAuthorisationSystem();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (String)"Description", (String)"Project", (String)"12345").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/funding")).thenReturn((Object)this.deletedResponse());
        String authToken = this.getAuthToken(this.researcher.getEmail(), this.password);
        AtomicReference idRef = new AtomicReference();
        try {
            this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isCreated()).andDo(result -> idRef.set((Integer)JsonPath.read((String)result.getResponse().getContentAsString(), (String)"$.id", (Predicate[])new Predicate[0])));
            this.getClient(authToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/eperson/orcidhistories/" + idRef.get()), (Object[])new Object[0])).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$", (Matcher)Matchers.allOf((Matcher)JsonPathMatchers.hasJsonPath((String)"$.id", (Matcher)Matchers.is((Object)((Integer)idRef.get()))), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.profileItemId", (Matcher)Matchers.is((Object)this.profile.getID().toString())), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.entityId", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.status", (Matcher)Matchers.is((Object)204)), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.putCode", (Matcher)Matchers.nullValue()), (Matcher)JsonPathMatchers.hasJsonPath((String)"$.type", (Matcher)Matchers.is((Object)"orcidhistory")))));
        }
        finally {
            OrcidHistoryBuilder.deleteOrcidHistory((Integer)((Integer)idRef.get()));
        }
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.nullValue());
        ((OrcidClient)Mockito.verify((Object)this.orcidClientMock)).deleteByPutCode(ACCESS_TOKEN, ORCID, "12345", "/funding");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    @Test
    public void testWithInvalidFunding() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection fundings = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withEntityType("Project").withName("Collection 3").build();
        Item funding = ItemBuilder.createItem((Context)this.context, (Collection)fundings).withTitle("Test funding").withProjectStartDate("2013-08-03").build();
        OrcidQueue orcidQueue = OrcidQueueBuilder.createOrcidQueue((Context)this.context, (Item)this.profile, (Item)funding).withDescription("Test funding").withOperation(OrcidOperation.INSERT).withRecordType("Project").build();
        this.context.restoreAuthSystemState();
        Mockito.when((Object)this.orcidClientMock.push((String)ArgumentMatchers.eq((Object)ACCESS_TOKEN), (String)ArgumentMatchers.eq((Object)ORCID), ArgumentMatchers.any())).thenReturn((Object)this.createdResponse("12345"));
        this.getClient(this.getAuthToken(this.researcher.getEmail(), this.password)).perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/eperson/orcidhistories", (Object[])new Object[0]).contentType(MediaType.parseMediaType((String)"text/uri-list")).content("/api/eperson/orcidqueues/" + orcidQueue.getID())).andExpect(MockMvcResultMatchers.status().isUnprocessableEntity());
        MatcherAssert.assertThat((Object)((OrcidQueue)this.context.reloadEntity((ReloadableEntity)orcidQueue)), (Matcher)Matchers.notNullValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.orcidClientMock});
    }

    private java.util.function.Predicate<? super FuzzyDate> date(String year, String month, String days) {
        return date -> date != null && year.equals(date.getYear().getValue()) && month.equals(date.getMonth().getValue()) && days.equals(date.getDay().getValue());
    }

    private OrcidResponse createdResponse(String putCode) {
        return new OrcidResponse(201, putCode, null);
    }

    private OrcidResponse notFoundResponse() {
        return new OrcidResponse(404, null, null);
    }

    private OrcidResponse updatedResponse(String putCode) {
        return new OrcidResponse(200, putCode, null);
    }

    private OrcidResponse deletedResponse() {
        return new OrcidResponse(204, null, null);
    }
}

