/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import org.dspace.app.rest.matcher.CollectionMatcher;
import org.dspace.app.rest.test.AbstractControllerIntegrationTest;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

public class CommunityCollectionLinkRepositoryIT
extends AbstractControllerIntegrationTest {
    Community parentCommunity;
    Collection collection1;
    Collection collection2;
    Collection collection3;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity((Context)this.context).build();
        this.collection1 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 1").build();
        this.collection2 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 2").build();
        this.collection3 = CollectionBuilder.createCollection((Context)this.context, (Community)this.parentCommunity).withName("Collection 3").build();
        this.context.commit();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void getCollections_sortTitleASC() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/collections"), (Object[])new Object[0]).param("sort", new String[]{"dc.title,ASC"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(this.collection1), CollectionMatcher.matchCollection(this.collection2), CollectionMatcher.matchCollection(this.collection3)})));
    }

    @Test
    public void getCollections_sortTitleDESC() throws Exception {
        String adminToken = this.getAuthToken(this.admin.getEmail(), this.password);
        this.getClient(adminToken).perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/core/communities/" + this.parentCommunity.getID() + "/collections"), (Object[])new Object[0]).param("sort", new String[]{"dc.title,DESC"})).andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$._embedded.collections", (Matcher)Matchers.contains((Matcher[])new Matcher[]{CollectionMatcher.matchCollection(this.collection3), CollectionMatcher.matchCollection(this.collection2), CollectionMatcher.matchCollection(this.collection1)})));
    }
}

