/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.test;

import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.rest.Application;
import org.dspace.app.rest.test.LoggingTestExecutionListener;
import org.dspace.app.rest.utils.DSpaceConfigurationInitializer;
import org.dspace.app.rest.utils.DSpaceKernelInitializer;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={Application.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ContextConfiguration(initializers={DSpaceKernelInitializer.class, DSpaceConfigurationInitializer.class})
@TestPropertySource(locations={"classpath:application-test.properties"})
@TestExecutionListeners(listeners={LoggingTestExecutionListener.class}, mergeMode=TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS)
public class AbstractWebClientIntegrationTest
extends AbstractIntegrationTestWithDatabase {
    @LocalServerPort
    private int port;
    @Autowired
    private TestRestTemplate restTemplate;
    @Autowired
    protected ApplicationContext applicationContext;

    public TestRestTemplate getClient() {
        return this.restTemplate;
    }

    public String getURL(String path) {
        return "http://localhost:" + this.port + path;
    }

    public ResponseEntity<String> getResponseAsString(String path) {
        return this.getClient().getForEntity(this.getURL(path), String.class, new Object[0]);
    }

    public ResponseEntity<String> responseAsString(RequestEntity request) {
        return this.getClient().exchange(request, String.class);
    }

    public ResponseEntity<String> getResponseAsString(String path, String username, String password) {
        return this.getClient().withBasicAuth(username, password).getForEntity(this.getURL(path), String.class, new Object[0]);
    }

    public ResponseEntity<String> postResponseAsString(String path, String username, String password, HttpEntity requestEntity) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            return this.getClient().withBasicAuth(username, password).postForEntity(this.getURL(path), (Object)requestEntity, String.class, new Object[0]);
        }
        return this.getClient().postForEntity(this.getURL(path), (Object)requestEntity, String.class, new Object[0]);
    }
}

