/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.profile.service.ResearcherProfileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canClaimItem", description="Used to verify if the current user is able to claim this item as their profile. Only available if the current item is not already claimed.")
public class CanClaimItemFeature
implements AuthorizationFeature {
    public static final String NAME = "canClaimItem";
    private static final Logger LOG = LoggerFactory.getLogger(CanClaimItemFeature.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private ResearcherProfileService researcherProfileService;

    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (!(object instanceof ItemRest) || context.getCurrentUser() == null) {
            return false;
        }
        String id = ((ItemRest)object).getId();
        Item item = (Item)this.itemService.find(context, UUID.fromString(id));
        return this.researcherProfileService.hasProfileType(item) && this.hasNotOwner(item) && this.hasNotAlreadyAProfile(context) && this.haveSameEmail(item, context.getCurrentUser());
    }

    private boolean hasNotAlreadyAProfile(Context context) {
        try {
            return this.researcherProfileService.findById(context, context.getCurrentUser().getID()) == null;
        }
        catch (SQLException | AuthorizeException e) {
            LOG.warn("Error while checking if eperson has a ResearcherProfileAssociated: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private boolean hasNotOwner(Item item) {
        return StringUtils.isBlank((CharSequence)this.itemService.getMetadata((DSpaceObject)item, "dspace.object.owner"));
    }

    private boolean haveSameEmail(Item item, EPerson currentUser) {
        return this.itemService.getMetadataByMetadataString((DSpaceObject)item, "person.email").stream().map(MetadataValue::getValue).filter(StringUtils::isNotBlank).anyMatch(email -> email.equalsIgnoreCase(currentUser.getEmail()));
    }

    public String[] getSupportedTypes() {
        return new String[]{"core.item"};
    }
}

