/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.NotSupportedException;
import org.atteo.evo.inflector.English;
import org.dspace.app.rest.DiscoverableEndpointsService;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.LinkNotFoundException;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.DSpaceObjectRest;
import org.dspace.app.rest.model.IdentifierRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.handler.service.UriListHandlerService;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.TrueFilter;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pid"})
@Component(value="pid.identifier")
public class IdentifierRestRepository
extends DSpaceRestRepository<IdentifierRest, String>
implements InitializingBean {
    @Autowired
    private DiscoverableEndpointsService discoverableEndpointsService;
    @Autowired
    private UriListHandlerService uriListHandlerService;
    @Autowired
    private DOIService doiService;
    @Autowired
    private HandleService handleService;
    @Autowired
    private ItemService itemService;
    public static final String CATEGORY = "pid";
    public static final String NAME = "identifier";

    public void afterPropertiesSet() throws Exception {
        this.discoverableEndpointsService.register((Object)this, Arrays.asList(Link.of((UriTemplate)UriTemplate.of((String)"/api/pid/find", (TemplateVariables)new TemplateVariables(new TemplateVariable[]{new TemplateVariable("id", TemplateVariable.VariableType.REQUEST_PARAM)})), (String)CATEGORY)));
    }

    @PreAuthorize(value="permitAll()")
    public Page<IdentifierRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException(NAME, "findAll");
    }

    @PreAuthorize(value="permitAll()")
    public IdentifierRest findOne(Context context, String identifier) {
        throw new RepositoryMethodNotImplementedException(NAME, "findOne");
    }

    @SearchRestMethod(name="findByItem")
    @PreAuthorize(value="permitAll()")
    public Page<IdentifierRest> findByItem(@Parameter(value="uuid", required=true) String uuid, Pageable pageable) {
        Context context = this.obtainContext();
        ArrayList<IdentifierRest> results = new ArrayList<IdentifierRest>();
        try {
            DSpaceObject dso = this.itemService.find(context, UUID.fromString(uuid));
            String handle = dso.getHandle();
            DOI doi = this.doiService.findDOIByDSpaceObject(context, dso);
            if (doi != null) {
                String doiUrl = this.doiService.DOIToExternalForm(doi.getDoi());
                results.add(new IdentifierRest(doiUrl, "doi", DOIIdentifierProvider.statusText[doi.getStatus()]));
            }
            if (handle != null) {
                String handleUrl = this.handleService.getCanonicalForm(handle);
                results.add(new IdentifierRest(handleUrl, "handle", null));
            }
        }
        catch (SQLException | IdentifierException e) {
            throw new LinkNotFoundException(CATEGORY, NAME, uuid);
        }
        return new PageImpl(results, pageable, (long)results.size());
    }

    protected IdentifierRest createAndReturn(Context context, List<String> list) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        HttpServletRequest request = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        String type = request.getParameter("type");
        if (!"doi".equals(type)) {
            throw new NotSupportedException("Only identifiers of type 'doi' are supported");
        }
        IdentifierRest identifierRest = new IdentifierRest();
        try {
            Item item = (Item)this.uriListHandlerService.handle(context, request, list, Item.class);
            if (item == null) {
                throw new UnprocessableEntityException("No DSpace Item found, the uri-list does not contain a valid resource");
            }
            DOI doi = this.doiService.findDOIByDSpaceObject(context, (DSpaceObject)item);
            if (doi != null && null != doi.getStatus() && !DOIIdentifierProvider.MINTED.equals(doi.getStatus()) && !DOIIdentifierProvider.PENDING.equals(doi.getStatus())) {
                throw new DSpaceBadRequestException("The DOI is already registered or queued to be registered");
            }
            identifierRest = this.registerDOI(context, item);
        }
        catch (AuthorizeException e) {
            throw new RESTAuthorizationException(e);
        }
        return identifierRest;
    }

    private IdentifierRest registerDOI(Context context, Item item) throws SQLException, AuthorizeException {
        IdentifierRest identifierRest;
        block4: {
            String identifier = null;
            identifierRest = new IdentifierRest();
            identifierRest.setIdentifierType("doi");
            try {
                DOIIdentifierProvider doiIdentifierProvider = (DOIIdentifierProvider)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("org.dspace.identifier.DOIIdentifierProvider", DOIIdentifierProvider.class);
                if (doiIdentifierProvider != null) {
                    String doiValue = doiIdentifierProvider.register(context, (DSpaceObject)item, (Filter)new TrueFilter());
                    identifierRest.setValue(doiValue);
                    DOI doi = this.doiService.findByDoi(context, doiValue);
                    if (doi != null) {
                        identifierRest.setIdentifierStatus(DOIIdentifierProvider.statusText[doi.getStatus()]);
                    }
                    break block4;
                }
                throw new IllegalStateException("No DOI provider is configured");
            }
            catch (IdentifierException e) {
                throw new IllegalStateException("Failed to register identifier: " + identifier);
            }
        }
        this.itemService.updateLastModified(context, (DSpaceObject)item);
        context.complete();
        return identifierRest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"find"}, params={"id"})
    public void getDSObyIdentifier(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") String id) throws IOException, SQLException {
        Context context = ContextUtil.obtainContext((HttpServletRequest)request);
        IdentifierService identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
        try {
            DSpaceObject dso = identifierService.resolve(context, id);
            if (dso != null) {
                DSpaceObjectRest dsor = (DSpaceObjectRest)this.converter.toRest((Object)dso, this.utils.obtainProjection());
                URI link = ((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo((Class)dsor.getController(), (Object[])new Object[]{dsor.getCategory(), English.plural((String)dsor.getType())}).slash((Object)dsor.getId())).toUri();
                response.setStatus(302);
                response.sendRedirect(link.toString());
            } else {
                response.setStatus(404);
            }
        }
        catch (IdentifierNotFoundException e) {
            response.setStatus(404);
        }
        catch (IdentifierNotResolvableException e) {
            response.setStatus(501);
        }
        finally {
            context.abort();
        }
    }

    public Class<IdentifierRest> getDomainClass() {
        return IdentifierRest.class;
    }
}

