/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemEmailNotifier;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.rest.converter.RequestItemConverter;
import org.dspace.app.rest.exception.IncompleteItemRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RequestItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;

@Component(value="tools.itemrequest")
public class RequestItemRepository
extends DSpaceRestRepository<RequestItemRest, String> {
    private static final Logger LOG = LogManager.getLogger();
    @Autowired(required=true)
    protected RequestItemService requestItemService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected RequestItemConverter requestItemConverter;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected RequestItemEmailNotifier requestItemEmailNotifier;

    @PreAuthorize(value="permitAll()")
    public RequestItemRest findOne(Context context, String token) {
        RequestItem requestItem = this.requestItemService.findByToken(context, token);
        if (null == requestItem) {
            return null;
        }
        return this.requestItemConverter.convert(requestItem, Projection.DEFAULT);
    }

    public Page<RequestItemRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("itemrequest", "findAll");
    }

    @PreAuthorize(value="permitAll()")
    public RequestItemRest createAndReturn(Context ctx) throws AuthorizeException, SQLException {
        String responseLink;
        String email;
        String itemId;
        Bitstream bitstream;
        RequestItemRest rir;
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        try {
            rir = (RequestItemRest)mapper.readValue((InputStream)req.getInputStream(), RequestItemRest.class);
        }
        catch (IOException ex) {
            throw new UnprocessableEntityException("error parsing the body", (Throwable)ex);
        }
        EPerson user = ctx.getCurrentUser();
        String allowed = this.configurationService.getProperty("request.item.type", "logged");
        if ("logged".equalsIgnoreCase(allowed) && null == user) {
            throw new AuthorizeException("Anonymous requests are not permitted.");
        }
        boolean allFiles = rir.isAllfiles();
        if (!allFiles) {
            String bitstreamId = rir.getBitstreamId();
            if (StringUtils.isBlank((CharSequence)bitstreamId)) {
                throw new IncompleteItemRequestException("A bitstream ID is required");
            }
            bitstream = this.bitstreamService.find(ctx, UUID.fromString(bitstreamId));
            if (null == bitstream) {
                throw new IncompleteItemRequestException("That bitstream does not exist");
            }
        } else {
            bitstream = null;
        }
        if (StringUtils.isBlank((CharSequence)(itemId = rir.getItemId()))) {
            throw new IncompleteItemRequestException("An item ID is required");
        }
        Item item = (Item)this.itemService.find(ctx, UUID.fromString(itemId));
        if (null == item) {
            throw new IncompleteItemRequestException("That item does not exist");
        }
        if (null != user) {
            email = user.getEmail();
        } else {
            email = rir.getRequestEmail();
            if (StringUtils.isBlank((CharSequence)email)) {
                throw new IncompleteItemRequestException("A submitter's email address is required");
            }
            EmailValidator emailValidator = EmailValidator.getInstance((boolean)false, (boolean)false);
            if (!emailValidator.isValid(email)) {
                throw new UnprocessableEntityException("Invalid email address");
            }
        }
        String username = null != user ? user.getFullName() : HtmlUtils.htmlEscape((String)rir.getRequestName(), (String)"UTF-8");
        String message = HtmlUtils.htmlEscape((String)rir.getRequestMessage(), (String)"UTF-8");
        String token = this.requestItemService.createRequest(ctx, bitstream, item, allFiles, email, username, message);
        RequestItem ri = this.requestItemService.findByToken(ctx, token);
        ri.setAccept_request(false);
        this.requestItemService.update(ctx, ri);
        try {
            responseLink = this.getLinkTokenEmail(ri.getToken());
        }
        catch (MalformedURLException | URISyntaxException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getMessage;
            LOG.warn("Impossible URL error while composing email:  {}", supplierArray);
            throw new RuntimeException("Request not sent:  " + e.getMessage());
        }
        try {
            this.requestItemEmailNotifier.sendRequest(ctx, ri, responseLink);
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException("Request not sent.", ex);
        }
        return null;
    }

    public void delete(Context context, String token) throws AuthorizeException, RepositoryMethodNotImplementedException {
        throw new RepositoryMethodNotImplementedException("itemrequest", "delete");
    }

    @PreAuthorize(value="permitAll()")
    public RequestItemRest put(Context context, HttpServletRequest request, String apiCategory, String model, String token, JsonNode requestBody) throws AuthorizeException {
        RequestItem ri = this.requestItemService.findByToken(context, token);
        if (null == ri) {
            throw new UnprocessableEntityException("Item request not found");
        }
        Date decisionDate = ri.getDecision_date();
        if (null != decisionDate) {
            throw new UnprocessableEntityException("Request was " + (ri.isAccept_request() ? "granted" : "denied") + " on " + decisionDate + " and may not be updated.");
        }
        JsonNode acceptRequestNode = requestBody.findValue("acceptRequest");
        if (null == acceptRequestNode) {
            throw new UnprocessableEntityException("acceptRequest is required");
        }
        ri.setAccept_request(acceptRequestNode.asBoolean());
        JsonNode responseMessageNode = requestBody.findValue("responseMessage");
        String message = null;
        if (responseMessageNode != null && !responseMessageNode.isNull()) {
            message = responseMessageNode.asText();
        }
        JsonNode responseSubjectNode = requestBody.findValue("subject");
        String subject = null;
        if (responseSubjectNode != null && !responseSubjectNode.isNull()) {
            subject = responseSubjectNode.asText();
        }
        ri.setDecision_date(new Date());
        this.requestItemService.update(context, ri);
        try {
            this.requestItemEmailNotifier.sendResponse(context, ri, subject, message);
        }
        catch (IOException ex) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = ex::getMessage;
            LOG.warn("Response not sent:  {}", supplierArray);
            throw new RuntimeException("Response not sent", ex);
        }
        if (requestBody.findValue("suggestOpenAccess").asBoolean(false)) {
            try {
                this.requestItemEmailNotifier.requestOpenAccess(context, ri);
            }
            catch (IOException ex) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = ex::getMessage;
                LOG.warn("Open access request not sent:  {}", supplierArray);
                throw new RuntimeException("Open access request not sent", ex);
            }
        }
        RequestItemRest rir = this.requestItemConverter.convert(ri, Projection.DEFAULT);
        return rir;
    }

    public Class<RequestItemRest> getDomainClass() {
        return RequestItemRest.class;
    }

    private String getLinkTokenEmail(String token) throws URISyntaxException, MalformedURLException {
        String base = this.configurationService.getProperty("dspace.ui.url");
        URI link = new URIBuilder(base).setPathSegments(new String[]{"request-a-copy", token}).build();
        return link.toURL().toExternalForm();
    }
}

