/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.profile.ResearcherProfile;
import org.dspace.profile.service.ResearcherProfileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.profile.item")
public class ResearcherProfileItemLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private ResearcherProfileService researcherProfileService;

    @PreAuthorize(value="hasPermission(#id, 'PROFILE', 'READ')")
    public ItemRest getItem(@Nullable HttpServletRequest request, UUID id, @Nullable Pageable pageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            ResearcherProfile profile = this.researcherProfileService.findById(context, id);
            if (profile == null) {
                throw new ResourceNotFoundException("No such item related to a profile with EPerson UUID: " + id);
            }
            return (ItemRest)this.converter.toRest((Object)profile.getItem(), projection);
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }
}

