/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.workspaceitem.item")
public class WorkspaceItemItemLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    WorkspaceItemService wis;

    @PreAuthorize(value="hasPermission(#id, 'WORKSPACEITEM', 'READ')")
    public ItemRest getWorkspaceItemItem(@Nullable HttpServletRequest request, Integer id, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            WorkspaceItem witem = this.wis.find(context, id.intValue());
            if (witem == null) {
                throw new ResourceNotFoundException("No such workspace item: " + id);
            }
            return (ItemRest)this.converter.toRest((Object)witem.getItem(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

