/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.CollectionRest;
import org.dspace.app.rest.model.CommunityRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="administratorOf", description="It can be used for verify that an user has access to the administrative features of the repository or of a specific community and collection")
public class AdministratorOfFeature
implements AuthorizationFeature {
    public static final String NAME = "administratorOf";
    @Autowired
    AuthorizeService authService;
    @Autowired
    private Utils utils;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException {
        if (object != null) {
            if (object instanceof CommunityRest) {
                Community community = (Community)this.utils.getDSpaceAPIObjectFromRest(context, object);
                return this.authService.isAdmin(context, (DSpaceObject)community);
            }
            if (object instanceof CollectionRest) {
                Collection collection = (Collection)this.utils.getDSpaceAPIObjectFromRest(context, object);
                return this.authService.isAdmin(context, (DSpaceObject)collection);
            }
            if (object instanceof ItemRest) {
                Item item = (Item)this.utils.getDSpaceAPIObjectFromRest(context, object);
                return this.authService.isAdmin(context, (DSpaceObject)item);
            }
        }
        return this.authService.isAdmin(context);
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.site", "core.community", "core.collection", "core.item"};
    }
}

